/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.codec;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.lang.ExceptionUtils;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtils {
    private static final String AES = "AES";
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final int DEFAULT_IVSIZE = 16;
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final byte[] DEFAULT_KEY = new byte[]{-97, 88, -94, 9, 70, -76, 126, 25, 0, 3, -20, 113, 108, 28, 69, 125};

    public static String genKeyString() {
        return EncodeUtils.encodeHex(AesUtils.genKey(128));
    }

    public static String encode(String input) {
        try {
            return EncodeUtils.encodeHex(AesUtils.encode(input.getBytes(DEFAULT_URL_ENCODING), DEFAULT_KEY));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encode(String input, String key) {
        try {
            return EncodeUtils.encodeHex(AesUtils.encode(input.getBytes(DEFAULT_URL_ENCODING), EncodeUtils.decodeHex(key)));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String decode(String input) {
        try {
            return new String(AesUtils.decode(EncodeUtils.decodeHex(input), DEFAULT_KEY), DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String decode(String input, String key) {
        try {
            return new String(AesUtils.decode(EncodeUtils.decodeHex(input), EncodeUtils.decodeHex(key)), DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] genKey() {
        return AesUtils.genKey(128);
    }

    public static byte[] genKey(int keysize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            keyGenerator.init(keysize);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static byte[] genIV() {
        byte[] bytes = new byte[16];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    public static byte[] encode(byte[] input, byte[] key) {
        return AesUtils.aes(input, key, 1);
    }

    public static byte[] encode(byte[] input, byte[] key, byte[] iv) {
        return AesUtils.aes(input, key, iv, 1);
    }

    public static byte[] decode(byte[] input, byte[] key) {
        return AesUtils.aes(input, key, 2);
    }

    public static byte[] decode(byte[] input, byte[] key, byte[] iv) {
        return AesUtils.aes(input, key, iv, 2);
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(AES_CBC);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }
}

