/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.msg;

import com.jeesite.common.io.PropertiesUtils;
import org.apache.commons.mail.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtils {
    private static final Logger logger = LoggerFactory.getLogger(EmailUtils.class);

    public static boolean send(String toAddress, String subject, String content) {
        PropertiesUtils props = PropertiesUtils.getInstance();
        String fromAddress = props.getProperty("msg.email.fromAddress");
        String fromPassword = props.getProperty("msg.email.fromPassword");
        String fromHostName = props.getProperty("msg.email.fromHostName");
        String sslOnConnect = props.getProperty("msg.email.sslOnConnect", "false");
        String sslSmtpPort = props.getProperty("msg.email.sslSmtpPort");
        return EmailUtils.send(fromAddress, fromPassword, fromHostName, sslOnConnect, sslSmtpPort, toAddress, subject, content);
    }

    public static boolean send(String fromAddress, String fromPassword, String fromHostName, String sslOnConnect, String sslSmtpPort, String toAddress, String subject, String content) {
        try {
            HtmlEmail htmlEmail = new HtmlEmail();
            htmlEmail.setFrom(fromAddress);
            htmlEmail.setAuthentication(fromAddress, fromPassword);
            htmlEmail.setHostName(fromHostName);
            if ("true".equals(sslOnConnect)) {
                htmlEmail.setSSLOnConnect(true);
                htmlEmail.setSslSmtpPort(sslSmtpPort);
            }
            htmlEmail.addTo(toAddress);
            htmlEmail.setSubject(subject);
            htmlEmail.setMsg(content);
            htmlEmail.setCharset("utf-8");
            htmlEmail.send();
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

