/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.reflect;

import com.jeesite.common.reflect.ClassUtils;
import com.jeesite.common.reflect.VFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DefaultVFS
extends VFS {
    private static final Log log = LogFactory.getLog(ClassUtils.class);
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    DefaultVFS() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(URL url, String path) throws IOException {
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                log.debug((Object)("Listing " + url));
                resources = this.listResources(new JarInputStream(is), path);
            } else {
                List<String> children = new ArrayList<String>();
                try {
                    if (this.isJar(url)) {
                        JarEntry entry;
                        is = url.openStream();
                        JarInputStream jarInput = new JarInputStream(is);
                        log.debug((Object)("Listing " + url));
                        while ((entry = jarInput.getNextJarEntry()) != null) {
                            log.debug((Object)("Jar entry: " + entry.getName()));
                            children.add(entry.getName());
                        }
                    } else {
                        String line;
                        is = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            log.debug((Object)("Reader entry: " + line));
                            lines.add(line);
                            if (!DefaultVFS.getResources(path + "/" + line).isEmpty()) continue;
                            lines.clear();
                            break;
                        }
                        if (!lines.isEmpty()) {
                            log.debug((Object)("Listing " + url));
                            children.addAll(lines);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    if ("file".equals(url.getProtocol())) {
                        File file = new File(url.getFile());
                        log.debug((Object)("Listing directory " + file.getAbsolutePath()));
                        if (file.isDirectory()) {
                            log.debug((Object)("Listing " + url));
                            children = Arrays.asList(file.list());
                        }
                    }
                    throw e;
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String child : children) {
                    String resourcePath = path + "/" + child;
                    resources.add(resourcePath);
                    URL childUrl = new URL(prefix + child);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!name.startsWith(path)) continue;
            log.debug((Object)("Found resource: " + name));
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url) throws MalformedURLException {
        log.debug((Object)("Find JAR URL: " + url));
        try {
            while (true) {
                url = new URL(url.getFile());
                log.debug((Object)("Inner URL: " + url));
            }
        }
        catch (MalformedURLException malformedURLException) {
            StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
            int index = jarUrl.lastIndexOf(".jar");
            if (index < 0) {
                log.debug((Object)("Not a JAR: " + jarUrl));
                return null;
            }
            jarUrl.setLength(index + 4);
            log.debug((Object)("Extracted JAR URL: " + jarUrl));
            try {
                URL testUrl = new URL(jarUrl.toString());
                if (this.isJar(testUrl)) {
                    return testUrl;
                }
                log.debug((Object)("Not a JAR: " + jarUrl));
                jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
                File file = new File(jarUrl.toString());
                if (!file.exists()) {
                    try {
                        file = new File(URLEncoder.encode(jarUrl.toString(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
                    }
                }
                if (file.exists()) {
                    log.debug((Object)("Trying real file: " + file.getAbsolutePath()));
                    testUrl = file.toURI().toURL();
                    if (this.isJar(testUrl)) {
                        return testUrl;
                    }
                }
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Invalid JAR URL: " + jarUrl));
            }
            log.debug((Object)("Not a JAR: " + jarUrl));
            return null;
        }
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                log.debug((Object)("Found JAR: " + url));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }
}

