/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.ueditor.hunter;

import com.jeesite.common.ueditor.PathFormat;
import com.jeesite.common.ueditor.define.BaseState;
import com.jeesite.common.ueditor.define.MultiState;
import com.jeesite.common.ueditor.define.State;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;

public class FileManager {
    public static final String USERFILES_BASE_URL = "/userfiles/";
    private String dir = null;
    private String rootPath = null;
    private String[] allowFiles = null;
    private int count = 0;

    public FileManager(Map<String, Object> conf) {
        this.rootPath = (String)conf.get("rootPath");
        this.dir = this.rootPath + (String)conf.get("dir");
        this.allowFiles = this.getAllowFiles(conf.get("allowFiles"));
        this.count = (Integer)conf.get("count");
    }

    public State listFile(HttpServletRequest request, int index) {
        File dir = new File(PathFormat.parse(this.dir));
        State state = null;
        if (!dir.exists()) {
            return new BaseState(false, 302);
        }
        if (!dir.isDirectory()) {
            return new BaseState(false, 301);
        }
        Collection list = FileUtils.listFiles((File)dir, (String[])this.allowFiles, (boolean)true);
        if (index < 0 || index > list.size()) {
            state = new MultiState(true);
        } else {
            Object[] fileList = Arrays.copyOfRange(list.toArray(), index, index + this.count);
            state = this.getState(request, fileList);
        }
        state.putInfo("start", index);
        state.putInfo("total", list.size());
        return state;
    }

    private State getState(HttpServletRequest request, Object[] files) {
        MultiState state = new MultiState(true);
        BaseState fileState = null;
        File file = null;
        for (Object obj : files) {
            if (obj == null) break;
            file = (File)obj;
            fileState = new BaseState(true);
            String url = PathFormat.format(this.getPath(file));
            int index = url.indexOf(USERFILES_BASE_URL);
            if (index > 0) {
                url = url.substring(index + USERFILES_BASE_URL.length());
            }
            fileState.putInfo("url", request.getContextPath() + USERFILES_BASE_URL + url);
            state.addState(fileState);
        }
        return state;
    }

    private String getPath(File file) {
        String path = file.getAbsolutePath();
        return path.replace(this.rootPath, "/");
    }

    private String[] getAllowFiles(Object fileExt) {
        String[] exts = null;
        String ext = null;
        if (fileExt == null) {
            return new String[0];
        }
        exts = (String[])fileExt;
        int len = exts.length;
        for (int i = 0; i < len; ++i) {
            ext = exts[i];
            exts[i] = ext.replace(".", "");
        }
        return exts;
    }
}

