/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.utils.word;

import com.jeesite.common.utils.word.BookMark;
import com.jeesite.common.utils.word.BookMarks;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHeight;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrPr;
import org.w3c.dom.Node;

public class WordExport {
    private XWPFDocument document;
    private BookMarks bookMarks = null;

    public void setTemplate(String templatePath) {
        try {
            this.document = new XWPFDocument(POIXMLDocument.openPackage((String)templatePath));
            this.bookMarks = new BookMarks(this.document);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void replaceBookMark(Map<String, String> indicator) {
        Iterator<String> bookMarkIter = this.bookMarks.getNameIterator();
        while (bookMarkIter.hasNext()) {
            String bookMarkName = bookMarkIter.next();
            BookMark bookMark = this.bookMarks.getBookmark(bookMarkName);
            if (indicator.get(bookMarkName) == null) continue;
            bookMark.insertTextAtBookMark(indicator.get(bookMarkName), 1);
        }
    }

    public void fillTableAtBookMark(String bookMarkName, List<Map<String, String>> content) {
        int rowNum = 0;
        BookMark bookMark = this.bookMarks.getBookmark(bookMarkName);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        HashMap<String, Node> styleNode = new HashMap<String, Node>();
        if (bookMark.isInTable()) {
            int i;
            XWPFTable table = bookMark.getContainerTable();
            XWPFTableRow row = bookMark.getContainerTableRow();
            List rowCell = row.getTableCells();
            for (i = 0; i < rowCell.size(); ++i) {
                columnMap.put(i + "", ((XWPFTableCell)rowCell.get(i)).getText().trim());
                Node node1 = ((XWPFParagraph)((XWPFTableCell)rowCell.get(i)).getParagraphs().get(0)).getCTP().getDomNode();
                for (int x = 0; x < node1.getChildNodes().getLength(); ++x) {
                    if (!node1.getChildNodes().item(x).getNodeName().equals("w:r")) continue;
                    Node node2 = node1.getChildNodes().item(x);
                    for (int y = 0; y < node2.getChildNodes().getLength(); ++y) {
                        if (!node2.getChildNodes().item(y).getNodeName().endsWith("w:rPr")) continue;
                        styleNode.put(i + "", node2.getChildNodes().item(y));
                    }
                }
            }
            for (i = 0; i < table.getNumberOfRows(); ++i) {
                if (!table.getRow(i).equals(row)) continue;
                rowNum = i;
                break;
            }
            table.removeRow(rowNum);
            for (i = 0; i < content.size(); ++i) {
                XWPFTableRow tableRow = table.createRow();
                CTTrPr trPr = tableRow.getCtRow().addNewTrPr();
                CTHeight ht = trPr.addNewTrHeight();
                ht.setVal(BigInteger.valueOf(360L));
            }
            int rcount = table.getNumberOfRows();
            for (int i2 = rowNum; i2 < rcount; ++i2) {
                int j;
                XWPFTableRow newRow = table.getRow(i2);
                if (newRow.getTableCells().size() != rowCell.size()) {
                    int sub = Math.abs(newRow.getTableCells().size() - rowCell.size());
                    for (j = 0; j < sub; ++j) {
                        newRow.addNewTableCell();
                    }
                }
                List cells = newRow.getTableCells();
                for (j = 0; j < cells.size(); ++j) {
                    XWPFParagraph para = (XWPFParagraph)((XWPFTableCell)cells.get(j)).getParagraphs().get(0);
                    XWPFRun run = para.createRun();
                    if (content.get(i2 - rowNum).get(columnMap.get(j + "")) != null) {
                        run.setText(content.get(i2 - rowNum).get(columnMap.get(j + "")) + "");
                        run.getCTR().getDomNode().insertBefore(((Node)styleNode.get(j + "")).cloneNode(true), run.getCTR().getDomNode().getFirstChild());
                    }
                    para.setAlignment(ParagraphAlignment.CENTER);
                }
            }
        }
    }

    public void replaceText(Map<String, String> bookmarkMap, String bookMarkName) {
        BookMark bookMark = this.bookMarks.getBookmark(bookMarkName);
        XWPFTable table = bookMark.getContainerTable();
        if (table != null) {
            int rcount = table.getNumberOfRows();
            for (int i = 0; i < rcount; ++i) {
                XWPFTableRow row = table.getRow(i);
                List cells = row.getTableCells();
                for (XWPFTableCell c : cells) {
                    for (Map.Entry<String, String> e : bookmarkMap.entrySet()) {
                        if (!c.getText().equals(e.getKey())) continue;
                        c.removeParagraph(0);
                        c.setText(e.getValue());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAs(String fileName) {
        File newFile = new File(fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(newFile);
            this.document.write((OutputStream)fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

