/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.web.http;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;

public class UserAgentUtils {
    public static UserAgent getUserAgent(HttpServletRequest request) {
        return UserAgent.parseUserAgentString((String)request.getHeader("User-Agent"));
    }

    public static DeviceType getDeviceType(HttpServletRequest request) {
        return UserAgentUtils.getUserAgent(request).getOperatingSystem().getDeviceType();
    }

    public static boolean isComputer(HttpServletRequest request) {
        return DeviceType.COMPUTER.equals((Object)UserAgentUtils.getDeviceType(request));
    }

    public static boolean isMobile(HttpServletRequest request) {
        return DeviceType.MOBILE.equals((Object)UserAgentUtils.getDeviceType(request));
    }

    public static boolean isTablet(HttpServletRequest request) {
        return DeviceType.TABLET.equals((Object)UserAgentUtils.getDeviceType(request));
    }

    public static boolean isMobileOrTablet(HttpServletRequest request) {
        DeviceType deviceType = UserAgentUtils.getDeviceType(request);
        return DeviceType.MOBILE.equals((Object)deviceType) || DeviceType.TABLET.equals((Object)deviceType);
    }

    public static Browser getBrowser(HttpServletRequest request) {
        return UserAgentUtils.getUserAgent(request).getBrowser();
    }

    public static boolean isLteIE8(HttpServletRequest request) {
        Browser browser = UserAgentUtils.getBrowser(request);
        return Browser.IE5.equals((Object)browser) || Browser.IE6.equals((Object)browser) || Browser.IE7.equals((Object)browser) || Browser.IE8.equals((Object)browser);
    }
}

