/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.codec;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.ExceptionUtils;
import com.jeesite.common.lang.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodeUtils {
    private static final Logger logger = LoggerFactory.getLogger(EncodeUtils.class);
    private static final String DEFAULT_URL_ENCODING = "UTF-8";
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static List<Pattern> xssPatterns = ListUtils.newArrayList(Pattern.compile("(<\\s*(script|link|style|iframe)([\\s\\S]*?)(>|<\\/\\s*\\1\\s*>))|(</\\s*(script|link|style|iframe)\\s*>)", 2), Pattern.compile("\\s*(href|src)\\s*=\\s*(\"\\s*(javascript|vbscript):[^\"]+\"|'\\s*(javascript|vbscript):[^']+'|(javascript|vbscript):[^\\s]+)\\s*(?=>)", 2), Pattern.compile("\\s*on[a-z]+\\s*=\\s*(\"[^\"]+\"|'[^']+'|[^\\s]+)\\s*(?=>)", 2), Pattern.compile("(eval\\((.|\\n)*\\)|xpression\\((.|\\n)*\\))", 2));
    private static Pattern sqlPattern = Pattern.compile("(?:')|(?:--)|(/\\*(?:.|[\\n\\r])*?\\*/)|(\\b(select|update|and|or|delete|insert|trancate|char|into|substr|ascii|declare|exec|count|master|into|drop|execute)\\b)", 2);

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            throw ExceptionUtils.unchecked((Exception)((Object)e));
        }
    }

    public static String encodeBase64(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String encodeBase64(String input) {
        try {
            return new String(Base64.encodeBase64((byte[])input.getBytes(DEFAULT_URL_ENCODING)));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] decodeBase64(String input) {
        return Base64.decodeBase64((byte[])input.getBytes());
    }

    public static String decodeBase64String(String input) {
        try {
            return new String(Base64.decodeBase64((byte[])input.getBytes()), DEFAULT_URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String encodeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static String decodeHtml(String htmlEscaped) {
        return StringEscapeUtils.unescapeHtml4((String)htmlEscaped);
    }

    public static String encodeXml(String xml) {
        return StringEscapeUtils.escapeXml10((String)xml);
    }

    public static String decodeXml(String xmlEscaped) {
        return StringEscapeUtils.unescapeXml((String)xmlEscaped);
    }

    public static String encodeUrl(String part) {
        return EncodeUtils.encodeUrl(part, DEFAULT_URL_ENCODING);
    }

    public static String encodeUrl(String part, String encoding) {
        if (part == null) {
            return null;
        }
        try {
            return URLEncoder.encode(part, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static String decodeUrl(String part) {
        return EncodeUtils.decodeUrl(part, DEFAULT_URL_ENCODING);
    }

    public static String decodeUrl(String part, String encoding) {
        if (part == null) {
            return null;
        }
        try {
            return URLDecoder.decode(part, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static String decodeUrl2(String part) {
        return EncodeUtils.decodeUrl(EncodeUtils.decodeUrl(part));
    }

    public static String xssFilter(String text) {
        String oriValue = StringUtils.trim((String)text);
        if (text != null) {
            String value = oriValue;
            for (Pattern pattern : xssPatterns) {
                Matcher matcher = pattern.matcher(value);
                if (!matcher.find()) continue;
                value = matcher.replaceAll("");
            }
            if (!(StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)"<!--HTML-->") || StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)"<?xml ") || StringUtils.contains((CharSequence)value, (CharSequence)"id=\"FormHtml\"") || StringUtils.startsWith((CharSequence)value, (CharSequence)"{") && StringUtils.endsWith((CharSequence)value, (CharSequence)"}") || StringUtils.startsWith((CharSequence)value, (CharSequence)"[") && StringUtils.endsWith((CharSequence)value, (CharSequence)"]"))) {
                StringBuilder sb = new StringBuilder();
                block9: for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    switch (c) {
                        case '>': {
                            sb.append("\uff1e");
                            continue block9;
                        }
                        case '<': {
                            sb.append("\uff1c");
                            continue block9;
                        }
                        case '\'': {
                            sb.append("\uff07");
                            continue block9;
                        }
                        case '\"': {
                            sb.append("\uff02");
                            continue block9;
                        }
                        case '&': {
                            sb.append("\uff06");
                            continue block9;
                        }
                        case '#': {
                            sb.append("\uff03");
                            continue block9;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                value = sb.toString();
            }
            if (logger.isInfoEnabled() && !value.equals(oriValue)) {
                logger.info("xssFilter: {}   <=<=<=   {}", (Object)value, (Object)text);
            }
            return value;
        }
        return null;
    }

    public static String sqlFilter(String text) {
        if (text != null) {
            String value = text;
            Matcher matcher = sqlPattern.matcher(text);
            if (matcher.find()) {
                value = matcher.replaceAll("");
            }
            if (logger.isWarnEnabled() && !value.equals(text)) {
                logger.info("sqlFilter: {}   <=<=<=   {}", (Object)value, (Object)text);
                return "";
            }
            return value;
        }
        return null;
    }
}

