/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.io;

import com.jeesite.common.io.IOUtils;
import com.jeesite.common.lang.ExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceUtils
extends org.springframework.util.ResourceUtils {
    private static ResourceLoader resourceLoader = new DefaultResourceLoader();
    private static ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(resourceLoader);

    public static ResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static ClassLoader getClassLoader() {
        return resourceLoader.getClassLoader();
    }

    public static Resource getResource(String location) {
        return resourceLoader.getResource(location);
    }

    public static InputStream getResourceFileStream(String location) throws IOException {
        Resource resource = resourceLoader.getResource(location);
        return resource.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceFileContent(String location) {
        try (InputStream is = ResourceUtils.getResourceFileStream(location);){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static Resource[] getResources(String locationPattern) {
        try {
            Resource[] resources = resourceResolver.getResources(locationPattern);
            return resources;
        }
        catch (IOException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }
}

