/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

public class ByteUtils {
    private static final int UNIT = 1024;

    public static String formatByteSize(long byteSize) {
        if (byteSize <= -1L) {
            return String.valueOf(byteSize);
        }
        double size = 1.0 * (double)byteSize;
        String type = "B";
        if ((int)Math.floor(size / 1024.0) <= 0) {
            type = "B";
            return ByteUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "KB";
            return ByteUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "MB";
            return ByteUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "GB";
            return ByteUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "TB";
            return ByteUtils.format(size, type);
        }
        if ((int)Math.floor((size /= 1024.0) / 1024.0) <= 0) {
            type = "PB";
            return ByteUtils.format(size, type);
        }
        return ">PB";
    }

    private static String format(double size, String type) {
        int precision = 0;
        precision = size * 1000.0 % 10.0 > 0.0 ? 3 : (size * 100.0 % 10.0 > 0.0 ? 2 : (size * 10.0 % 10.0 > 0.0 ? 1 : 0));
        String formatStr = "%." + precision + "f";
        if ("KB".equals(type)) {
            return String.format(formatStr, size) + "KB";
        }
        if ("MB".equals(type)) {
            return String.format(formatStr, size) + "MB";
        }
        if ("GB".equals(type)) {
            return String.format(formatStr, size) + "GB";
        }
        if ("TB".equals(type)) {
            return String.format(formatStr, size) + "TB";
        }
        if ("PB".equals(type)) {
            return String.format(formatStr, size) + "PB";
        }
        return String.format(formatStr, size) + "B";
    }
}

