/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import com.jeesite.common.lang.ExceptionUtils;
import com.jeesite.common.lang.TimeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.nustaq.serialization.FSTConfiguration;
import org.springframework.beans.BeanUtils;
import org.springframework.core.NamedThreadLocal;

public class ObjectUtils
extends org.apache.commons.lang3.ObjectUtils {
    private static ThreadLocal<FSTConfiguration> fst = new NamedThreadLocal<FSTConfiguration>("FSTConfiguration"){

        public FSTConfiguration initialValue() {
            return FSTConfiguration.createDefaultConfiguration();
        }
    };

    public static Double toDouble(Object val) {
        if (val == null) {
            return 0.0;
        }
        try {
            return NumberUtils.toDouble((String)StringUtils.trim((String)val.toString()));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Float toFloat(Object val) {
        return Float.valueOf(ObjectUtils.toDouble(val).floatValue());
    }

    public static Long toLong(Object val) {
        return ObjectUtils.toDouble(val).longValue();
    }

    public static Integer toInteger(Object val) {
        return ObjectUtils.toLong(val).intValue();
    }

    public static Boolean toBoolean(Object val) {
        if (val == null) {
            return false;
        }
        return BooleanUtils.toBoolean((String)val.toString()) || "1".equals(val.toString());
    }

    public static String toString(Object obj) {
        return ObjectUtils.toString(obj, "");
    }

    public static String toString(Object obj, String defaultVal) {
        return obj == null ? defaultVal : obj.toString();
    }

    public static String toStringIgnoreNull(Object val) {
        return ObjectUtils.toStringIgnoreNull(val, "");
    }

    public static String toStringIgnoreNull(Object val, String defaultVal) {
        String str = ObjectUtils.toString(val);
        return !"".equals(str) && !"null".equals(str.trim().toLowerCase()) ? str : defaultVal;
    }

    public static Object copyBean(Object source, String ... ignoreProperties) {
        if (source == null) {
            return null;
        }
        try {
            Object target = source.getClass().newInstance();
            BeanUtils.copyProperties((Object)source, target, (String[])ignoreProperties);
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw ExceptionUtils.unchecked(e);
        }
    }

    public static void annotationToObject(Object annotation, Object object) {
        if (annotation != null && object != null) {
            Class<?> annotationClass = annotation.getClass();
            Class<?> objectClass = object.getClass();
            for (Method m : objectClass.getMethods()) {
                if (!StringUtils.startsWith((CharSequence)m.getName(), (CharSequence)"set")) continue;
                try {
                    String s = StringUtils.uncapitalize((String)StringUtils.substring((String)m.getName(), (int)3));
                    Object obj = annotationClass.getMethod(s, new Class[0]).invoke(annotation, new Object[0]);
                    if (obj == null || "".equals(obj.toString())) continue;
                    m.invoke(object, obj);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static byte[] serialize(Object object) {
        if (object == null) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        byte[] bytes = null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(object);
            bytes = baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long totalTime = System.currentTimeMillis() - beginTime;
        if (totalTime > 3000L) {
            System.out.println("Serialize time: " + TimeUtils.formatDateAgo(totalTime));
        }
        return bytes;
    }

    public static Object unserialize(byte[] bytes) {
        long totalTime;
        if (bytes == null) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        Object object = null;
        if (bytes.length > 0) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                 ObjectInputStream ois = new ObjectInputStream(bais);){
                object = ois.readObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((totalTime = System.currentTimeMillis() - beginTime) > 3000L) {
            System.out.println("Unserialize time: " + TimeUtils.formatDateAgo(totalTime));
        }
        return object;
    }

    public static byte[] serializeFst(Object object) {
        if (object == null) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        byte[] bytes = fst.get().asByteArray(object);
        long totalTime = System.currentTimeMillis() - beginTime;
        if (totalTime > 3000L) {
            System.out.println("Fst serialize time: " + TimeUtils.formatDateAgo(totalTime));
        }
        return bytes;
    }

    public static Object unserializeFst(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        long beginTime = System.currentTimeMillis();
        Object object = fst.get().asObject(bytes);
        long totalTime = System.currentTimeMillis() - beginTime;
        if (totalTime > 3000L) {
            System.out.println("Fst unserialize time: " + TimeUtils.formatDateAgo(totalTime));
        }
        return object;
    }

    public static Object cloneBean(Object source) {
        if (source == null) {
            return null;
        }
        byte[] bytes = ObjectUtils.serializeFst(source);
        Object target = ObjectUtils.unserializeFst(bytes);
        return target;
    }
}

