/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.reflect;

import com.jeesite.common.reflect.VFS;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassUtils {
    private static final Log log = LogFactory.getLog(ClassUtils.class);
    private Set<Class<?>> matches = new HashSet();
    private ClassLoader classloader;

    public Set<Class<?>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public static <T> Set<Class<?>> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return new HashSet();
        }
        ClassUtils cu = new ClassUtils();
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            cu.find(test, pkg);
        }
        return cu.getClasses();
    }

    public static Set<Class<?>> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return new HashSet();
        }
        ClassUtils cu = new ClassUtils();
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            cu.find(test, pkg);
        }
        return cu.getClasses();
    }

    public ClassUtils find(Test test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            List<String> children = VFS.getInstance().list(path);
            for (String child : children) {
                if (!child.endsWith(".class")) continue;
                this.addIfMatching(test, child);
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Could not read package: " + packageName), (Throwable)ioe);
        }
        return this;
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            log.debug((Object)("Checking to see if class " + externalName + " matches criteria [" + test + "]"));
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Exception t) {
            log.warn((Object)("Could not examine class '" + fqn + "' due to a " + t.getClass().getName() + " with message: " + t.getMessage()));
        }
    }

    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        @Override
        public boolean matches(Class<?> type) {
            return type != null && this.parent.isAssignableFrom(type) && !type.getName().equals(this.parent.getName()) && !Modifier.isAbstract(type.getModifiers());
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

