/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.utils.excel;

import com.jeesite.common.callback.MethodCallback;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.SetUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.reflect.ReflectUtils;
import com.jeesite.common.utils.excel.ExcelException;
import com.jeesite.common.utils.excel.annotation.ExcelField;
import com.jeesite.common.utils.excel.annotation.ExcelFields;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImport
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(ExcelImport.class);
    private Workbook wb;
    private Sheet sheet;
    private int headerNum;
    private Set<Class<?>> fieldTypes = SetUtils.newHashSet();

    public ExcelImport(File file) throws InvalidFormatException, IOException {
        this(file, 0, (Object)0);
    }

    public ExcelImport(File file, int headerNum) throws InvalidFormatException, IOException {
        this(file, headerNum, (Object)0);
    }

    public ExcelImport(File file, int headerNum, Object sheetIndexOrName) throws InvalidFormatException, IOException {
        this(file.getName(), new FileInputStream(file), headerNum, sheetIndexOrName);
    }

    public ExcelImport(MultipartFile multipartFile, int headerNum, Object sheetIndexOrName) throws InvalidFormatException, IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream(), headerNum, sheetIndexOrName);
    }

    public ExcelImport(String fileName, InputStream is, int headerNum, Object sheetIndexOrName) throws InvalidFormatException, IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new ExcelException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            this.wb = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            this.wb = new XSSFWorkbook(is);
        } else {
            throw new ExcelException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        this.setSheet(sheetIndexOrName, headerNum);
        log.debug("Initialize success.");
    }

    private void addAnnotation(List<Object[]> annotationList, ExcelField ef, Object fOrM, ExcelField.Type type, String ... groups) {
        if (ef != null && (ef.type() == ExcelField.Type.ALL || ef.type() == type)) {
            if (groups != null && groups.length > 0) {
                boolean inGroup = false;
                block0: for (String g : groups) {
                    if (!inGroup) {
                        for (String efg : ef.groups()) {
                            if (!StringUtils.equals((CharSequence)g, (CharSequence)efg)) continue;
                            inGroup = true;
                            annotationList.add(new Object[]{ef, fOrM});
                            continue block0;
                        }
                        continue;
                    }
                    break;
                }
            } else {
                annotationList.add(new Object[]{ef, fOrM});
            }
        }
    }

    public Workbook getWorkbook() {
        return this.wb;
    }

    public void setSheet(Object sheetIndexOrName, int headerNum) {
        this.sheet = sheetIndexOrName instanceof Integer || sheetIndexOrName instanceof Long ? this.wb.getSheetAt(ObjectUtils.toInteger(sheetIndexOrName).intValue()) : this.wb.getSheet(ObjectUtils.toString(sheetIndexOrName));
        if (this.sheet == null) {
            throw new ExcelException("\u6ca1\u6709\u627e\u5230\u2018" + sheetIndexOrName + "\u2019\u5de5\u4f5c\u8868!");
        }
        this.headerNum = headerNum;
    }

    public Row getRow(int rownum) {
        Row row = this.sheet.getRow(rownum);
        if (row == null) {
            return null;
        }
        int cellNum = 0;
        int emptyNum = 0;
        Iterator it = row.cellIterator();
        while (it.hasNext()) {
            cellNum = (short)(cellNum + 1);
            Cell cell = (Cell)it.next();
            if (!StringUtils.isBlank((CharSequence)cell.toString())) continue;
            emptyNum = (short)(emptyNum + 1);
        }
        if (cellNum == emptyNum) {
            return null;
        }
        return row;
    }

    public int getDataRowNum() {
        return this.headerNum;
    }

    public int getLastDataRowNum() {
        return this.sheet.getLastRowNum() + 1;
    }

    public int getLastCellNum() {
        Row row = this.getRow(this.headerNum);
        return row == null ? (short)0 : row.getLastCellNum();
    }

    public Object getCellValue(Row row, int column) {
        if (row == null) {
            return row;
        }
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (cell != null) {
                if (cell.getCellType() == 0) {
                    val = cell.getNumericCellValue();
                    val = HSSFDateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)((Double)val)) : ((Double)val % 1.0 > 0.0 ? new DecimalFormat("0.00").format(val) : new DecimalFormat("0").format(val));
                } else if (cell.getCellType() == 1) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == 2) {
                    try {
                        val = cell.getStringCellValue();
                    }
                    catch (Exception e) {
                        FormulaEvaluator evaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
                        evaluator.evaluateFormulaCell(cell);
                        CellValue cellValue = evaluator.evaluate(cell);
                        switch (cellValue.getCellType()) {
                            case 0: {
                                val = cellValue.getNumberValue();
                                break;
                            }
                            case 1: {
                                val = cellValue.getStringValue();
                                break;
                            }
                            case 4: {
                                val = cellValue.getBooleanValue();
                                break;
                            }
                            case 5: {
                                val = ErrorEval.getText((int)cellValue.getErrorValue());
                                break;
                            }
                            default: {
                                val = cell.getCellFormula();
                                break;
                            }
                        }
                    }
                } else if (cell.getCellType() == 4) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == 5) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public <E> List<E> getDataList(Class<E> cls, String ... groups) throws InstantiationException, IllegalAccessException {
        return this.getDataList(cls, false, groups);
    }

    public <E> List<E> getDataList(Class<E> cls, final boolean isThrowException, String ... groups) throws InstantiationException, IllegalAccessException {
        return this.getDataList(cls, new MethodCallback(){

            @Override
            public Object execute(Object ... params) {
                if (isThrowException) {
                    Exception ex = (Exception)params[0];
                    int rowNum = (Integer)params[1];
                    int columnNum = (Integer)params[2];
                    throw new ExcelException("Get cell value [" + rowNum + "," + columnNum + "]", ex);
                }
                return null;
            }
        }, groups);
    }

    public <E> List<E> getDataList(Class<E> cls, MethodCallback exceptionCallback, String ... groups) throws InstantiationException, IllegalAccessException {
        Method[] ms;
        Field[] fs;
        ArrayList<Object[]> annotationList = ListUtils.newArrayList();
        for (Field f : fs = cls.getDeclaredFields()) {
            ExcelFields efs = f.getAnnotation(ExcelFields.class);
            if (efs != null && efs.value() != null) {
                for (ExcelField ef : efs.value()) {
                    this.addAnnotation(annotationList, ef, f, ExcelField.Type.IMPORT, groups);
                }
            }
            ExcelField ef = f.getAnnotation(ExcelField.class);
            this.addAnnotation(annotationList, ef, f, ExcelField.Type.IMPORT, groups);
        }
        for (Method m : ms = cls.getDeclaredMethods()) {
            ExcelFields efs = m.getAnnotation(ExcelFields.class);
            if (efs != null && efs.value() != null) {
                for (ExcelField ef : efs.value()) {
                    this.addAnnotation(annotationList, ef, m, ExcelField.Type.IMPORT, groups);
                }
            }
            ExcelField ef = m.getAnnotation(ExcelField.class);
            this.addAnnotation(annotationList, ef, m, ExcelField.Type.IMPORT, groups);
        }
        Collections.sort(annotationList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return new Integer(((ExcelField)o1[0]).sort()).compareTo(new Integer(((ExcelField)o2[0]).sort()));
            }
        });
        ArrayList<E> dataList = ListUtils.newArrayList();
        for (int i = this.getDataRowNum(); i < this.getLastDataRowNum(); ++i) {
            E e = cls.newInstance();
            Row row = this.getRow(i);
            if (row == null) continue;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < annotationList.size(); ++j) {
                Object[] os = (Object[])annotationList.get(j);
                ExcelField ef = (ExcelField)os[0];
                int column = ef.column() != -1 ? ef.column() : j;
                Object val = this.getCellValue(row, column);
                if (val != null) {
                    if (StringUtils.isNotBlank((CharSequence)ef.dictType())) {
                        try {
                            Class<?> dictUtils = Class.forName("com.jeesite.modules.sys.utils.DictUtils");
                            val = dictUtils.getMethod("getDictValue", String.class, String.class, String.class).invoke(null, ef.dictType(), val.toString(), "");
                        }
                        catch (Exception ex) {
                            log.info("Get cell value [" + i + "," + column + "] error: " + ex.toString());
                            val = null;
                        }
                    }
                    Class valType = Class.class;
                    if (os[1] instanceof Field) {
                        valType = ((Field)os[1]).getType();
                    } else if (os[1] instanceof Method) {
                        Method method = (Method)os[1];
                        if ("get".equals(method.getName().substring(0, 3))) {
                            valType = method.getReturnType();
                        } else if ("set".equals(method.getName().substring(0, 3))) {
                            valType = ((Method)os[1]).getParameterTypes()[0];
                        }
                    }
                    try {
                        if (StringUtils.isNotBlank((CharSequence)ef.attrName())) {
                            if (ef.fieldType() != Class.class) {
                                this.fieldTypes.add(ef.fieldType());
                                val = ef.fieldType().getMethod("getValue", String.class).invoke(null, val);
                            }
                        } else if (val != null) {
                            if (valType == String.class) {
                                String s = String.valueOf(val.toString());
                                val = StringUtils.endsWith((CharSequence)s, (CharSequence)".0") ? StringUtils.substringBefore((String)s, (String)".0") : String.valueOf(val.toString());
                            } else if (valType == Integer.class) {
                                val = Double.valueOf(val.toString()).intValue();
                            } else if (valType == Long.class) {
                                val = Double.valueOf(val.toString()).longValue();
                            } else if (valType == Double.class) {
                                val = Double.valueOf(val.toString());
                            } else if (valType == Float.class) {
                                val = Float.valueOf(val.toString());
                            } else if (valType == Date.class) {
                                if (val instanceof String) {
                                    val = DateUtils.parseDate(val);
                                } else if (val instanceof Double) {
                                    val = DateUtil.getJavaDate((double)((Double)val));
                                }
                            } else if (ef.fieldType() != Class.class) {
                                this.fieldTypes.add(ef.fieldType());
                                val = ef.fieldType().getMethod("getValue", String.class).invoke(null, val.toString());
                            } else {
                                Class<?> fieldType2 = Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + valType.getSimpleName() + "Type"));
                                this.fieldTypes.add(fieldType2);
                                val = fieldType2.getMethod("getValue", String.class).invoke(null, val.toString());
                            }
                        }
                    }
                    catch (Exception ex) {
                        log.info("Get cell value [" + i + "," + column + "] error: " + ex.toString());
                        val = null;
                        exceptionCallback.execute(ex, i, column);
                    }
                    if (StringUtils.isNotBlank((CharSequence)ef.attrName())) {
                        ReflectUtils.invokeSetter(e, ef.attrName(), val);
                    } else if (os[1] instanceof Field) {
                        ReflectUtils.invokeSetter(e, ((Field)os[1]).getName(), val);
                    } else if (os[1] instanceof Method) {
                        String mthodName = ((Method)os[1]).getName();
                        if ("get".equals(mthodName.substring(0, 3))) {
                            mthodName = "set" + StringUtils.substringAfter((String)mthodName, (String)"get");
                        }
                        ReflectUtils.invokeMethod(e, mthodName, new Class[]{valType}, new Object[]{val});
                    }
                }
                sb.append(val + ", ");
            }
            dataList.add(e);
            log.debug("Read success: [" + i + "] " + sb.toString());
        }
        return dataList;
    }

    @Override
    public void close() {
        for (Class<?> clazz : this.fieldTypes) {
            try {
                clazz.getMethod("clearCache", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception exception) {}
        }
    }
}

