/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.utils.excel.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface ExcelField {
    public String attrName() default "";

    public String title();

    public Type type() default Type.ALL;

    public Align align() default Align.AUTO;

    public int width() default -1;

    public int sort() default 0;

    public int column() default -1;

    public String dictType() default "";

    public Class<?> fieldType() default Class.class;

    public String dataFormat() default "@";

    public String[] groups() default {};

    public String imagePath() default "";

    public static enum Align {
        AUTO(0),
        LEFT(1),
        CENTER(2),
        RIGHT(3);

        private final int value;

        private Align(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Type {
        ALL(0),
        EXPORT(1),
        IMPORT(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

