/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.utils.word;

import java.util.List;
import java.util.Stack;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookMark {
    public static final int INSERT_AFTER = 0;
    public static final int INSERT_BEFORE = 1;
    public static final int REPLACE = 2;
    public static final String RUN_NODE_NAME = "w:r";
    public static final String TEXT_NODE_NAME = "w:t";
    public static final String BOOKMARK_START_TAG = "bookmarkStart";
    public static final String BOOKMARK_END_TAG = "bookmarkEnd";
    public static final String BOOKMARK_ID_ATTR_NAME = "w:id";
    public static final String STYLE_NODE_NAME = "w:rPr";
    private CTBookmark _ctBookmark = null;
    private XWPFParagraph _para = null;
    private XWPFTableCell _tableCell = null;
    private String _bookmarkName = null;
    private boolean _isCell = false;

    public BookMark(CTBookmark ctBookmark, XWPFParagraph para) {
        this._ctBookmark = ctBookmark;
        this._para = para;
        this._bookmarkName = ctBookmark.getName();
        this._tableCell = null;
        this._isCell = false;
    }

    public BookMark(CTBookmark ctBookmark, XWPFParagraph para, XWPFTableCell tableCell) {
        this(ctBookmark, para);
        this._tableCell = tableCell;
        this._isCell = true;
    }

    public boolean isInTable() {
        return this._isCell;
    }

    public XWPFTable getContainerTable() {
        return this._tableCell.getTableRow().getTable();
    }

    public XWPFTableRow getContainerTableRow() {
        return this._tableCell.getTableRow();
    }

    public String getBookmarkName() {
        return this._bookmarkName;
    }

    public void insertTextAtBookMark(String bookmarkValue, int where) {
        if (this._isCell) {
            this.handleBookmarkedCells(bookmarkValue, where);
        } else {
            XWPFRun run = this._para.createRun();
            run.setText(bookmarkValue);
            switch (where) {
                case 0: {
                    this.insertAfterBookmark(run);
                    break;
                }
                case 1: {
                    this.insertBeforeBookmark(run);
                    break;
                }
                case 2: {
                    this.replaceBookmark(run);
                }
            }
        }
    }

    private void insertAfterBookmark(XWPFRun run) {
        Node nextNode = null;
        Node insertBeforeNode = null;
        Node styleNode = null;
        int bookmarkStartID = 0;
        int bookmarkEndID = -1;
        bookmarkStartID = this._ctBookmark.getId().intValue();
        nextNode = this._ctBookmark.getDomNode();
        while (bookmarkStartID != bookmarkEndID) {
            if ((nextNode = nextNode.getNextSibling()).getNodeName().contains(BOOKMARK_END_TAG)) {
                try {
                    bookmarkEndID = Integer.parseInt(nextNode.getAttributes().getNamedItem(BOOKMARK_ID_ATTR_NAME).getNodeValue());
                }
                catch (NumberFormatException nfe) {
                    bookmarkEndID = bookmarkStartID;
                }
                continue;
            }
            if (!nextNode.getNodeName().equals(RUN_NODE_NAME)) continue;
            styleNode = this.getStyleNode(nextNode);
        }
        insertBeforeNode = nextNode.getNextSibling();
        if (styleNode != null) {
            run.getCTR().getDomNode().insertBefore(styleNode.cloneNode(true), run.getCTR().getDomNode().getFirstChild());
        }
        if (insertBeforeNode != null) {
            this._para.getCTP().getDomNode().insertBefore(run.getCTR().getDomNode(), insertBeforeNode);
        }
    }

    private void insertBeforeBookmark(XWPFRun run) {
        Node insertBeforeNode = null;
        Node childNode = null;
        Node styleNode = null;
        insertBeforeNode = this._ctBookmark.getDomNode();
        childNode = insertBeforeNode.getPreviousSibling();
        if (childNode != null && (styleNode = this.getStyleNode(childNode)) != null) {
            run.getCTR().getDomNode().insertBefore(styleNode.cloneNode(true), run.getCTR().getDomNode().getFirstChild());
        }
        this._para.getCTP().getDomNode().insertBefore(run.getCTR().getDomNode(), insertBeforeNode);
    }

    private void replaceBookmark(XWPFRun run) {
        Node nextNode = null;
        Node styleNode = null;
        Node lastRunNode = null;
        Stack<Node> nodeStack = null;
        int bookmarkStartID = 0;
        int bookmarkEndID = -1;
        nodeStack = new Stack<Node>();
        bookmarkStartID = this._ctBookmark.getId().intValue();
        nextNode = this._ctBookmark.getDomNode();
        nodeStack.push(nextNode);
        while (bookmarkStartID != bookmarkEndID) {
            nextNode = nextNode.getNextSibling();
            nodeStack.push(nextNode);
            if (!nextNode.getNodeName().contains(BOOKMARK_END_TAG)) continue;
            try {
                bookmarkEndID = Integer.parseInt(nextNode.getAttributes().getNamedItem(BOOKMARK_ID_ATTR_NAME).getNodeValue());
            }
            catch (NumberFormatException nfe) {
                bookmarkEndID = bookmarkStartID;
            }
        }
        if (!nodeStack.isEmpty()) {
            lastRunNode = (Node)nodeStack.peek();
            if (lastRunNode.getNodeName().equals(RUN_NODE_NAME) && (styleNode = this.getStyleNode(lastRunNode)) != null) {
                run.getCTR().getDomNode().insertBefore(styleNode.cloneNode(true), run.getCTR().getDomNode().getFirstChild());
            }
            this.deleteChildNodes(nodeStack);
        }
        this._para.getCTP().getDomNode().insertBefore(run.getCTR().getDomNode(), nextNode);
    }

    private void deleteChildNodes(Stack<Node> nodeStack) {
        Node toDelete = null;
        int bookmarkStartID = 0;
        int bookmarkEndID = 0;
        boolean inNestedBookmark = false;
        for (int i = 1; i < nodeStack.size(); ++i) {
            toDelete = (Node)nodeStack.elementAt(i);
            if (toDelete.getNodeName().contains(BOOKMARK_START_TAG)) {
                bookmarkStartID = Integer.parseInt(toDelete.getAttributes().getNamedItem(BOOKMARK_ID_ATTR_NAME).getNodeValue());
                inNestedBookmark = true;
                continue;
            }
            if (toDelete.getNodeName().contains(BOOKMARK_END_TAG)) {
                bookmarkEndID = Integer.parseInt(toDelete.getAttributes().getNamedItem(BOOKMARK_ID_ATTR_NAME).getNodeValue());
                if (bookmarkEndID != bookmarkStartID) continue;
                inNestedBookmark = false;
                continue;
            }
            if (inNestedBookmark) continue;
            this._para.getCTP().getDomNode().removeChild(toDelete);
        }
    }

    private Node getStyleNode(Node parentNode) {
        Node childNode = null;
        Node styleNode = null;
        if (parentNode != null && parentNode.getNodeName().equalsIgnoreCase(RUN_NODE_NAME) && parentNode.hasChildNodes()) {
            childNode = parentNode.getFirstChild();
            if (childNode != null && childNode.getNodeName().equals(STYLE_NODE_NAME)) {
                styleNode = childNode;
            } else {
                while (childNode != null && (childNode = childNode.getNextSibling()) != null) {
                    if (!childNode.getNodeName().equals(STYLE_NODE_NAME)) continue;
                    styleNode = childNode;
                    childNode = null;
                }
            }
        }
        return styleNode;
    }

    public String getBookmarkText() throws XmlException {
        StringBuilder builder = null;
        builder = this._tableCell != null ? new StringBuilder(this._tableCell.getText()) : this.getTextFromBookmark();
        return builder == null ? null : builder.toString();
    }

    private StringBuilder getTextFromBookmark() throws XmlException {
        int startBookmarkID = 0;
        int endBookmarkID = -1;
        Node nextNode = null;
        StringBuilder builder = null;
        startBookmarkID = this._ctBookmark.getId().intValue();
        nextNode = this._ctBookmark.getDomNode();
        builder = new StringBuilder();
        while (startBookmarkID != endBookmarkID) {
            if ((nextNode = nextNode.getNextSibling()).getNodeName().contains(BOOKMARK_END_TAG)) {
                try {
                    endBookmarkID = Integer.parseInt(nextNode.getAttributes().getNamedItem(BOOKMARK_ID_ATTR_NAME).getNodeValue());
                }
                catch (NumberFormatException nfe) {
                    endBookmarkID = startBookmarkID;
                }
                continue;
            }
            if (!nextNode.getNodeName().equals(RUN_NODE_NAME) || !nextNode.hasChildNodes()) continue;
            builder.append(this.getTextFromChildNodes(nextNode));
        }
        return builder;
    }

    private String getTextFromChildNodes(Node node) throws XmlException {
        NodeList childNodes = null;
        Node childNode = null;
        CTText text = null;
        StringBuilder builder = new StringBuilder();
        int numChildNodes = 0;
        childNodes = node.getChildNodes();
        numChildNodes = childNodes.getLength();
        for (int i = 0; i < numChildNodes; ++i) {
            childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals(TEXT_NODE_NAME)) continue;
            if (childNode.getNodeType() == 3) {
                builder.append(childNode.getNodeValue());
                continue;
            }
            text = CTText.Factory.parse((Node)childNode);
            builder.append(text.getStringValue());
        }
        return builder.toString();
    }

    private void handleBookmarkedCells(String bookmarkValue, int where) {
        List paraList = null;
        XWPFParagraph para = null;
        paraList = this._tableCell.getParagraphs();
        for (int i = 0; i < paraList.size(); ++i) {
            this._tableCell.removeParagraph(i);
        }
        para = this._tableCell.addParagraph();
        para.createRun().setText(bookmarkValue);
    }
}

