/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.codec;

import com.jeesite.common.codec.DigestUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.io.FileUtils;

public class Md5Utils {
    private static final String MD5 = "MD5";
    private static final String DEFAULT_ENCODING = "UTF-8";

    public static String md5(String input) {
        return Md5Utils.md5(input, 1);
    }

    public static String md5(String input, int iterations) {
        try {
            return EncodeUtils.encodeHex(DigestUtils.digest(input.getBytes(DEFAULT_ENCODING), MD5, null, iterations));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static byte[] md5(byte[] input) {
        return Md5Utils.md5(input, 1);
    }

    public static byte[] md5(byte[] input, int iterations) {
        return DigestUtils.digest(input, MD5, null, iterations);
    }

    public static byte[] md5(InputStream input) throws IOException {
        return DigestUtils.digest(input, MD5);
    }

    public static String md5File(File file) {
        return Md5Utils.md5File(file, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String md5File(File file, int size) {
        if (file == null) return "";
        if (!file.exists()) return "";
        try (FileInputStream in = FileUtils.openInputStream((File)file);){
            byte[] bytes = null;
            bytes = size != -1 && file.length() >= (long)size ? IOUtils.toByteArray((InputStream)in, (int)size) : IOUtils.toByteArray((InputStream)in);
            String string = EncodeUtils.encodeHex(Md5Utils.md5(bytes));
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }
}

