/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.image;

import com.jeesite.common.io.FileUtils;
import com.jeesite.common.lang.StringUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static Logger logger = LoggerFactory.getLogger(ImageUtils.class);

    public static void thumbnails(File imageFile, int maxWidth, int maxHeight, String outputFormat) {
        if (imageFile == null || !imageFile.exists() || maxWidth <= 0 && maxHeight <= 0) {
            return;
        }
        String extension = FileUtils.getFileExtension(imageFile.getName());
        if (!StringUtils.inString(extension, "png", "jpg", "jpeg", "bmp", "ico")) {
            return;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            Thumbnails.Builder bilder = Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage});
            if (bufferedImage != null) {
                if (maxWidth > 0) {
                    if (bufferedImage.getWidth() <= maxWidth) {
                        bilder.width(bufferedImage.getWidth());
                    } else {
                        bilder.width(maxWidth);
                    }
                }
                if (maxHeight > 0) {
                    if (bufferedImage.getHeight() <= maxHeight) {
                        bilder.height(bufferedImage.getHeight());
                    } else {
                        bilder.height(maxHeight);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)outputFormat)) {
                    bilder.outputFormat(outputFormat);
                }
                bilder.toFile(imageFile);
            }
        }
        catch (IOException e) {
            logger.error("\u56fe\u7247\u538b\u7f29\u5931\u8d25\uff1a" + imageFile.getAbsoluteFile(), (Throwable)e);
        }
    }
}

