/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.lang;

import com.jeesite.common.lang.DateUtils;
import java.util.Date;

public class TimeUtils {
    public static String formatDateAgo(long millisecond) {
        long ms = millisecond;
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = ms / (long)dd;
        long hour = (ms - day * (long)dd) / (long)hh;
        long minute = (ms - day * (long)dd - hour * (long)hh) / (long)mi;
        long second = (ms - day * (long)dd - hour * (long)hh - minute * (long)mi) / (long)ss;
        StringBuilder sb = new StringBuilder();
        if (ms < 1000L) {
            sb.append(ms).append("\u6beb\u79d2");
        } else {
            if (day > 0L) {
                sb.append(day).append("\u5929");
            }
            if (hour > 0L) {
                sb.append(hour).append("\u65f6");
            }
            if (minute > 0L) {
                sb.append(minute).append("\u5206");
            }
            if (second > 0L) {
                sb.append(second).append("\u79d2");
            }
        }
        return sb.toString();
    }

    public static String formatTimeAgo(String dateTime) {
        return TimeUtils.formatTimeAgo(DateUtils.parseDate(dateTime));
    }

    public static String formatTimeAgo(Date dateTime) {
        String interval = null;
        long time = System.currentTimeMillis() - dateTime.getTime();
        if (time / 1000L < 10L && time / 1000L >= 0L) {
            interval = "\u521a\u521a";
        } else if (time / 3600000L < 96L && time / 3600000L >= 24L) {
            int d = (int)(time / 86400000L);
            interval = d + "\u5929\u524d";
        } else if (time / 3600000L < 24L && time / 3600000L >= 1L) {
            int h = (int)(time / 3600000L);
            interval = h + "\u5c0f\u65f6\u524d";
        } else if (time / 60000L < 60L && time / 60000L >= 1L) {
            int m = (int)(time % 3600000L / 60000L);
            interval = m + "\u5206\u949f\u524d";
        } else if (time / 1000L < 60L && time / 1000L >= 10L) {
            int se = (int)(time % 60000L / 1000L);
            interval = se + "\u79d2\u524d";
        } else {
            interval = DateUtils.formatDate(dateTime, "yyyy-MM-dd");
        }
        return interval;
    }
}

