/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.media;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.image.ImageUtils;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.io.PropertiesUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.lang.TimeUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoUtils {
    private static final Logger log = LoggerFactory.getLogger(VideoUtils.class);
    private static String ffmpegFile;
    private static String mencoderFile;
    private static String qtFaststartFile;
    private String inputFile = "";
    private String inputFileExtension = "";
    private String outputFile = "";
    private String outputFileExtension = "mp4";
    private String imgFile = "";
    private String imgFileExtension = "jpg";
    private String width = null;
    private String height = null;
    private boolean status = false;

    public VideoUtils(String inputFile) {
        this(inputFile, null, null);
    }

    public VideoUtils(String inputFile, String outputFile, String imgFile) {
        this.inputFile = FileUtils.path(inputFile);
        this.inputFileExtension = FileUtils.getFileExtension(inputFile);
        this.outputFile = outputFile != null ? FileUtils.path(outputFile) : inputFile + "." + this.outputFileExtension;
        this.imgFile = imgFile != null ? imgFile : inputFile + "." + this.imgFileExtension;
        this.status = this.checkfile(inputFile);
    }

    public VideoUtils(String inputFile, String outputFile, String imgFile, String width, String height) {
        this(inputFile, outputFile, imgFile);
        this.width = width;
        this.height = height;
    }

    private int checkContentType() {
        if (StringUtils.inString(this.inputFileExtension, "avi", "mpg", "wmv", "3gp", "mov", "mp4", "asf", "asx", "flv", "rm", "rmvb")) {
            return 0;
        }
        if (StringUtils.inString(this.inputFileExtension, "wmv9")) {
            return 1;
        }
        return 9;
    }

    public boolean cutPic() {
        long startTime = System.currentTimeMillis();
        boolean statusTemp = this.status;
        if (statusTemp) {
            statusTemp = this.processFfmpegCutpic(this.inputFile, this.outputFile);
            try {
                File imgfile = new File(this.imgFile);
                if (imgfile.exists()) {
                    ImageUtils.thumbnails(imgfile, 800, 600, null);
                } else {
                    statusTemp = false;
                }
            }
            catch (Exception e) {
                statusTemp = false;
                log.error("\u89c6\u9891\u526a\u5207\u56fe\u7247\u5931\u8d25", (Throwable)e);
            }
        }
        log.debug("\u89c6\u9891\u526a\u5207\u56fe\u7247" + (statusTemp ? "\u6210\u529f" : "\u5931\u8d25") + "\uff0c\u7528\u65f6\uff1a" + TimeUtils.formatDateAgo(System.currentTimeMillis() - startTime));
        return statusTemp;
    }

    public boolean convert() {
        long startTime = System.currentTimeMillis();
        boolean statusTemp = this.status;
        int type = this.checkContentType();
        String tempFile = this.outputFile + ".tmp";
        if (statusTemp && type == 0) {
            log.debug("\u4f7f\u7528ffmpage\u8fdb\u884c\u89c6\u9891\u8f6c\u6362");
            statusTemp = this.processFfmpeg(this.inputFile, tempFile);
        } else if (statusTemp && type == 1) {
            log.debug("\u4f7f\u7528mencoder\u8fdb\u884c\u89c6\u9891\u8f6c\u6362");
            statusTemp = this.processMencoder(this.inputFile, tempFile);
        }
        if (statusTemp) {
            log.debug("\u5c06mp4\u89c6\u9891\u7684\u5143\u6570\u636e\u4fe1\u606f\u8f6c\u5230\u89c6\u9891\u7b2c\u4e00\u5e27");
            statusTemp = this.processQtFaststart(tempFile, this.outputFile);
        }
        log.debug("\u5220\u9664\u4e34\u65f6\u6587\u4ef6");
        FileUtils.deleteFile(tempFile);
        log.debug("\u89c6\u9891\u8f6c\u6362" + (statusTemp ? "\u6210\u529f" : "\u5931\u8d25") + "\uff0c\u7528\u65f6\uff1a" + TimeUtils.formatDateAgo(System.currentTimeMillis() - startTime));
        return statusTemp;
    }

    public boolean checkfile(String inputFile) {
        File file = new File(inputFile);
        if (!file.isFile() || !file.exists()) {
            log.warn("\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        return true;
    }

    public boolean processFfmpegCutpic(String inputFile, String outputFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(VideoUtils.getFfmpegFile());
        command.add("-i");
        command.add(inputFile);
        if (this.imgFileExtension.toLowerCase().equals("gif")) {
            command.add("-vframes");
            command.add("30");
            command.add("-f");
            command.add("gif");
        } else {
            command.add("-ss");
            command.add("4");
            command.add("-t");
            command.add("0.001");
            command.add("-f");
            command.add("image2");
        }
        command.add("-y");
        command.add(this.imgFile);
        return this.process(command);
    }

    private boolean processFfmpeg(String inputFile, String outputFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(VideoUtils.getFfmpegFile());
        command.add("-i");
        command.add(inputFile);
        command.add("-f");
        command.add(this.outputFileExtension);
        command.add("-c:v");
        command.add("libx264");
        command.add("-b:v");
        command.add("600k");
        command.add("-g");
        command.add("300");
        command.add("-bf");
        command.add("2");
        command.add("-c:a");
        command.add("aac");
        command.add("-strict");
        command.add("experimental");
        command.add("-ac");
        command.add("1");
        command.add("-ar");
        command.add("44100");
        command.add("-r");
        command.add("29.97");
        command.add("-qscale");
        command.add("6");
        if (StringUtils.isNotBlank((CharSequence)this.width) && StringUtils.isNotBlank((CharSequence)this.height)) {
            command.add("-s");
            command.add(this.width + "x" + this.height);
        }
        command.add("-y");
        command.add(outputFile);
        return this.process(command);
    }

    private boolean processMencoder(String inputFile, String outputFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(VideoUtils.getMencoderFile());
        command.add(inputFile);
        command.add("-oac");
        command.add("mp3lame");
        command.add("-lameopts");
        command.add("aq=7:vbr=2:q=6");
        command.add("-srate");
        command.add("44100");
        if (StringUtils.isNotBlank((CharSequence)this.width) && StringUtils.isNotBlank((CharSequence)this.height)) {
            command.add("-vf");
            command.add("scale=" + this.width + ":" + this.height + ",harddup");
        }
        command.add("-ovc");
        command.add("xvid");
        command.add("-xvidencopts");
        command.add("fixed_quant=8");
        command.add("-of");
        command.add("lavf");
        command.add("-o");
        command.add(outputFile);
        return this.process(command);
    }

    private boolean processQtFaststart(String inputFile, String outputFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(VideoUtils.getQtFaststartFile());
        command.add(inputFile);
        command.add(outputFile);
        return this.process(command);
    }

    private boolean process(List<String> command) {
        try {
            log.debug(ListUtils.convertToString(command, " "));
            Process process = Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            new PrintErrorReader(process.getErrorStream()).start();
            new PrintInputStream(process.getInputStream()).start();
            process.waitFor();
            return true;
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"CreateProcess error=2")) {
                log.error("\u7f3a\u5c11\u89c6\u9891\u8f6c\u6362\u5de5\u5177\uff0c\u8bf7\u914d\u7f6evideo.ffmpegFile\u76f8\u5173\u53c2\u6570\u3002" + e.getMessage());
            } else {
                log.error(e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    public static String getFfmpegFile() {
        if (ffmpegFile == null) {
            ffmpegFile = PropertiesUtils.getInstance().getProperty("video.ffmpegFile");
        }
        return ffmpegFile;
    }

    public static void setFfmpegFile(String ffmpegFile) {
        VideoUtils.ffmpegFile = ffmpegFile;
    }

    public static String getMencoderFile() {
        if (mencoderFile == null) {
            mencoderFile = PropertiesUtils.getInstance().getProperty("video.mencoderFile");
        }
        return mencoderFile;
    }

    public static void setMencoderFile(String mencoderFile) {
        VideoUtils.mencoderFile = mencoderFile;
    }

    public static String getQtFaststartFile() {
        if (qtFaststartFile == null) {
            qtFaststartFile = PropertiesUtils.getInstance().getProperty("video.qtFaststartFile");
        }
        return qtFaststartFile;
    }

    public static void setQtFaststartFile(String qtFaststartFile) {
        VideoUtils.qtFaststartFile = qtFaststartFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = FileUtils.path(inputFile);
    }

    public String getInputFileExtension() {
        return this.inputFileExtension;
    }

    public void setInputFileExtension(String inputFileExtension) {
        this.inputFileExtension = inputFileExtension;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = FileUtils.path(outputFile);
    }

    public String getOutputFileExtension() {
        return this.outputFileExtension;
    }

    public void setOutputFileExtension(String outputFileExtension) {
        this.outputFileExtension = outputFileExtension;
    }

    public String getImgFile() {
        return this.imgFile;
    }

    public void setImgFile(String imgFile) {
        this.imgFile = imgFile;
    }

    public String getImgFileExtension() {
        return this.imgFileExtension;
    }

    public void setImgFileExtension(String imgFileExtension) {
        this.imgFileExtension = imgFileExtension;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    class PrintErrorReader
    extends Thread {
        InputStream __is = null;

        public PrintErrorReader(InputStream is) {
            this.__is = is;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.__is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    log.error(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class PrintInputStream
    extends Thread {
        InputStream __is = null;

        public PrintInputStream(InputStream is) {
            this.__is = is;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.__is));
                String line = null;
                while ((line = br.readLine()) != null) {
                    log.debug(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

