/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.text;

import com.jeesite.common.text.DiffMatchPatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;

public class DiffMatchPatchTest {
    private DiffMatchPatch dmp;
    private DiffMatchPatch.Operation DELETE = DiffMatchPatch.Operation.DELETE;
    private DiffMatchPatch.Operation EQUAL = DiffMatchPatch.Operation.EQUAL;
    private DiffMatchPatch.Operation INSERT = DiffMatchPatch.Operation.INSERT;

    public DiffMatchPatchTest() {
        this.dmp = new DiffMatchPatch();
    }

    public void testDiffCommonPrefix() {
        DiffMatchPatchTest.assertEquals("diff_commonPrefix: Null case.", 0, this.dmp.diff_commonPrefix("abc", "xyz"));
        DiffMatchPatchTest.assertEquals("diff_commonPrefix: Non-null case.", 4, this.dmp.diff_commonPrefix("1234abcdef", "1234xyz"));
        DiffMatchPatchTest.assertEquals("diff_commonPrefix: Whole case.", 4, this.dmp.diff_commonPrefix("1234", "1234xyz"));
    }

    public void testDiffCommonSuffix() {
        DiffMatchPatchTest.assertEquals("diff_commonSuffix: Null case.", 0, this.dmp.diff_commonSuffix("abc", "xyz"));
        DiffMatchPatchTest.assertEquals("diff_commonSuffix: Non-null case.", 4, this.dmp.diff_commonSuffix("abcdef1234", "xyz1234"));
        DiffMatchPatchTest.assertEquals("diff_commonSuffix: Whole case.", 4, this.dmp.diff_commonSuffix("1234", "xyz1234"));
    }

    public void testDiffCommonOverlap() {
        DiffMatchPatchTest.assertEquals("diff_commonOverlap: Null case.", 0, this.dmp.diff_commonOverlap("", "abcd"));
        DiffMatchPatchTest.assertEquals("diff_commonOverlap: Whole case.", 3, this.dmp.diff_commonOverlap("abc", "abcd"));
        DiffMatchPatchTest.assertEquals("diff_commonOverlap: No overlap.", 0, this.dmp.diff_commonOverlap("123456", "abcd"));
        DiffMatchPatchTest.assertEquals("diff_commonOverlap: Overlap.", 3, this.dmp.diff_commonOverlap("123456xxx", "xxxabcd"));
        DiffMatchPatchTest.assertEquals("diff_commonOverlap: Unicode.", 0, this.dmp.diff_commonOverlap("fi", "\ufb01i"));
    }

    public void testDiffHalfmatch() {
        this.dmp.Diff_Timeout = 1.0f;
        DiffMatchPatchTest.assertNull("diff_halfMatch: No match #1.", this.dmp.diff_halfMatch("1234567890", "abcdef"));
        DiffMatchPatchTest.assertNull("diff_halfMatch: No match #2.", this.dmp.diff_halfMatch("12345", "23"));
        this.assertArrayEquals("diff_halfMatch: Single Match #1.", new String[]{"12", "90", "a", "z", "345678"}, this.dmp.diff_halfMatch("1234567890", "a345678z"));
        this.assertArrayEquals("diff_halfMatch: Single Match #2.", new String[]{"a", "z", "12", "90", "345678"}, this.dmp.diff_halfMatch("a345678z", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Single Match #3.", new String[]{"abc", "z", "1234", "0", "56789"}, this.dmp.diff_halfMatch("abc56789z", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Single Match #4.", new String[]{"a", "xyz", "1", "7890", "23456"}, this.dmp.diff_halfMatch("a23456xyz", "1234567890"));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #1.", new String[]{"12123", "123121", "a", "z", "1234123451234"}, this.dmp.diff_halfMatch("121231234123451234123121", "a1234123451234z"));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #2.", new String[]{"", "-=-=-=-=-=", "x", "", "x-=-=-=-=-=-=-="}, this.dmp.diff_halfMatch("x-=-=-=-=-=-=-=-=-=-=-=-=", "xx-=-=-=-=-=-=-="));
        this.assertArrayEquals("diff_halfMatch: Multiple Matches #3.", new String[]{"-=-=-=-=-=", "", "", "y", "-=-=-=-=-=-=-=y"}, this.dmp.diff_halfMatch("-=-=-=-=-=-=-=-=-=-=-=-=y", "-=-=-=-=-=-=-=yy"));
        this.assertArrayEquals("diff_halfMatch: Non-optimal halfmatch.", new String[]{"qHillo", "w", "x", "Hulloy", "HelloHe"}, this.dmp.diff_halfMatch("qHilloHelloHew", "xHelloHeHulloy"));
        this.dmp.Diff_Timeout = 0.0f;
        DiffMatchPatchTest.assertNull("diff_halfMatch: Optimal no halfmatch.", this.dmp.diff_halfMatch("qHilloHelloHew", "xHelloHeHulloy"));
    }

    public void testDiffLinesToChars() {
        ArrayList<String> tmpVector = new ArrayList<String>();
        tmpVector.add("");
        tmpVector.add("alpha\n");
        tmpVector.add("beta\n");
        this.assertLinesToCharsResultEquals("diff_linesToChars: Shared lines.", new DiffMatchPatch.LinesToCharsResult("\u0001\u0002\u0001", "\u0002\u0001\u0002", tmpVector), this.dmp.diff_linesToChars("alpha\nbeta\nalpha\n", "beta\nalpha\nbeta\n"));
        tmpVector.clear();
        tmpVector.add("");
        tmpVector.add("alpha\r\n");
        tmpVector.add("beta\r\n");
        tmpVector.add("\r\n");
        this.assertLinesToCharsResultEquals("diff_linesToChars: Empty string and blank lines.", new DiffMatchPatch.LinesToCharsResult("", "\u0001\u0002\u0003\u0003", tmpVector), this.dmp.diff_linesToChars("", "alpha\r\nbeta\r\n\r\n\r\n"));
        tmpVector.clear();
        tmpVector.add("");
        tmpVector.add("a");
        tmpVector.add("b");
        this.assertLinesToCharsResultEquals("diff_linesToChars: No linebreaks.", new DiffMatchPatch.LinesToCharsResult("\u0001", "\u0002", tmpVector), this.dmp.diff_linesToChars("a", "b"));
        int n = 300;
        tmpVector.clear();
        StringBuilder lineList = new StringBuilder();
        StringBuilder charList = new StringBuilder();
        for (int x = 1; x < n + 1; ++x) {
            tmpVector.add(x + "\n");
            lineList.append(x + "\n");
            charList.append(String.valueOf((char)x));
        }
        DiffMatchPatchTest.assertEquals(n, tmpVector.size());
        String lines = lineList.toString();
        String chars = charList.toString();
        DiffMatchPatchTest.assertEquals(n, chars.length());
        tmpVector.add(0, "");
        this.assertLinesToCharsResultEquals("diff_linesToChars: More than 256.", new DiffMatchPatch.LinesToCharsResult(chars, "", tmpVector), this.dmp.diff_linesToChars(lines, ""));
    }

    public void testDiffCharsToLines() {
        DiffMatchPatchTest.assertTrue("diff_charsToLines: Equality #1.", new DiffMatchPatch.Diff(this.EQUAL, "a").equals(new DiffMatchPatch.Diff(this.EQUAL, "a")));
        DiffMatchPatchTest.assertEquals("diff_charsToLines: Equality #2.", new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.EQUAL, "a"));
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "\u0001\u0002\u0001"), new DiffMatchPatch.Diff(this.INSERT, "\u0002\u0001\u0002"));
        ArrayList<String> tmpVector = new ArrayList<String>();
        tmpVector.add("");
        tmpVector.add("alpha\n");
        tmpVector.add("beta\n");
        this.dmp.diff_charsToLines(diffs, tmpVector);
        DiffMatchPatchTest.assertEquals("diff_charsToLines: Shared lines.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "alpha\nbeta\nalpha\n"), new DiffMatchPatch.Diff(this.INSERT, "beta\nalpha\nbeta\n")), diffs);
        int n = 300;
        tmpVector.clear();
        StringBuilder lineList = new StringBuilder();
        StringBuilder charList = new StringBuilder();
        for (int x = 1; x < n + 1; ++x) {
            tmpVector.add(x + "\n");
            lineList.append(x + "\n");
            charList.append(String.valueOf((char)x));
        }
        DiffMatchPatchTest.assertEquals(n, tmpVector.size());
        String lines = lineList.toString();
        String chars = charList.toString();
        DiffMatchPatchTest.assertEquals(n, chars.length());
        tmpVector.add(0, "");
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, chars));
        this.dmp.diff_charsToLines(diffs, tmpVector);
        DiffMatchPatchTest.assertEquals("diff_charsToLines: More than 256.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, lines)), diffs);
    }

    public void testDiffCleanupMerge() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]);
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Null case.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "b"), new DiffMatchPatch.Diff(this.INSERT, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: No change case.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "b"), new DiffMatchPatch.Diff(this.INSERT, "c")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.EQUAL, "b"), new DiffMatchPatch.Diff(this.EQUAL, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Merge equalities.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "abc")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.DELETE, "b"), new DiffMatchPatch.Diff(this.DELETE, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Merge deletions.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "a"), new DiffMatchPatch.Diff(this.INSERT, "b"), new DiffMatchPatch.Diff(this.INSERT, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Merge insertions.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "abc")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "b"), new DiffMatchPatch.Diff(this.DELETE, "c"), new DiffMatchPatch.Diff(this.INSERT, "d"), new DiffMatchPatch.Diff(this.EQUAL, "e"), new DiffMatchPatch.Diff(this.EQUAL, "f"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Merge interweave.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ac"), new DiffMatchPatch.Diff(this.INSERT, "bd"), new DiffMatchPatch.Diff(this.EQUAL, "ef")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "abc"), new DiffMatchPatch.Diff(this.DELETE, "dc"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Prefix and suffix detection.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "d"), new DiffMatchPatch.Diff(this.INSERT, "b"), new DiffMatchPatch.Diff(this.EQUAL, "c")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "x"), new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "abc"), new DiffMatchPatch.Diff(this.DELETE, "dc"), new DiffMatchPatch.Diff(this.EQUAL, "y"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Prefix and suffix detection with equalities.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "xa"), new DiffMatchPatch.Diff(this.DELETE, "d"), new DiffMatchPatch.Diff(this.INSERT, "b"), new DiffMatchPatch.Diff(this.EQUAL, "cy")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.INSERT, "ba"), new DiffMatchPatch.Diff(this.EQUAL, "c"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Slide edit left.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "ab"), new DiffMatchPatch.Diff(this.EQUAL, "ac")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "c"), new DiffMatchPatch.Diff(this.INSERT, "ab"), new DiffMatchPatch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Slide edit right.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "ca"), new DiffMatchPatch.Diff(this.INSERT, "ba")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "b"), new DiffMatchPatch.Diff(this.EQUAL, "c"), new DiffMatchPatch.Diff(this.DELETE, "ac"), new DiffMatchPatch.Diff(this.EQUAL, "x"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Slide edit left recursive.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.EQUAL, "acx")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "x"), new DiffMatchPatch.Diff(this.DELETE, "ca"), new DiffMatchPatch.Diff(this.EQUAL, "c"), new DiffMatchPatch.Diff(this.DELETE, "b"), new DiffMatchPatch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupMerge(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupMerge: Slide edit right recursive.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "xca"), new DiffMatchPatch.Diff(this.DELETE, "cba")), diffs);
    }

    public void testDiffCleanupSemanticLossless() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]);
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Null case.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "AAA\r\n\r\nBBB"), new DiffMatchPatch.Diff(this.INSERT, "\r\nDDD\r\n\r\nBBB"), new DiffMatchPatch.Diff(this.EQUAL, "\r\nEEE"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Blank lines.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "AAA\r\n\r\n"), new DiffMatchPatch.Diff(this.INSERT, "BBB\r\nDDD\r\n\r\n"), new DiffMatchPatch.Diff(this.EQUAL, "BBB\r\nEEE")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "AAA\r\nBBB"), new DiffMatchPatch.Diff(this.INSERT, " DDD\r\nBBB"), new DiffMatchPatch.Diff(this.EQUAL, " EEE"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Line boundaries.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "AAA\r\n"), new DiffMatchPatch.Diff(this.INSERT, "BBB DDD\r\n"), new DiffMatchPatch.Diff(this.EQUAL, "BBB EEE")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The c"), new DiffMatchPatch.Diff(this.INSERT, "ow and the c"), new DiffMatchPatch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Word boundaries.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The "), new DiffMatchPatch.Diff(this.INSERT, "cow and the "), new DiffMatchPatch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The-c"), new DiffMatchPatch.Diff(this.INSERT, "ow-and-the-c"), new DiffMatchPatch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Alphanumeric boundaries.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The-"), new DiffMatchPatch.Diff(this.INSERT, "cow-and-the-"), new DiffMatchPatch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.EQUAL, "ax"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Hitting the start.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.EQUAL, "aax")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "xa"), new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.EQUAL, "a"));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Hitting the end.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "xaa"), new DiffMatchPatch.Diff(this.DELETE, "a")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The xxx. The "), new DiffMatchPatch.Diff(this.INSERT, "zzz. The "), new DiffMatchPatch.Diff(this.EQUAL, "yyy."));
        this.dmp.diff_cleanupSemanticLossless(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemanticLossless: Sentence boundaries.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The xxx."), new DiffMatchPatch.Diff(this.INSERT, " The zzz."), new DiffMatchPatch.Diff(this.EQUAL, " The yyy.")), diffs);
    }

    public void testDiffCleanupSemantic() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]);
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Null case.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "cd"), new DiffMatchPatch.Diff(this.EQUAL, "12"), new DiffMatchPatch.Diff(this.DELETE, "e"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: No elimination #1.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "cd"), new DiffMatchPatch.Diff(this.EQUAL, "12"), new DiffMatchPatch.Diff(this.DELETE, "e")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.INSERT, "ABC"), new DiffMatchPatch.Diff(this.EQUAL, "1234"), new DiffMatchPatch.Diff(this.DELETE, "wxyz"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: No elimination #2.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.INSERT, "ABC"), new DiffMatchPatch.Diff(this.EQUAL, "1234"), new DiffMatchPatch.Diff(this.DELETE, "wxyz")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.EQUAL, "b"), new DiffMatchPatch.Diff(this.DELETE, "c"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Simple elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.INSERT, "b")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.EQUAL, "cd"), new DiffMatchPatch.Diff(this.DELETE, "e"), new DiffMatchPatch.Diff(this.EQUAL, "f"), new DiffMatchPatch.Diff(this.INSERT, "g"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Backpass elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcdef"), new DiffMatchPatch.Diff(this.INSERT, "cdfg")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "1"), new DiffMatchPatch.Diff(this.EQUAL, "A"), new DiffMatchPatch.Diff(this.DELETE, "B"), new DiffMatchPatch.Diff(this.INSERT, "2"), new DiffMatchPatch.Diff(this.EQUAL, "_"), new DiffMatchPatch.Diff(this.INSERT, "1"), new DiffMatchPatch.Diff(this.EQUAL, "A"), new DiffMatchPatch.Diff(this.DELETE, "B"), new DiffMatchPatch.Diff(this.INSERT, "2"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Multiple elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "AB_AB"), new DiffMatchPatch.Diff(this.INSERT, "1A2_1A2")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The c"), new DiffMatchPatch.Diff(this.DELETE, "ow and the c"), new DiffMatchPatch.Diff(this.EQUAL, "at."));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Word boundaries.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "The "), new DiffMatchPatch.Diff(this.DELETE, "cow and the "), new DiffMatchPatch.Diff(this.EQUAL, "cat.")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcxx"), new DiffMatchPatch.Diff(this.INSERT, "xxdef"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: No overlap elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcxx"), new DiffMatchPatch.Diff(this.INSERT, "xxdef")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcxxx"), new DiffMatchPatch.Diff(this.INSERT, "xxxdef"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Overlap elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.EQUAL, "xxx"), new DiffMatchPatch.Diff(this.INSERT, "def")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "xxxabc"), new DiffMatchPatch.Diff(this.INSERT, "defxxx"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Reverse overlap elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "def"), new DiffMatchPatch.Diff(this.EQUAL, "xxx"), new DiffMatchPatch.Diff(this.DELETE, "abc")), diffs);
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcd1212"), new DiffMatchPatch.Diff(this.INSERT, "1212efghi"), new DiffMatchPatch.Diff(this.EQUAL, "----"), new DiffMatchPatch.Diff(this.DELETE, "A3"), new DiffMatchPatch.Diff(this.INSERT, "3BC"));
        this.dmp.diff_cleanupSemantic(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupSemantic: Two overlap eliminations.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abcd"), new DiffMatchPatch.Diff(this.EQUAL, "1212"), new DiffMatchPatch.Diff(this.INSERT, "efghi"), new DiffMatchPatch.Diff(this.EQUAL, "----"), new DiffMatchPatch.Diff(this.DELETE, "A"), new DiffMatchPatch.Diff(this.EQUAL, "3"), new DiffMatchPatch.Diff(this.INSERT, "BC")), diffs);
    }

    public void testDiffCleanupEfficiency() {
        this.dmp.Diff_EditCost = (short)4;
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]);
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: Null case.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]), diffs);
        System.out.println(this.dmp.diff_prettyHtml(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "wxyz"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: No elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "wxyz"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "34")), diffs);
        System.out.println(this.dmp.diff_prettyHtml(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "xyz"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: Four-edit elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abxyzcd"), new DiffMatchPatch.Diff(this.INSERT, "12xyz34")), diffs);
        System.out.println(this.dmp.diff_prettyHtml(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "x"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: Three-edit elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "xcd"), new DiffMatchPatch.Diff(this.INSERT, "12x34")), diffs);
        System.out.println(this.dmp.diff_prettyHtml(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "xy"), new DiffMatchPatch.Diff(this.INSERT, "34"), new DiffMatchPatch.Diff(this.EQUAL, "z"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "56"));
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: Backpass elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abxyzcd"), new DiffMatchPatch.Diff(this.INSERT, "12xy34z56")), diffs);
        System.out.println(this.dmp.diff_prettyHtml(diffs));
        this.dmp.Diff_EditCost = (short)5;
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ab"), new DiffMatchPatch.Diff(this.INSERT, "12"), new DiffMatchPatch.Diff(this.EQUAL, "wxyz"), new DiffMatchPatch.Diff(this.DELETE, "cd"), new DiffMatchPatch.Diff(this.INSERT, "34"));
        this.dmp.diff_cleanupEfficiency(diffs);
        DiffMatchPatchTest.assertEquals("diff_cleanupEfficiency: High cost elimination.", DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abwxyzcd"), new DiffMatchPatch.Diff(this.INSERT, "12wxyz34")), diffs);
        this.dmp.Diff_EditCost = (short)4;
    }

    public void testDiffPrettyHtml() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a\n"), new DiffMatchPatch.Diff(this.DELETE, "<B>b</B>"), new DiffMatchPatch.Diff(this.INSERT, "c&d"));
        DiffMatchPatchTest.assertEquals("diff_prettyHtml:", "<span>a&para;<br></span><del style=\"background:#ffe6e6;\">&lt;B&gt;b&lt;/B&gt;</del><ins style=\"background:#e6ffe6;\">c&amp;d</ins>", this.dmp.diff_prettyHtml(diffs));
    }

    public void testDiffText() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "jump"), new DiffMatchPatch.Diff(this.DELETE, "s"), new DiffMatchPatch.Diff(this.INSERT, "ed"), new DiffMatchPatch.Diff(this.EQUAL, " over "), new DiffMatchPatch.Diff(this.DELETE, "the"), new DiffMatchPatch.Diff(this.INSERT, "a"), new DiffMatchPatch.Diff(this.EQUAL, " lazy"));
        DiffMatchPatchTest.assertEquals("diff_text1:", "jumps over the lazy", this.dmp.diff_text1(diffs));
        DiffMatchPatchTest.assertEquals("diff_text2:", "jumped over a lazy", this.dmp.diff_text2(diffs));
    }

    public void testDiffDelta() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "jump"), new DiffMatchPatch.Diff(this.DELETE, "s"), new DiffMatchPatch.Diff(this.INSERT, "ed"), new DiffMatchPatch.Diff(this.EQUAL, " over "), new DiffMatchPatch.Diff(this.DELETE, "the"), new DiffMatchPatch.Diff(this.INSERT, "a"), new DiffMatchPatch.Diff(this.EQUAL, " lazy"), new DiffMatchPatch.Diff(this.INSERT, "old dog"));
        String text1 = this.dmp.diff_text1(diffs);
        DiffMatchPatchTest.assertEquals("diff_text1: Base text.", "jumps over the lazy", text1);
        String delta = this.dmp.diff_toDelta(diffs);
        DiffMatchPatchTest.assertEquals("diff_toDelta:", "=4\t-1\t+ed\t=6\t-3\t+a\t=5\t+old dog", delta);
        DiffMatchPatchTest.assertEquals("diff_fromDelta: Normal.", diffs, this.dmp.diff_fromDelta(text1, delta));
        try {
            this.dmp.diff_fromDelta(text1 + "x", delta);
            DiffMatchPatchTest.fail("diff_fromDelta: Too long.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.dmp.diff_fromDelta(text1.substring(1), delta);
            DiffMatchPatchTest.fail("diff_fromDelta: Too short.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.dmp.diff_fromDelta("", "+%c3%xy");
            DiffMatchPatchTest.fail("diff_fromDelta: Invalid character.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "\u0680 \u0000 \t %"), new DiffMatchPatch.Diff(this.DELETE, "\u0681 \u0001 \n ^"), new DiffMatchPatch.Diff(this.INSERT, "\u0682 \u0002 \\ |"));
        text1 = this.dmp.diff_text1(diffs);
        DiffMatchPatchTest.assertEquals("diff_text1: Unicode text.", "\u0680 \u0000 \t %\u0681 \u0001 \n ^", text1);
        delta = this.dmp.diff_toDelta(diffs);
        DiffMatchPatchTest.assertEquals("diff_toDelta: Unicode.", "=7\t-7\t+%DA%82 %02 %5C %7C", delta);
        DiffMatchPatchTest.assertEquals("diff_fromDelta: Unicode.", diffs, this.dmp.diff_fromDelta(text1, delta));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # "));
        String text2 = this.dmp.diff_text2(diffs);
        DiffMatchPatchTest.assertEquals("diff_text2: Unchanged characters.", "A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # ", text2);
        delta = this.dmp.diff_toDelta(diffs);
        DiffMatchPatchTest.assertEquals("diff_toDelta: Unchanged characters.", "+A-Z a-z 0-9 - _ . ! ~ * ' ( ) ; / ? : @ & = + $ , # ", delta);
        DiffMatchPatchTest.assertEquals("diff_fromDelta: Unchanged characters.", diffs, this.dmp.diff_fromDelta("", delta));
    }

    public void testDiffXIndex() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "1234"), new DiffMatchPatch.Diff(this.EQUAL, "xyz"));
        DiffMatchPatchTest.assertEquals("diff_xIndex: Translation on equality.", 5, this.dmp.diff_xIndex(diffs, 2));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "1234"), new DiffMatchPatch.Diff(this.EQUAL, "xyz"));
        DiffMatchPatchTest.assertEquals("diff_xIndex: Translation on deletion.", 1, this.dmp.diff_xIndex(diffs, 3));
    }

    public void testDiffLevenshtein() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.INSERT, "1234"), new DiffMatchPatch.Diff(this.EQUAL, "xyz"));
        DiffMatchPatchTest.assertEquals("Levenshtein with trailing equality.", 4, this.dmp.diff_levenshtein(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "xyz"), new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.INSERT, "1234"));
        DiffMatchPatchTest.assertEquals("Levenshtein with leading equality.", 4, this.dmp.diff_levenshtein(diffs));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "abc"), new DiffMatchPatch.Diff(this.EQUAL, "xyz"), new DiffMatchPatch.Diff(this.INSERT, "1234"));
        DiffMatchPatchTest.assertEquals("Levenshtein with middle equality.", 7, this.dmp.diff_levenshtein(diffs));
    }

    public void testDiffBisect() {
        String a = "cat";
        String b = "map";
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "c"), new DiffMatchPatch.Diff(this.INSERT, "m"), new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "t"), new DiffMatchPatch.Diff(this.INSERT, "p"));
        DiffMatchPatchTest.assertEquals("diff_bisect: Normal.", diffs, this.dmp.diff_bisect(a, b, Long.MAX_VALUE));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "cat"), new DiffMatchPatch.Diff(this.INSERT, "map"));
        DiffMatchPatchTest.assertEquals("diff_bisect: Timeout.", diffs, this.dmp.diff_bisect(a, b, 0L));
    }

    public void testDiffMain() {
        LinkedList<DiffMatchPatch.Diff> diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff[0]);
        DiffMatchPatchTest.assertEquals("diff_main: Null case.", diffs, this.dmp.diff_main("", "", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "abc"));
        DiffMatchPatchTest.assertEquals("diff_main: Equality.", diffs, this.dmp.diff_main("abc", "abc", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "ab"), new DiffMatchPatch.Diff(this.INSERT, "123"), new DiffMatchPatch.Diff(this.EQUAL, "c"));
        DiffMatchPatchTest.assertEquals("diff_main: Simple insertion.", diffs, this.dmp.diff_main("abc", "ab123c", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "123"), new DiffMatchPatch.Diff(this.EQUAL, "bc"));
        DiffMatchPatchTest.assertEquals("diff_main: Simple deletion.", diffs, this.dmp.diff_main("a123bc", "abc", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.INSERT, "123"), new DiffMatchPatch.Diff(this.EQUAL, "b"), new DiffMatchPatch.Diff(this.INSERT, "456"), new DiffMatchPatch.Diff(this.EQUAL, "c"));
        DiffMatchPatchTest.assertEquals("diff_main: Two insertions.", diffs, this.dmp.diff_main("abc", "a123b456c", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "123"), new DiffMatchPatch.Diff(this.EQUAL, "b"), new DiffMatchPatch.Diff(this.DELETE, "456"), new DiffMatchPatch.Diff(this.EQUAL, "c"));
        DiffMatchPatchTest.assertEquals("diff_main: Two deletions.", diffs, this.dmp.diff_main("a123b456c", "abc", false));
        this.dmp.Diff_Timeout = 0.0f;
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "b"));
        DiffMatchPatchTest.assertEquals("diff_main: Simple case #1.", diffs, this.dmp.diff_main("a", "b", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "Apple"), new DiffMatchPatch.Diff(this.INSERT, "Banana"), new DiffMatchPatch.Diff(this.EQUAL, "s are a"), new DiffMatchPatch.Diff(this.INSERT, "lso"), new DiffMatchPatch.Diff(this.EQUAL, " fruit."));
        DiffMatchPatchTest.assertEquals("diff_main: Simple case #2.", diffs, this.dmp.diff_main("Apples are a fruit.", "Bananas are also fruit.", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "a"), new DiffMatchPatch.Diff(this.INSERT, "\u0680"), new DiffMatchPatch.Diff(this.EQUAL, "x"), new DiffMatchPatch.Diff(this.DELETE, "\t"), new DiffMatchPatch.Diff(this.INSERT, "\u0000"));
        DiffMatchPatchTest.assertEquals("diff_main: Simple case #3.", diffs, this.dmp.diff_main("ax\t", "\u0680x\u0000", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "1"), new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "y"), new DiffMatchPatch.Diff(this.EQUAL, "b"), new DiffMatchPatch.Diff(this.DELETE, "2"), new DiffMatchPatch.Diff(this.INSERT, "xab"));
        DiffMatchPatchTest.assertEquals("diff_main: Overlap #1.", diffs, this.dmp.diff_main("1ayb2", "abxab", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, "xaxcx"), new DiffMatchPatch.Diff(this.EQUAL, "abc"), new DiffMatchPatch.Diff(this.DELETE, "y"));
        DiffMatchPatchTest.assertEquals("diff_main: Overlap #2.", diffs, this.dmp.diff_main("abcy", "xaxcxabc", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "ABCD"), new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.DELETE, "="), new DiffMatchPatch.Diff(this.INSERT, "-"), new DiffMatchPatch.Diff(this.EQUAL, "bcd"), new DiffMatchPatch.Diff(this.DELETE, "="), new DiffMatchPatch.Diff(this.INSERT, "-"), new DiffMatchPatch.Diff(this.EQUAL, "efghijklmnopqrs"), new DiffMatchPatch.Diff(this.DELETE, "EFGHIJKLMNOefg"));
        DiffMatchPatchTest.assertEquals("diff_main: Overlap #3.", diffs, this.dmp.diff_main("ABCDa=bcd=efghijklmnopqrsEFGHIJKLMNOefg", "a-bcd-efghijklmnopqrs", false));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.INSERT, " "), new DiffMatchPatch.Diff(this.EQUAL, "a"), new DiffMatchPatch.Diff(this.INSERT, "nd"), new DiffMatchPatch.Diff(this.EQUAL, " [[Pennsylvania]]"), new DiffMatchPatch.Diff(this.DELETE, " and [[New"));
        DiffMatchPatchTest.assertEquals("diff_main: Large equality.", diffs, this.dmp.diff_main("a [[Pennsylvania]] and [[New", " and [[Pennsylvania]]", false));
        this.dmp.Diff_Timeout = 0.1f;
        String a = "`Twas brillig, and the slithy toves\nDid gyre and gimble in the wabe:\nAll mimsy were the borogoves,\nAnd the mome raths outgrabe.\n";
        String b = "I am the very model of a modern major general,\nI've information vegetable, animal, and mineral,\nI know the kings of England, and I quote the fights historical,\nFrom Marathon to Waterloo, in order categorical.\n";
        for (int x = 0; x < 10; ++x) {
            a = a + a;
            b = b + b;
        }
        long startTime = System.currentTimeMillis();
        this.dmp.diff_main(a, b);
        long endTime = System.currentTimeMillis();
        DiffMatchPatchTest.assertTrue("diff_main: Timeout min.", this.dmp.Diff_Timeout * 1000.0f <= (float)(endTime - startTime));
        DiffMatchPatchTest.assertTrue("diff_main: Timeout max.", this.dmp.Diff_Timeout * 1000.0f * 2.0f > (float)(endTime - startTime));
        this.dmp.Diff_Timeout = 0.0f;
        a = "1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n";
        b = "abcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\nabcdefghij\n";
        DiffMatchPatchTest.assertEquals("diff_main: Simple line-mode.", this.dmp.diff_main(a, b, true), this.dmp.diff_main(a, b, false));
        a = "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";
        b = "abcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghijabcdefghij";
        DiffMatchPatchTest.assertEquals("diff_main: Single line-mode.", this.dmp.diff_main(a, b, true), this.dmp.diff_main(a, b, false));
        a = "1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n1234567890\n";
        b = "abcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n1234567890\n1234567890\n1234567890\nabcdefghij\n";
        Object[] texts_linemode = DiffMatchPatchTest.diff_rebuildtexts(this.dmp.diff_main(a, b, true));
        Object[] texts_textmode = DiffMatchPatchTest.diff_rebuildtexts(this.dmp.diff_main(a, b, false));
        this.assertArrayEquals("diff_main: Overlap line-mode.", texts_textmode, texts_linemode);
        try {
            this.dmp.diff_main(null, null);
            DiffMatchPatchTest.fail("diff_main: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMatchAlphabet() {
        HashMap<Character, Integer> bitmask = new HashMap<Character, Integer>();
        bitmask.put(Character.valueOf('a'), 4);
        bitmask.put(Character.valueOf('b'), 2);
        bitmask.put(Character.valueOf('c'), 1);
        DiffMatchPatchTest.assertEquals("match_alphabet: Unique.", bitmask, this.dmp.match_alphabet("abc"));
        bitmask = new HashMap();
        bitmask.put(Character.valueOf('a'), 37);
        bitmask.put(Character.valueOf('b'), 18);
        bitmask.put(Character.valueOf('c'), 8);
        DiffMatchPatchTest.assertEquals("match_alphabet: Duplicates.", bitmask, this.dmp.match_alphabet("abcaba"));
    }

    public void testMatchBitap() {
        this.dmp.Match_Distance = 100;
        this.dmp.Match_Threshold = 0.5f;
        DiffMatchPatchTest.assertEquals("match_bitap: Exact match #1.", 5, this.dmp.match_bitap("abcdefghijk", "fgh", 5));
        DiffMatchPatchTest.assertEquals("match_bitap: Exact match #2.", 5, this.dmp.match_bitap("abcdefghijk", "fgh", 0));
        DiffMatchPatchTest.assertEquals("match_bitap: Fuzzy match #1.", 4, this.dmp.match_bitap("abcdefghijk", "efxhi", 0));
        DiffMatchPatchTest.assertEquals("match_bitap: Fuzzy match #2.", 2, this.dmp.match_bitap("abcdefghijk", "cdefxyhijk", 5));
        DiffMatchPatchTest.assertEquals("match_bitap: Fuzzy match #3.", -1, this.dmp.match_bitap("abcdefghijk", "bxy", 1));
        DiffMatchPatchTest.assertEquals("match_bitap: Overflow.", 2, this.dmp.match_bitap("123456789xx0", "3456789x0", 2));
        DiffMatchPatchTest.assertEquals("match_bitap: Before start match.", 0, this.dmp.match_bitap("abcdef", "xxabc", 4));
        DiffMatchPatchTest.assertEquals("match_bitap: Beyond end match.", 3, this.dmp.match_bitap("abcdef", "defyy", 4));
        DiffMatchPatchTest.assertEquals("match_bitap: Oversized pattern.", 0, this.dmp.match_bitap("abcdef", "xabcdefy", 0));
        this.dmp.Match_Threshold = 0.4f;
        DiffMatchPatchTest.assertEquals("match_bitap: Threshold #1.", 4, this.dmp.match_bitap("abcdefghijk", "efxyhi", 1));
        this.dmp.Match_Threshold = 0.3f;
        DiffMatchPatchTest.assertEquals("match_bitap: Threshold #2.", -1, this.dmp.match_bitap("abcdefghijk", "efxyhi", 1));
        this.dmp.Match_Threshold = 0.0f;
        DiffMatchPatchTest.assertEquals("match_bitap: Threshold #3.", 1, this.dmp.match_bitap("abcdefghijk", "bcdef", 1));
        this.dmp.Match_Threshold = 0.5f;
        DiffMatchPatchTest.assertEquals("match_bitap: Multiple select #1.", 0, this.dmp.match_bitap("abcdexyzabcde", "abccde", 3));
        DiffMatchPatchTest.assertEquals("match_bitap: Multiple select #2.", 8, this.dmp.match_bitap("abcdexyzabcde", "abccde", 5));
        this.dmp.Match_Distance = 10;
        DiffMatchPatchTest.assertEquals("match_bitap: Distance test #1.", -1, this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdefg", 24));
        DiffMatchPatchTest.assertEquals("match_bitap: Distance test #2.", 0, this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdxxefg", 1));
        this.dmp.Match_Distance = 1000;
        DiffMatchPatchTest.assertEquals("match_bitap: Distance test #3.", 0, this.dmp.match_bitap("abcdefghijklmnopqrstuvwxyz", "abcdefg", 24));
    }

    public void testMatchMain() {
        DiffMatchPatchTest.assertEquals("match_main: Equality.", 0, this.dmp.match_main("abcdef", "abcdef", 1000));
        DiffMatchPatchTest.assertEquals("match_main: Null text.", -1, this.dmp.match_main("", "abcdef", 1));
        DiffMatchPatchTest.assertEquals("match_main: Null pattern.", 3, this.dmp.match_main("abcdef", "", 3));
        DiffMatchPatchTest.assertEquals("match_main: Exact match.", 3, this.dmp.match_main("abcdef", "de", 3));
        DiffMatchPatchTest.assertEquals("match_main: Beyond end match.", 3, this.dmp.match_main("abcdef", "defy", 4));
        DiffMatchPatchTest.assertEquals("match_main: Oversized pattern.", 0, this.dmp.match_main("abcdef", "abcdefy", 0));
        this.dmp.Match_Threshold = 0.7f;
        DiffMatchPatchTest.assertEquals("match_main: Complex match.", 4, this.dmp.match_main("I am the very model of a modern major general.", " that berry ", 5));
        this.dmp.Match_Threshold = 0.5f;
        try {
            this.dmp.match_main(null, null, 0);
            DiffMatchPatchTest.fail("match_main: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchObj() {
        DiffMatchPatch.Patch p = new DiffMatchPatch.Patch();
        p.start1 = 20;
        p.start2 = 21;
        p.length1 = 18;
        p.length2 = 17;
        p.diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.EQUAL, "jump"), new DiffMatchPatch.Diff(this.DELETE, "s"), new DiffMatchPatch.Diff(this.INSERT, "ed"), new DiffMatchPatch.Diff(this.EQUAL, " over "), new DiffMatchPatch.Diff(this.DELETE, "the"), new DiffMatchPatch.Diff(this.INSERT, "a"), new DiffMatchPatch.Diff(this.EQUAL, "\nlaz"));
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n %0Alaz\n";
        DiffMatchPatchTest.assertEquals("Patch: toString.", strp, p.toString());
    }

    public void testPatchFromText() {
        DiffMatchPatchTest.assertTrue("patch_fromText: #0.", this.dmp.patch_fromText("").isEmpty());
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n %0Alaz\n";
        DiffMatchPatchTest.assertEquals("patch_fromText: #1.", strp, this.dmp.patch_fromText(strp).get(0).toString());
        DiffMatchPatchTest.assertEquals("patch_fromText: #2.", "@@ -1 +1 @@\n-a\n+b\n", this.dmp.patch_fromText("@@ -1 +1 @@\n-a\n+b\n").get(0).toString());
        DiffMatchPatchTest.assertEquals("patch_fromText: #3.", "@@ -1,3 +0,0 @@\n-abc\n", this.dmp.patch_fromText("@@ -1,3 +0,0 @@\n-abc\n").get(0).toString());
        DiffMatchPatchTest.assertEquals("patch_fromText: #4.", "@@ -0,0 +1,3 @@\n+abc\n", this.dmp.patch_fromText("@@ -0,0 +1,3 @@\n+abc\n").get(0).toString());
        try {
            this.dmp.patch_fromText("Bad\nPatch\n");
            DiffMatchPatchTest.fail("patch_fromText: #5.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchToText() {
        String strp = "@@ -21,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n  laz\n";
        List<DiffMatchPatch.Patch> patches = this.dmp.patch_fromText(strp);
        DiffMatchPatchTest.assertEquals("patch_toText: Single.", strp, this.dmp.patch_toText(patches));
        strp = "@@ -1,9 +1,9 @@\n-f\n+F\n oo+fooba\n@@ -7,9 +7,9 @@\n obar\n-,\n+.\n  tes\n";
        patches = this.dmp.patch_fromText(strp);
        DiffMatchPatchTest.assertEquals("patch_toText: Dual.", strp, this.dmp.patch_toText(patches));
    }

    public void testPatchAddContext() {
        this.dmp.Patch_Margin = (short)4;
        DiffMatchPatch.Patch p = this.dmp.patch_fromText("@@ -21,4 +21,10 @@\n-jump\n+somersault\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps over the lazy dog.");
        DiffMatchPatchTest.assertEquals("patch_addContext: Simple case.", "@@ -17,12 +17,18 @@\n fox \n-jump\n+somersault\n s ov\n", p.toString());
        p = this.dmp.patch_fromText("@@ -21,4 +21,10 @@\n-jump\n+somersault\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.");
        DiffMatchPatchTest.assertEquals("patch_addContext: Not enough trailing context.", "@@ -17,10 +17,16 @@\n fox \n-jump\n+somersault\n s.\n", p.toString());
        p = this.dmp.patch_fromText("@@ -3 +3,2 @@\n-e\n+at\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.");
        DiffMatchPatchTest.assertEquals("patch_addContext: Not enough leading context.", "@@ -1,7 +1,8 @@\n Th\n-e\n+at\n  qui\n", p.toString());
        p = this.dmp.patch_fromText("@@ -3 +3,2 @@\n-e\n+at\n").get(0);
        this.dmp.patch_addContext(p, "The quick brown fox jumps.  The quick brown fox crashes.");
        DiffMatchPatchTest.assertEquals("patch_addContext: Ambiguity.", "@@ -1,27 +1,28 @@\n Th\n-e\n+at\n  quick brown fox jumps. \n", p.toString());
    }

    public void testPatchMake() {
        LinkedList<DiffMatchPatch.Patch> patches = this.dmp.patch_make("", "");
        DiffMatchPatchTest.assertEquals("patch_make: Null case.", "", this.dmp.patch_toText(patches));
        String text1 = "The quick brown fox jumps over the lazy dog.";
        String text2 = "That quick brown fox jumped over a lazy dog.";
        String expectedPatch = "@@ -1,8 +1,7 @@\n Th\n-at\n+e\n  qui\n@@ -21,17 +21,18 @@\n jump\n-ed\n+s\n  over \n-a\n+the\n  laz\n";
        patches = this.dmp.patch_make(text2, text1);
        DiffMatchPatchTest.assertEquals("patch_make: Text2+Text1 inputs.", expectedPatch, this.dmp.patch_toText(patches));
        expectedPatch = "@@ -1,11 +1,12 @@\n Th\n-e\n+at\n  quick b\n@@ -22,18 +22,17 @@\n jump\n-s\n+ed\n  over \n-the\n+a\n  laz\n";
        patches = this.dmp.patch_make(text1, text2);
        DiffMatchPatchTest.assertEquals("patch_make: Text1+Text2 inputs.", expectedPatch, this.dmp.patch_toText(patches));
        LinkedList<DiffMatchPatch.Diff> diffs = this.dmp.diff_main(text1, text2, false);
        patches = this.dmp.patch_make(diffs);
        DiffMatchPatchTest.assertEquals("patch_make: Diff input.", expectedPatch, this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make(text1, diffs);
        DiffMatchPatchTest.assertEquals("patch_make: Text1+Diff inputs.", expectedPatch, this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("`1234567890-=[]\\;',./", "~!@#$%^&*()_+{}|:\"<>?");
        DiffMatchPatchTest.assertEquals("patch_toText: Character encoding.", "@@ -1,21 +1,21 @@\n-%601234567890-=%5B%5D%5C;',./\n+~!@#$%25%5E&*()_+%7B%7D%7C:%22%3C%3E?\n", this.dmp.patch_toText(patches));
        diffs = DiffMatchPatchTest.diffList(new DiffMatchPatch.Diff(this.DELETE, "`1234567890-=[]\\;',./"), new DiffMatchPatch.Diff(this.INSERT, "~!@#$%^&*()_+{}|:\"<>?"));
        DiffMatchPatchTest.assertEquals("patch_fromText: Character decoding.", diffs, this.dmp.patch_fromText((String)"@@ -1,21 +1,21 @@\n-%601234567890-=%5B%5D%5C;',./\n+~!@#$%25%5E&*()_+%7B%7D%7C:%22%3C%3E?\n").get((int)0).diffs);
        text1 = "";
        for (int x = 0; x < 100; ++x) {
            text1 = text1 + "abcdef";
        }
        text2 = text1 + "123";
        expectedPatch = "@@ -573,28 +573,31 @@\n cdefabcdefabcdefabcdefabcdef\n+123\n";
        patches = this.dmp.patch_make(text1, text2);
        DiffMatchPatchTest.assertEquals("patch_make: Long string with repeats.", expectedPatch, this.dmp.patch_toText(patches));
        try {
            this.dmp.patch_make(null);
            DiffMatchPatchTest.fail("patch_make: Null inputs.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testPatchSplitMax() {
        LinkedList<DiffMatchPatch.Patch> patches = this.dmp.patch_make("abcdefghijklmnopqrstuvwxyz01234567890", "XabXcdXefXghXijXklXmnXopXqrXstXuvXwxXyzX01X23X45X67X89X0");
        this.dmp.patch_splitMax(patches);
        DiffMatchPatchTest.assertEquals("patch_splitMax: #1.", "@@ -1,32 +1,46 @@\n+X\n ab\n+X\n cd\n+X\n ef\n+X\n gh\n+X\n ij\n+X\n kl\n+X\n mn\n+X\n op\n+X\n qr\n+X\n st\n+X\n uv\n+X\n wx\n+X\n yz\n+X\n 012345\n@@ -25,13 +39,18 @@\n zX01\n+X\n 23\n+X\n 45\n+X\n 67\n+X\n 89\n+X\n 0\n", this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("abcdef1234567890123456789012345678901234567890123456789012345678901234567890uvwxyz", "abcdefuvwxyz");
        String oldToText = this.dmp.patch_toText(patches);
        this.dmp.patch_splitMax(patches);
        DiffMatchPatchTest.assertEquals("patch_splitMax: #2.", oldToText, this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("1234567890123456789012345678901234567890123456789012345678901234567890", "abc");
        this.dmp.patch_splitMax(patches);
        DiffMatchPatchTest.assertEquals("patch_splitMax: #3.", "@@ -1,32 +1,4 @@\n-1234567890123456789012345678\n 9012\n@@ -29,32 +1,4 @@\n-9012345678901234567890123456\n 7890\n@@ -57,14 +1,3 @@\n-78901234567890\n+abc\n", this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("abcdefghij , h : 0 , t : 1 abcdefghij , h : 0 , t : 1 abcdefghij , h : 0 , t : 1", "abcdefghij , h : 1 , t : 1 abcdefghij , h : 1 , t : 1 abcdefghij , h : 0 , t : 1");
        this.dmp.patch_splitMax(patches);
        DiffMatchPatchTest.assertEquals("patch_splitMax: #4.", "@@ -2,32 +2,32 @@\n bcdefghij , h : \n-0\n+1\n  , t : 1 abcdef\n@@ -29,32 +29,32 @@\n bcdefghij , h : \n-0\n+1\n  , t : 1 abcdef\n", this.dmp.patch_toText(patches));
    }

    public void testPatchAddPadding() {
        LinkedList<DiffMatchPatch.Patch> patches = this.dmp.patch_make("", "test");
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges full.", "@@ -0,0 +1,4 @@\n+test\n", this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges full.", "@@ -1,8 +1,12 @@\n %01%02%03%04\n+test\n %01%02%03%04\n", this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("XY", "XtestY");
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges partial.", "@@ -1,2 +1,6 @@\n X\n+test\n Y\n", this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges partial.", "@@ -2,8 +2,12 @@\n %02%03%04X\n+test\n Y%01%02%03\n", this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("XXXXYYYY", "XXXXtestYYYY");
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges none.", "@@ -1,8 +1,12 @@\n XXXX\n+test\n YYYY\n", this.dmp.patch_toText(patches));
        this.dmp.patch_addPadding(patches);
        DiffMatchPatchTest.assertEquals("patch_addPadding: Both edges none.", "@@ -5,8 +5,12 @@\n XXXX\n+test\n YYYY\n", this.dmp.patch_toText(patches));
    }

    public void testPatchApply() {
        this.dmp.Match_Distance = 1000;
        this.dmp.Match_Threshold = 0.5f;
        this.dmp.Patch_DeleteThreshold = 0.5f;
        LinkedList<DiffMatchPatch.Patch> patches = this.dmp.patch_make("", "");
        Object[] results = this.dmp.patch_apply(patches, "Hello world.");
        boolean[] boolArray = (boolean[])results[1];
        String resultStr = results[0] + "\t" + boolArray.length;
        DiffMatchPatchTest.assertEquals("patch_apply: Null case.", "Hello world.\t0", resultStr);
        patches = this.dmp.patch_make("The quick brown fox jumps over the lazy dog.", "That quick brown fox jumped over a lazy dog.");
        results = this.dmp.patch_apply(patches, "The quick brown fox jumps over the lazy dog.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Exact match.", "That quick brown fox jumped over a lazy dog.\ttrue\ttrue", resultStr);
        results = this.dmp.patch_apply(patches, "The quick red rabbit jumps over the tired tiger.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Partial match.", "That quick red rabbit jumped over a tired tiger.\ttrue\ttrue", resultStr);
        results = this.dmp.patch_apply(patches, "I am the very model of a modern major general.");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Failed match.", "I am the very model of a modern major general.\tfalse\tfalse", resultStr);
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x123456789012345678901234567890-----++++++++++-----123456789012345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Big delete, small change.", "xabcy\ttrue\ttrue", resultStr);
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x12345678901234567890---------------++++++++++---------------12345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Big delete, big change 1.", "xabc12345678901234567890---------------++++++++++---------------12345678901234567890y\tfalse\ttrue", resultStr);
        this.dmp.Patch_DeleteThreshold = 0.6f;
        patches = this.dmp.patch_make("x1234567890123456789012345678901234567890123456789012345678901234567890y", "xabcy");
        results = this.dmp.patch_apply(patches, "x12345678901234567890---------------++++++++++---------------12345678901234567890y");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Big delete, big change 2.", "xabcy\ttrue\ttrue", resultStr);
        this.dmp.Patch_DeleteThreshold = 0.5f;
        this.dmp.Match_Threshold = 0.0f;
        this.dmp.Match_Distance = 0;
        patches = this.dmp.patch_make("abcdefghijklmnopqrstuvwxyz--------------------1234567890", "abcXXXXXXXXXXdefghijklmnopqrstuvwxyz--------------------1234567YYYYYYYYYY890");
        results = this.dmp.patch_apply(patches, "ABCDEFGHIJKLMNOPQRSTUVWXYZ--------------------1234567890");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0] + "\t" + boolArray[1];
        DiffMatchPatchTest.assertEquals("patch_apply: Compensate for failed patch.", "ABCDEFGHIJKLMNOPQRSTUVWXYZ--------------------1234567YYYYYYYYYY890\tfalse\ttrue", resultStr);
        this.dmp.Match_Threshold = 0.5f;
        this.dmp.Match_Distance = 1000;
        patches = this.dmp.patch_make("", "test");
        String patchStr = this.dmp.patch_toText(patches);
        this.dmp.patch_apply(patches, "");
        DiffMatchPatchTest.assertEquals("patch_apply: No side effects.", patchStr, this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("The quick brown fox jumps over the lazy dog.", "Woof");
        patchStr = this.dmp.patch_toText(patches);
        this.dmp.patch_apply(patches, "The quick brown fox jumps over the lazy dog.");
        DiffMatchPatchTest.assertEquals("patch_apply: No side effects with major delete.", patchStr, this.dmp.patch_toText(patches));
        patches = this.dmp.patch_make("", "test");
        results = this.dmp.patch_apply(patches, "");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        DiffMatchPatchTest.assertEquals("patch_apply: Edge exact match.", "test\ttrue", resultStr);
        patches = this.dmp.patch_make("XY", "XtestY");
        results = this.dmp.patch_apply(patches, "XY");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        DiffMatchPatchTest.assertEquals("patch_apply: Near edge exact match.", "XtestY\ttrue", resultStr);
        patches = this.dmp.patch_make("y", "y123");
        results = this.dmp.patch_apply(patches, "x");
        boolArray = (boolean[])results[1];
        resultStr = results[0] + "\t" + boolArray[0];
        DiffMatchPatchTest.assertEquals("patch_apply: Edge partial match.", "x123\ttrue", resultStr);
    }

    private void assertArrayEquals(String error_msg, Object[] a, Object[] b) {
        List<Object> list_a = Arrays.asList(a);
        List<Object> list_b = Arrays.asList(b);
        DiffMatchPatchTest.assertEquals(error_msg, list_a, list_b);
    }

    private void assertLinesToCharsResultEquals(String error_msg, DiffMatchPatch.LinesToCharsResult a, DiffMatchPatch.LinesToCharsResult b) {
        DiffMatchPatchTest.assertEquals(error_msg, a.chars1, b.chars1);
        DiffMatchPatchTest.assertEquals(error_msg, a.chars2, b.chars2);
        DiffMatchPatchTest.assertEquals(error_msg, a.lineArray, b.lineArray);
    }

    private static String[] diff_rebuildtexts(LinkedList<DiffMatchPatch.Diff> diffs) {
        String[] text = new String[]{"", ""};
        for (DiffMatchPatch.Diff myDiff : diffs) {
            if (myDiff.operation != DiffMatchPatch.Operation.INSERT) {
                text[0] = text[0] + myDiff.text;
            }
            if (myDiff.operation == DiffMatchPatch.Operation.DELETE) continue;
            text[1] = text[1] + myDiff.text;
        }
        return text;
    }

    private static LinkedList<DiffMatchPatch.Diff> diffList(DiffMatchPatch.Diff ... diffs) {
        LinkedList<DiffMatchPatch.Diff> myDiffList = new LinkedList<DiffMatchPatch.Diff>();
        for (DiffMatchPatch.Diff myDiff : diffs) {
            myDiffList.add(myDiff);
        }
        return myDiffList;
    }

    private static void assertNull(String message, Object object) {
        Assert.assertNull((String)message, (Object)object);
    }

    private static void assertEquals(String message, Object expected, Object actual) {
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    private static void assertEquals(String message, String expected, String actual) {
        Assert.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    private static void assertTrue(String message, boolean condition) {
        Assert.assertTrue((String)message, (boolean)condition);
    }

    private static void assertEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private static void fail(String message) {
        Assert.fail((String)message);
    }
}

