/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.ueditor.upload;

import com.jeesite.common.image.ImageUtils;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.media.VideoUtils;
import com.jeesite.common.ueditor.PathFormat;
import com.jeesite.common.ueditor.define.BaseState;
import com.jeesite.common.ueditor.define.FileType;
import com.jeesite.common.ueditor.define.State;
import com.jeesite.common.ueditor.upload.StorageManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BinaryUploader {
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        MultipartFile fileStream2 = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                MultipartHttpServletRequest multiRequest;
                Iterator it;
                MultipartFile file = null;
                if (request instanceof MultipartHttpServletRequest && (it = (multiRequest = (MultipartHttpServletRequest)request).getFileNames()).hasNext()) {
                    file = multiRequest.getFile((String)it.next());
                }
                if (file != null && !file.isEmpty() && file.getOriginalFilename() != null) {
                    fileStream2 = file;
                }
            }
            if (fileStream == null && fileStream2 == null) {
                return new BaseState(false, 7);
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream != null ? fileStream.getName() : fileStream2.getOriginalFilename();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                return new BaseState(false, 8);
            }
            savePath = PathFormat.parse(savePath, originFileName);
            String physicalPath = FileUtils.path((String)conf.get("rootPath") + savePath);
            InputStream is = fileStream != null ? fileStream.openStream() : fileStream2.getInputStream();
            State storageState = StorageManager.saveFileByInputStream(is, physicalPath, maxSize);
            is.close();
            if (storageState.isSuccess()) {
                VideoUtils v;
                int actionCode = (Integer)conf.get("actionCode");
                String ctx = request.getContextPath();
                if (actionCode == 1) {
                    if (((Boolean)conf.get("imageCompressEnable")).booleanValue()) {
                        Integer maxWidth = (Integer)conf.get("imageCompressBorder");
                        ImageUtils.thumbnails(new File(physicalPath), maxWidth, -1, null);
                    }
                } else if (actionCode == 3 && (v = new VideoUtils(physicalPath)).cutPic()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(5000L);
                                v.convert();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                    storageState.putInfo("url", ctx + PathFormat.format(savePath) + "." + v.getOutputFileExtension());
                    storageState.putInfo("type", "." + v.getOutputFileExtension());
                    storageState.putInfo("original", originFileName + "." + v.getInputFileExtension());
                    StorageManager.uploadFileSuccess(physicalPath, storageState);
                    return storageState;
                }
                storageState.putInfo("url", ctx + PathFormat.format(savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
                StorageManager.uploadFileSuccess(physicalPath, storageState);
            }
            return storageState;
        }
        catch (FileUploadException e) {
            return new BaseState(false, 6);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

