/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.ueditor.upload;

import com.jeesite.common.idgen.IdGenerate;
import com.jeesite.common.io.FileUtils;
import com.jeesite.common.io.PropertiesUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.ueditor.define.BaseState;
import com.jeesite.common.ueditor.define.State;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StorageManager {
    public static final int BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State saveBinaryFile(byte[] data, String path) {
        String rct;
        File file = new File(path);
        State state = StorageManager.valid(file);
        if (!state.isSuccess()) {
            return state;
        }
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            bos.write(data);
        }
        catch (IOException ioe) {
            BaseState baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            if (bos != null) {
                try {
                    bos.flush();
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        String allowContentTypes = PropertiesUtils.getInstance().getProperty("file.allowContentTypes");
        if (StringUtils.isNotBlank((CharSequence)allowContentTypes) && !StringUtils.inString(rct = FileUtils.getRealContentType(file), allowContentTypes.split(","))) {
            file.delete();
            return new BaseState(false, 8);
        }
        state = new BaseState(true, file.getAbsolutePath());
        state.putInfo("size", data.length);
        state.putInfo("title", file.getName());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static State saveFileByInputStream(InputStream is, String path, long maxSize) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        BufferedOutputStream bos = null;
        try {
            String rct;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
                int count = 0;
                while ((count = bis.read(dataBuf)) != -1) {
                    bos.write(dataBuf, 0, count);
                }
            }
            finally {
                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
            }
            if (tmpFile.length() > maxSize) {
                tmpFile.delete();
                BaseState count = new BaseState(false, 1);
                return count;
            }
            String allowContentTypes = PropertiesUtils.getInstance().getProperty("file.allowContentTypes");
            if (StringUtils.isNotBlank((CharSequence)allowContentTypes) && !StringUtils.inString(rct = FileUtils.getRealContentType(tmpFile), allowContentTypes.split(","))) {
                tmpFile.delete();
                BaseState baseState = new BaseState(false, 8);
                return baseState;
            }
            state = StorageManager.saveTmpFile(tmpFile, path);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            State state2 = state;
            return state2;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static State saveFileByInputStream(InputStream is, String path) {
        State state = null;
        File tmpFile = StorageManager.getTmpFile();
        byte[] dataBuf = new byte[2048];
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        try {
            BufferedOutputStream bos = null;
            try {
                bos = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
                int count = 0;
                while ((count = bis.read(dataBuf)) != -1) {
                    bos.write(dataBuf, 0, count);
                }
            }
            finally {
                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
            }
            state = StorageManager.saveTmpFile(tmpFile, path);
            if (!state.isSuccess()) {
                tmpFile.delete();
            }
            State state2 = state;
            return state2;
        }
        catch (IOException iOException) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new BaseState(false, 4);
    }

    private static File getTmpFile() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmpDir, IdGenerate.randomBase62(10));
    }

    private static State saveTmpFile(File tmpFile, String path) {
        BaseState state = null;
        File targetFile = new File(path);
        if (targetFile.canWrite()) {
            return new BaseState(false, 2);
        }
        try {
            FileUtils.moveFile((File)tmpFile, (File)targetFile);
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
        state = new BaseState(true);
        state.putInfo("size", targetFile.length());
        state.putInfo("title", targetFile.getName());
        return state;
    }

    private static State valid(File file) {
        File parentPath = file.getParentFile();
        if (!parentPath.exists() && !parentPath.mkdirs()) {
            return new BaseState(false, 3);
        }
        if (!parentPath.canWrite()) {
            return new BaseState(false, 2);
        }
        return new BaseState(true);
    }

    public static void uploadFileSuccess(String physicalPath, State storageState) {
    }
}

