/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUrlBasedTicketValidator
implements TicketValidator {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected HostnameVerifier hostnameVerifier;
    private final String casServerUrlPrefix;
    private boolean renew;
    private Map<String, String> customParameters;
    private String encoding;

    protected AbstractUrlBasedTicketValidator(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
        CommonUtils.assertNotNull(this.casServerUrlPrefix, "casServerUrlPrefix cannot be null.");
    }

    protected void populateUrlAttributeMap(Map<String, String> urlParameters) {
    }

    protected abstract String getUrlSuffix();

    protected abstract void setDisableXmlSchemaValidation(boolean var1);

    protected final String constructValidationUrl(String ticket, String serviceUrl) {
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        this.log.debug((Object)"Placing URL parameters in map.");
        urlParameters.put("ticket", ticket);
        urlParameters.put("service", serviceUrl);
        if (this.renew) {
            urlParameters.put("renew", "true");
        }
        this.log.debug((Object)"Calling template URL attribute map.");
        this.populateUrlAttributeMap(urlParameters);
        this.log.debug((Object)"Loading custom parameters from configuration.");
        if (this.customParameters != null) {
            urlParameters.putAll(this.customParameters);
        }
        String suffix = this.getUrlSuffix();
        StringBuilder buffer = new StringBuilder(urlParameters.size() * 10 + this.casServerUrlPrefix.length() + suffix.length() + 1);
        int i = 0;
        buffer.append(this.casServerUrlPrefix);
        if (!this.casServerUrlPrefix.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(suffix);
        for (Map.Entry entry : urlParameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            buffer.append(i++ == 0 ? "?" : "&");
            buffer.append(key);
            buffer.append("=");
            String encodedValue = this.encodeUrl(value);
            buffer.append(encodedValue);
        }
        return buffer.toString();
    }

    protected final String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return url;
        }
    }

    protected abstract Assertion parseResponseFromServer(String var1) throws TicketValidationException;

    protected abstract String retrieveResponseFromServer(URL var1, String var2);

    @Override
    public Assertion validate(String ticket, String service) throws TicketValidationException {
        String validationUrl = this.constructValidationUrl(ticket, service);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Constructing validation url: " + validationUrl));
        }
        try {
            this.log.debug((Object)"Retrieving response from server.");
            String serverResponse = this.retrieveResponseFromServer(new URL(validationUrl), ticket);
            if (serverResponse == null) {
                throw new TicketValidationException("The CAS server returned no response.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Server response: " + serverResponse));
            }
            return this.parseResponseFromServer(serverResponse);
        }
        catch (MalformedURLException e) {
            throw new TicketValidationException(e);
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public final void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected final String getEncoding() {
        return this.encoding;
    }
}

