/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.om;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.GroupTemplate;
import org.beetl.core.om.ArrayAA;
import org.beetl.core.om.AttributeAccess;
import org.beetl.core.om.AttributeCodeGen;
import org.beetl.core.om.ListAA;
import org.beetl.core.om.MapAA;
import org.beetl.core.om.MapEntryAA;
import org.beetl.core.om.ObjectAA;
import org.beetl.core.om.ObjectUtil;

public class AttributeAccessFactory {
    Map<PojoAttrKey, AttributeAccess> pojoCache = new ConcurrentHashMap<PojoAttrKey, AttributeAccess>();
    Map<PojoAttrKey, AttributeAccess> generalGetCache = new ConcurrentHashMap<PojoAttrKey, AttributeAccess>();
    MapAA mapAA = new MapAA();
    ListAA listAA = new ListAA();
    ArrayAA arrayAA = new ArrayAA();
    ObjectAA objectAA = new ObjectAA();
    MapEntryAA mapEntryAA = new MapEntryAA();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeAccess buildFiledAccessor(Class c, String attrExp, GroupTemplate gt) {
        if (c == Object.class) {
            return this.objectAA;
        }
        if (Map.class.isAssignableFrom(c)) {
            return this.mapAA;
        }
        if (List.class.isAssignableFrom(c)) {
            return this.listAA;
        }
        if (c.isArray()) {
            return this.arrayAA;
        }
        if (c == Map.Entry.class) {
            return this.mapEntryAA;
        }
        if (c.getName().startsWith("java")) {
            return this.objectAA;
        }
        String name = attrExp;
        PojoAttrKey pojoAttr = new PojoAttrKey(c, name);
        AttributeAccess aa = this.pojoCache.get(pojoAttr);
        if (aa != null) {
            return aa;
        }
        FindResult pojoResult = AttributeAccessFactory.findCommonInterfaceOrClass(c, name);
        if (pojoResult != null) {
            if (!pojoResult.realMethodName.equals("get")) {
                pojoAttr = new PojoAttrKey(c, name);
                aa = this.pojoCache.get(pojoAttr);
                if (aa != null) {
                    return aa;
                }
                Class clazz = pojoResult.c;
                synchronized (clazz) {
                    aa = this.pojoCache.get(pojoAttr);
                    if (aa != null) {
                        return aa;
                    }
                    aa = AttributeCodeGen.createAAClass(pojoResult.c, name, pojoResult.realMethodName, pojoResult.returnType, gt);
                    this.pojoCache.put(pojoAttr, aa);
                    return aa;
                }
            }
            pojoAttr = new PojoAttrKey(c, "get");
            aa = this.generalGetCache.get(pojoAttr);
            if (aa != null) {
                return aa;
            }
            Class clazz = c;
            synchronized (clazz) {
                aa = this.generalGetCache.get(pojoAttr);
                if (aa != null) {
                    return aa;
                }
                aa = AttributeCodeGen.createAAClass(c, "get", "get", pojoResult.returnType, pojoResult.parameter, gt);
                this.generalGetCache.put(pojoAttr, aa);
                return aa;
            }
        }
        return this.objectAA;
    }

    public static FindResult findCommonInterfaceOrClass(Class c, String name) {
        Method m = ObjectUtil.getInvokder(c, name).getMethod();
        String methodName = m.getName();
        if (methodName.equals("get")) {
            FindResult findResult = new FindResult();
            findResult.parameter = m.getParameterTypes()[0];
            findResult.realMethodName = "get";
            findResult.c = c;
            findResult.returnType = m.getReturnType();
            return findResult;
        }
        if (Modifier.isPublic(c.getModifiers())) {
            FindResult result = new FindResult();
            result.realMethodName = m.getName();
            result.c = c;
            result.returnType = m.getReturnType();
            Class<?>[] para = m.getParameterTypes();
            result.parameter = para.length == 0 ? null : para[1];
            return result;
        }
        FindResult findResult = AttributeAccessFactory.findResult(c, methodName);
        return findResult;
    }

    private static FindResult findResult(Class c, String getName) {
        Class<?>[] interfaces;
        FindResult result = null;
        Method[] methods = c.getMethods();
        Method findMethod = null;
        for (Method m : methods) {
            String name = m.getName();
            Class<?>[] paras = m.getParameterTypes();
            if (paras.length != 0 || !name.equals(getName)) continue;
            findMethod = m;
            break;
        }
        if (findMethod != null && Modifier.isPublic(c.getModifiers())) {
            result = new FindResult();
            result.realMethodName = findMethod.getName();
            result.c = c;
            result.returnType = findMethod.getReturnType();
            Class<?>[] para = findMethod.getParameterTypes();
            result.parameter = para.length == 0 ? null : para[1];
            return result;
        }
        for (Class<?> inc : interfaces = c.getInterfaces()) {
            if (!Modifier.isPublic(inc.getModifiers()) || inc.getName().startsWith("java.") || (result = AttributeAccessFactory.findResult(inc, getName)) == null) continue;
            return result;
        }
        Class parent = c.getSuperclass();
        if (parent != null && Modifier.isPublic(parent.getModifiers()) && !parent.getName().startsWith("java.") && (result = AttributeAccessFactory.findResult(parent, getName)) != null) {
            return result;
        }
        return null;
    }

    public Map<PojoAttrKey, AttributeAccess> getPojoCache() {
        return this.pojoCache;
    }

    public void setPojoCache(Map<PojoAttrKey, AttributeAccess> pojoCache) {
        this.pojoCache = pojoCache;
    }

    public Map<PojoAttrKey, AttributeAccess> getGeneralGetCache() {
        return this.generalGetCache;
    }

    public void setGeneralGetCache(Map<PojoAttrKey, AttributeAccess> generalGetCache) {
        this.generalGetCache = generalGetCache;
    }

    public MapAA getMapAA() {
        return this.mapAA;
    }

    public void setMapAA(MapAA mapAA) {
        this.mapAA = mapAA;
    }

    public ListAA getListAA() {
        return this.listAA;
    }

    public void setListAA(ListAA listAA) {
        this.listAA = listAA;
    }

    public ArrayAA getArrayAA() {
        return this.arrayAA;
    }

    public void setArrayAA(ArrayAA arrayAA) {
        this.arrayAA = arrayAA;
    }

    public ObjectAA getObjectAA() {
        return this.objectAA;
    }

    public void setObjectAA(ObjectAA objectAA) {
        this.objectAA = objectAA;
    }

    public MapEntryAA getMapEntryAA() {
        return this.mapEntryAA;
    }

    public void setMapEntryAA(MapEntryAA mapEntryAA) {
        this.mapEntryAA = mapEntryAA;
    }

    class PojoAttrKey {
        Class c;
        String attr;

        public PojoAttrKey(Class c, String attr) {
            this.c = c;
            this.attr = attr;
        }

        public int hashCode() {
            return this.c.hashCode() * 31 + this.attr.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            PojoAttrKey other = (PojoAttrKey)obj;
            return this.c.equals(other.c) && this.attr.equals(other.attr);
        }
    }

    static class FindResult {
        String realMethodName;
        Class c;
        Class returnType;
        Class parameter;

        FindResult() {
        }
    }
}

