/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.lang.reflect.Method;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.core.InferContext;
import org.beetl.core.Resource;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.fun.FileFunctionWrapper;
import org.beetl.core.fun.MutipleFunctionWrapper;
import org.beetl.core.fun.SingleFunctionWrapper;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Type;
import org.beetl.core.statement.VarAttribute;

public class FunctionExpression
extends Expression {
    String name;
    public Expression[] exps;
    public VarAttribute[] vas;

    public FunctionExpression(String name, Expression[] exps, VarAttribute[] vas, GrammarToken token) {
        super(token);
        this.name = name;
        this.exps = exps;
        this.vas = vas;
    }

    @Override
    public Object evaluate(Context ctx) {
        Function fn = ctx.gt.getFunction(this.name);
        if (fn == null) {
            Resource resource = this.getResource(ctx.gt, this.name);
            if (resource != null) {
                fn = new FileFunctionWrapper(resource.getId());
            } else {
                BeetlException ex = new BeetlException("FUNCTION_NOT_FOUND");
                ex.pushToken(this.token);
                throw ex;
            }
        }
        Object[] paras = new Object[this.exps.length];
        for (int i = 0; i < paras.length; ++i) {
            paras[i] = this.exps[i].evaluate(ctx);
        }
        Object value = null;
        try {
            value = fn.call(paras, ctx);
        }
        catch (BeetlException ex) {
            ex.pushToken(this.token);
            throw ex;
        }
        catch (RuntimeException ex) {
            BeetlException be = new BeetlException("NATIVE_CALL_EXCEPTION", "\u8c03\u7528\u65b9\u6cd5\u51fa\u9519 " + this.name, ex);
            be.pushToken(this.token);
            throw be;
        }
        if (this.vas == null) {
            return value;
        }
        for (VarAttribute attr : this.vas) {
            try {
                value = attr.evaluate(ctx, value);
            }
            catch (BeetlException ex) {
                ex.pushToken(attr.token);
                throw ex;
            }
            catch (RuntimeException ex) {
                BeetlException be = new BeetlException("ATTRIBUTE_INVALID", "\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519", ex);
                be.pushToken(attr.token);
                throw be;
            }
            if (value != null) continue;
            BeetlException be = new BeetlException("ERROR", "\u7a7a\u6307\u9488 ");
            be.pushToken(attr.token);
            throw be;
        }
        return value;
    }

    @Override
    public void infer(InferContext inferCtx) {
        Function fn = inferCtx.gt.getFunction(this.name);
        if (fn == null) {
            Resource resource = this.getResource(inferCtx.gt, this.name);
            if (resource == null) {
                BeetlException ex = new BeetlException("FUNCTION_NOT_FOUND");
                ex.pushToken(this.token);
                throw ex;
            }
            fn = new FileFunctionWrapper(resource.getId());
        }
        for (Expression expression : this.exps) {
            expression.infer(inferCtx);
        }
        Class c = null;
        if (fn instanceof SingleFunctionWrapper) {
            SingleFunctionWrapper singleWrapper = (SingleFunctionWrapper)fn;
            c = singleWrapper.getReturnType();
        } else {
            if (fn instanceof MutipleFunctionWrapper) {
                try {
                    Class[] parasType = new Class[this.exps.length];
                    int i = 0;
                    for (Expression exp : this.exps) {
                        exp.infer(inferCtx);
                        parasType[i++] = exp.getType().cls;
                    }
                    c = ((MutipleFunctionWrapper)fn).getReturnType(parasType);
                }
                catch (BeetlException ex2) {
                    ex2.pushToken(this.token);
                    throw ex2;
                }
            }
            Method call = null;
            try {
                call = fn.getClass().getMethod("call", Object[].class, Context.class);
                c = call.getReturnType();
            }
            catch (NoSuchMethodException e) {
                BeetlException beetlException = new BeetlException("FUNCTION_INVALID");
                beetlException.pushToken(this.token);
                throw beetlException;
            }
            catch (SecurityException e) {
                BeetlException beetlException = new BeetlException("FUNCTION_INVALID");
                beetlException.pushToken(this.token);
                throw beetlException;
            }
        }
        Type lastType = new Type(c);
        if (this.vas == null) {
            this.type = lastType;
            return;
        }
        Type t = null;
        for (VarAttribute attr : this.vas) {
            inferCtx.temp = lastType;
            attr.infer(inferCtx);
            t = lastType;
            lastType = attr.type;
            attr.type = t;
        }
        this.type = lastType;
    }

    private Resource getResource(GroupTemplate gt, String name) {
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        String functionSuffix = resourceMap.get("functionSuffix");
        String functionRoot = resourceMap.get("functionRoot");
        String path = name.replace(".", "/");
        Resource resource = gt.getResourceLoader().getResource(functionRoot + "/" + path + "." + functionSuffix);
        return resource;
    }
}

