/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.ext.fn;

import org.beetl.core.Context;
import org.beetl.core.Function;

public class ParseDouble
implements Function {
    @Override
    public Object call(Object[] paras, Context ctx) {
        double result;
        Object o = paras[0];
        if (o == null) {
            throw new NullPointerException("Error:parseDouble(null)");
        }
        String str = "";
        if (o instanceof Number) {
            Double n = ((Number)o).doubleValue();
            return n;
        }
        str = o.toString();
        try {
            result = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("\u4e0d\u80fd\u8f6c\u5316" + str, e);
        }
        return result;
    }

    public static void main(String[] args) {
        Double d = 1.23232323232389E12;
        System.out.println(d);
        String str = d.toString();
        double c = Double.parseDouble(str);
        System.out.println(c);
        ParseDouble pDouble = new ParseDouble();
        Context ctx = new Context();
        System.out.println(pDouble.call(new Object[]{-1.0}, ctx));
        System.out.println(pDouble.call(new Object[]{2332.23213}, ctx));
        System.out.println(pDouble.call(new Object[]{"-1.023"}, ctx));
        System.out.println(pDouble.call(new Object[]{"abcd"}, ctx));
    }
}

