/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.BeanDefinitionUtils;
import org.springframework.batch.core.configuration.xml.JobParserJobFactoryBean;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;

public class CoreNamespacePostProcessor
implements BeanPostProcessor,
BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final String DEFAULT_JOB_REPOSITORY_NAME = "jobRepository";
    private static final String DEFAULT_TRANSACTION_MANAGER_NAME = "transactionManager";
    private static final String JOB_FACTORY_PROPERTY_NAME = "jobParserJobFactoryBeanRef";
    private static final String JOB_REPOSITORY_PROPERTY_NAME = "jobRepository";
    private ApplicationContext applicationContext;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            this.injectJobRepositoryIntoSteps(beanName, beanFactory);
            this.overrideStepClass(beanName, beanFactory);
        }
    }

    private void injectJobRepositoryIntoSteps(String beanName, ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
        if (bd.hasAttribute(JOB_FACTORY_PROPERTY_NAME)) {
            MutablePropertyValues pvs = bd.getPropertyValues();
            if (beanFactory.isTypeMatch(beanName, AbstractStep.class)) {
                String jobName = (String)bd.getAttribute(JOB_FACTORY_PROPERTY_NAME);
                PropertyValue jobRepository = BeanDefinitionUtils.getPropertyValue(jobName, "jobRepository", beanFactory);
                if (jobRepository != null) {
                    pvs.addPropertyValue(jobRepository);
                } else {
                    RuntimeBeanReference jobRepositoryBeanRef = new RuntimeBeanReference("jobRepository");
                    pvs.addPropertyValue("jobRepository", (Object)jobRepositoryBeanRef);
                }
            }
        }
    }

    private void overrideStepClass(String beanName, ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
        Object isNamespaceStep = BeanDefinitionUtils.getAttribute(beanName, "isNamespaceStep", beanFactory);
        if (isNamespaceStep != null && ((Boolean)isNamespaceStep).booleanValue()) {
            ((AbstractBeanDefinition)bd).setBeanClass(StepParserStepFactoryBean.class);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return this.injectDefaults(bean);
    }

    private Object injectDefaults(Object bean) {
        if (bean instanceof JobParserJobFactoryBean) {
            JobParserJobFactoryBean fb = (JobParserJobFactoryBean)bean;
            JobRepository jobRepository = fb.getJobRepository();
            if (jobRepository == null) {
                fb.setJobRepository((JobRepository)this.applicationContext.getBean("jobRepository"));
            }
        } else if (bean instanceof StepParserStepFactoryBean) {
            PlatformTransactionManager transactionManager;
            StepParserStepFactoryBean fb = (StepParserStepFactoryBean)bean;
            JobRepository jobRepository = fb.getJobRepository();
            if (jobRepository == null) {
                fb.setJobRepository((JobRepository)this.applicationContext.getBean("jobRepository"));
            }
            if ((transactionManager = fb.getTransactionManager()) == null && fb.requiresTransactionManager()) {
                fb.setTransactionManager((PlatformTransactionManager)this.applicationContext.getBean(DEFAULT_TRANSACTION_MANAGER_NAME));
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

