/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.AbstractListenerParser;
import org.springframework.batch.core.listener.AbstractListenerFactoryBean;
import org.springframework.batch.core.listener.ListenerMetaData;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.listener.StepListenerMetaData;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class StepListenerParser
extends AbstractListenerParser {
    private static final String LISTENERS_ELE = "listeners";
    private static final String MERGE_ATTR = "merge";
    private final ListenerMetaData[] listenerMetaData;

    public StepListenerParser() {
        this(StepListenerMetaData.values());
    }

    public StepListenerParser(ListenerMetaData[] listenerMetaData) {
        this.listenerMetaData = listenerMetaData;
    }

    @Override
    protected Class<? extends AbstractListenerFactoryBean<?>> getBeanClass() {
        return StepListenerFactoryBean.class;
    }

    @Override
    protected ListenerMetaData[] getMetaDataValues() {
        return this.listenerMetaData;
    }

    public void handleListenersElement(Element stepElement, BeanDefinition beanDefinition, ParserContext parserContext) {
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        List listenersElements = DomUtils.getChildElementsByTagName((Element)stepElement, (String)LISTENERS_ELE);
        if (listenersElements.size() == 1) {
            Element listenersElement = (Element)listenersElements.get(0);
            CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(listenersElement.getTagName(), parserContext.extractSource((Object)stepElement));
            parserContext.pushContainingComponent(compositeDef);
            ManagedList listenerBeans = new ManagedList();
            if (propertyValues.contains(LISTENERS_ELE)) {
                listenerBeans = (ManagedList)propertyValues.getPropertyValue(LISTENERS_ELE).getValue();
            }
            listenerBeans.setMergeEnabled(listenersElement.hasAttribute(MERGE_ATTR) && Boolean.valueOf(listenersElement.getAttribute(MERGE_ATTR)) != false);
            List listenerElements = DomUtils.getChildElementsByTagName((Element)listenersElement, (String)"listener");
            if (listenerElements != null) {
                for (Element listenerElement : listenerElements) {
                    listenerBeans.add((Object)this.parse(listenerElement, parserContext));
                }
            }
            propertyValues.addPropertyValue(LISTENERS_ELE, (Object)listenerBeans);
            parserContext.popAndRegisterContainingComponent();
        }
    }
}

