/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.filter;

import com.jeesite.common.codec.DesUtils;
import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.network.IpUtils;
import com.jeesite.common.shiro.authc.FormToken;
import com.jeesite.common.shiro.filter.PermissionsAuthorizationFilter;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticationFilter
extends org.apache.shiro.web.filter.authc.FormAuthenticationFilter {
    public static final String DEFAULT_CAPTCHA_PARAM = "validCode";
    public static final String DEFAULT_PARAMS_PARAM = "params";
    public static final String DEFAULT_PARAM_PREFIX_PARAM = "param_";
    public static final String DEFAULT_MESSAGE_PARAM = "message";
    public static final String DEFAULT_REMEMBER_USERCODE_PARAM = "rememberUserCode";
    private static final Logger logger = LoggerFactory.getLogger(FormAuthenticationFilter.class);
    private BaseAuthorizingRealm authorizingRealm;
    private Cookie rememberUserCodeCookie = new SimpleCookie("rememberUserCode");

    public FormAuthenticationFilter() {
        this.rememberUserCodeCookie.setHttpOnly(true);
        this.rememberUserCodeCookie.setMaxAge(31536000);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) {
        String username = this.getUsername(request, response);
        String password = this.getPassword(request);
        boolean rememberMe = this.isRememberMe(request);
        String host = this.getHost(request);
        String captcha = this.getCaptcha(request);
        Map paramMap = ServletUtils.getExtParams((ServletRequest)request);
        return new FormToken(username, password.toCharArray(), rememberMe, host, captcha, paramMap);
    }

    protected String getUsername(ServletRequest request, ServletResponse response) {
        String secretKey;
        String username = super.getUsername(request);
        if (StringUtils.isBlank((CharSequence)username)) {
            username = ObjectUtils.toString((Object)request.getAttribute(this.getUsernameParam()), (String)"");
        }
        if (StringUtils.isNotBlank((CharSequence)(secretKey = Global.getProperty((String)"shiro.loginSubmit.secretKey"))) && StringUtils.isBlank((CharSequence)(username = DesUtils.decode((String)username, (String)secretKey)))) {
            logger.info("\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a\u6216\u89e3\u7801\u9519\u8bef.");
        }
        if (WebUtils.isTrue((ServletRequest)request, (String)DEFAULT_REMEMBER_USERCODE_PARAM)) {
            this.rememberUserCodeCookie.setValue(EncodeUtils.xssFilter((String)username));
            this.rememberUserCodeCookie.saveTo((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            this.rememberUserCodeCookie.removeFrom((HttpServletRequest)request, (HttpServletResponse)response);
        }
        return username;
    }

    protected String getPassword(ServletRequest request) {
        String secretKey;
        String password = super.getPassword(request);
        if (StringUtils.isBlank((CharSequence)password)) {
            password = ObjectUtils.toString((Object)request.getAttribute(this.getPasswordParam()), (String)"");
        }
        if (StringUtils.isNotBlank((CharSequence)(secretKey = Global.getProperty((String)"shiro.loginSubmit.secretKey"))) && StringUtils.isBlank((CharSequence)(password = DesUtils.decode((String)password, (String)secretKey)))) {
            logger.info("\u767b\u5f55\u5bc6\u7801\u4e3a\u7a7a\u6216\u89e3\u7801\u9519\u8bef.");
        }
        return password;
    }

    protected boolean isRememberMe(ServletRequest request) {
        String isRememberMe = WebUtils.getCleanParam((ServletRequest)request, (String)this.getRememberMeParam());
        if (StringUtils.isBlank((CharSequence)isRememberMe)) {
            isRememberMe = ObjectUtils.toString((Object)request.getAttribute(this.getRememberMeParam()), (String)"");
        }
        return ObjectUtils.toBoolean((Object)isRememberMe);
    }

    protected String getHost(ServletRequest request) {
        return IpUtils.getRemoteAddr((HttpServletRequest)((HttpServletRequest)request));
    }

    protected String getCaptcha(ServletRequest request) {
        String secretKey;
        String captcha = WebUtils.getCleanParam((ServletRequest)request, (String)DEFAULT_CAPTCHA_PARAM);
        if (StringUtils.isBlank((CharSequence)captcha)) {
            captcha = ObjectUtils.toString((Object)request.getAttribute(DEFAULT_CAPTCHA_PARAM), (String)"");
        }
        if (StringUtils.isNotBlank((CharSequence)(secretKey = Global.getProperty((String)"shiro.loginSubmit.secretKey")))) {
            captcha = DesUtils.decode((String)captcha, (String)secretKey);
        }
        return captcha;
    }

    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        PermissionsAuthorizationFilter.redirectToDefaultPath(request, response);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        if (this.isLoginRequest(request, response)) {
            if (this.isLoginSubmission(request, response)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Login submission detected.  Attempting to execute login.");
                }
                return this.executeLogin(request, response);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Login page view.");
            }
            return true;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Attempting to access a path which requires authentication.  Forwarding to the Authentication url [" + this.getLoginUrl() + "]");
        }
        this.redirectToLogin(request, response);
        return false;
    }

    protected boolean isLoginRequest(ServletRequest request, ServletResponse response) {
        boolean isLogin = WebUtils.isTrue((ServletRequest)request, (String)"__login");
        return super.isLoginRequest(request, response) || isLogin;
    }

    protected boolean isLoginSubmission(ServletRequest request, ServletResponse response) {
        boolean isLogin = WebUtils.isTrue((ServletRequest)request, (String)"__login");
        return super.isLoginSubmission(request, response) || isLogin;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        if (Global.getPropertyToBoolean((String)"shiro.isGenerateNewSessionAfterLogin", (String)"false").booleanValue()) {
            UserUtils.getSubject().logout();
        }
        return super.executeLogin(request, response);
    }

    protected boolean onLoginSuccess(AuthenticationToken token, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        this.authorizingRealm.onLoginSuccess((LoginInfo)subject.getPrincipal(), (HttpServletRequest)request);
        if (ServletUtils.isAjaxRequest((HttpServletRequest)((HttpServletRequest)request))) {
            request.getRequestDispatcher(this.getSuccessUrl()).forward(request, response);
        } else {
            String url = request.getParameter("__url");
            if (StringUtils.isNotBlank((CharSequence)url)) {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)url, null, (boolean)true);
            } else {
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.getSuccessUrl(), null, (boolean)true);
            }
        }
        return false;
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String className = e.getClass().getName();
        String message = "";
        if (IncorrectCredentialsException.class.getName().equals(className) || UnknownAccountException.class.getName().equals(className)) {
            message = Global.getText((String)"sys.login.failure", (String[])new String[0]);
        } else if (e.getMessage() != null && StringUtils.startsWith((CharSequence)e.getMessage(), (CharSequence)"msg:")) {
            message = StringUtils.replace((String)e.getMessage(), (String)"msg:", (String)"");
        } else {
            message = Global.getText((String)"sys.login.error", (String[])new String[0]);
            logger.error(message, (Throwable)e);
        }
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
        request.setAttribute(DEFAULT_MESSAGE_PARAM, (Object)message);
        return true;
    }

    public void setAuthorizingRealm(BaseAuthorizingRealm authorizingRealm) {
        this.authorizingRealm = authorizingRealm;
    }
}

