/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.filter;

import com.jeesite.common.config.Global;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.web.http.ServletUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutFilter
extends org.apache.shiro.web.filter.authc.LogoutFilter {
    private static final Logger log = LoggerFactory.getLogger(LogoutFilter.class);
    private BaseAuthorizingRealm authorizingRealm;

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        try {
            Subject subject = this.getSubject(request, response);
            String redirectUrl = this.getRedirectUrl(request, response, subject);
            try {
                Object principal = subject.getPrincipal();
                if (principal != null) {
                    this.authorizingRealm.onLogoutSuccess((LoginInfo)subject.getPrincipal(), (HttpServletRequest)request);
                }
                subject.logout();
            }
            catch (SessionException ise) {
                log.debug("Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)ise);
            }
            if (ServletUtils.isAjaxRequest((HttpServletRequest)((HttpServletRequest)request))) {
                ServletUtils.renderResult((HttpServletResponse)((HttpServletResponse)response), (String)"true", (String)Global.getText((String)"sys.logout.success", (String[])new String[0]));
                return false;
            }
            this.issueRedirect(request, response, redirectUrl);
        }
        catch (Exception e) {
            log.debug("Encountered session exception during logout.  This can generally safely be ignored.", (Throwable)e);
        }
        return false;
    }

    protected String getRedirectUrl(ServletRequest request, ServletResponse response, Subject subject) {
        String url = Global.getProperty((String)"shiro.logoutUrl");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}) && !url.equals(Global.getAdminPath() + "/logout")) {
            return url;
        }
        return super.getRedirectUrl(request, response, subject);
    }

    public void setAuthorizingRealm(BaseAuthorizingRealm authorizingRealm) {
        this.authorizingRealm = authorizingRealm;
    }
}

