/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.filter;

import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.common.web.http.wrapper.GetHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;

public class PermissionsAuthorizationFilter
extends org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter {
    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        PermissionsAuthorizationFilter.redirectToDefaultPath(request, response);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        return PermissionsAuthorizationFilter.redirectTo403Page(request, response);
    }

    public static boolean redirectTo403Page(ServletRequest request, ServletResponse response) throws IOException {
        Subject subject = SecurityUtils.getSubject();
        if (subject.getPrincipal() == null) {
            PermissionsAuthorizationFilter.redirectToDefaultPath(request, response);
        } else {
            try {
                request.getRequestDispatcher("/error/403").forward(request, response);
            }
            catch (ServletException e) {
                throw new UnauthorizedException((Throwable)e);
            }
        }
        return false;
    }

    public static void redirectToDefaultPath(ServletRequest request, ServletResponse response) throws IOException {
        String loginUrl = Global.getProperty((String)"shiro.defaultPath");
        HttpServletRequest req = (HttpServletRequest)request;
        if (StringUtils.equals((CharSequence)(req.getContextPath() + loginUrl), (CharSequence)req.getRequestURI())) {
            loginUrl = Global.getProperty((String)"shiro.loginUrl");
        }
        if (ServletUtils.isAjaxRequest((HttpServletRequest)req)) {
            try {
                request.getRequestDispatcher(loginUrl).forward((ServletRequest)new GetHttpServletRequestWrapper(request), response);
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        } else {
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)loginUrl);
        }
    }
}

