/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.common.shiro.realm;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.codec.Sha1Utils;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.utils.SpringUtils;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.LogUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;

public class AuthorizingRealm
extends BaseAuthorizingRealm {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    private UserService userService;

    public AuthorizingRealm() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher(HASH_ALGORITHM);
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    public String encryptPassword(String plainPassword) {
        String plain = EncodeUtils.decodeHtml((String)plainPassword);
        byte[] salt = Sha1Utils.genSalt((int)8);
        byte[] hashPassword = Sha1Utils.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
        return EncodeUtils.encodeHex((byte[])salt) + EncodeUtils.encodeHex((byte[])hashPassword);
    }

    public boolean validatePassword(String plainPassword, String password) {
        try {
            String plain = EncodeUtils.decodeHtml((String)plainPassword);
            byte[] salt = EncodeUtils.decodeHex((String)password.substring(0, 16));
            byte[] hashPassword = Sha1Utils.sha1((byte[])plain.getBytes(), (byte[])salt, (int)1024);
            return password.equals(EncodeUtils.encodeHex((byte[])salt) + EncodeUtils.encodeHex((byte[])hashPassword));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void onLoginSuccess(LoginInfo loginInfo, HttpServletRequest request) {
        super.onLoginSuccess(loginInfo, request);
        User user = UserUtils.get((String)loginInfo.getId());
        this.getUserService().updateUserLoginInfo(user);
        LogUtils.saveLog(user, request, "\u7cfb\u7edf\u767b\u5f55", "loginLogout");
    }

    public void onLogoutSuccess(LoginInfo loginInfo, HttpServletRequest request) {
        super.onLogoutSuccess(loginInfo, request);
        User user = UserUtils.get((String)loginInfo.getId());
        LogUtils.saveLog(user, request, "\u7cfb\u7edf\u9000\u51fa", "loginLogout");
    }

    public UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)SpringUtils.getBean(UserService.class);
        }
        return this.userService;
    }
}

