/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.config.web.interceptor;

import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.modules.sys.interceptor.LogInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableWebMvc
@ConditionalOnProperty(name={"web.interceptor.log.enabled"}, havingValue="true", matchIfMissing=true)
public class LogInterceptorConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)new LogInterceptor());
        String apps = Global.getProperty((String)"web.interceptor.log.addPathPatterns");
        String epps = Global.getProperty((String)"web.interceptor.log.excludePathPatterns");
        for (String uri : StringUtils.split((String)apps, (String)",")) {
            if (!StringUtils.isNotBlank((CharSequence)uri)) continue;
            registration.addPathPatterns(new String[]{StringUtils.trim((String)uri)});
        }
        for (String uri : StringUtils.split((String)epps, (String)",")) {
            if (!StringUtils.isNotBlank((CharSequence)uri)) continue;
            registration.excludePathPatterns(new String[]{StringUtils.trim((String)uri)});
        }
    }
}

