/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.entity;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.entity.BaseEntity;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Extend;
import com.jeesite.common.entity.TreeEntity;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.mybatis.annotation.Column;
import com.jeesite.common.mybatis.annotation.JoinTable;
import com.jeesite.common.mybatis.annotation.Table;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.modules.sys.entity.Area;
import com.jeesite.modules.sys.entity.CompanyOffice;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Table(name="${_prefix}sys_company", alias="a", columns={@Column(includeEntity=BaseEntity.class), @Column(includeEntity=DataEntity.class), @Column(includeEntity=TreeEntity.class), @Column(name="company_code", attrName="companyCode", label="\u516c\u53f8\u7f16\u7801", isPK=true), @Column(name="view_code", attrName="viewCode", label="\u516c\u53f8\u4ee3\u7801"), @Column(name="company_name", attrName="companyName", label="\u516c\u53f8\u540d\u79f0", queryType=QueryType.LIKE, isTreeName=true), @Column(name="full_name", attrName="fullName", label="\u516c\u53f8\u5168\u79f0", queryType=QueryType.LIKE), @Column(name="area_code", attrName="area.areaCode", label="\u533a\u57df\u7f16\u7801"), @Column(includeEntity=Extend.class, attrName="extend")}, joinTable={@JoinTable(type=JoinTable.Type.LEFT_JOIN, entity=Area.class, alias="b", on="b.area_code = a.area_code", columns={@Column(name="area_code", label="\u533a\u57df\u4ee3\u7801", isPK=true), @Column(name="area_name", label="\u533a\u57df\u540d\u79f0", isQuery=false), @Column(name="area_type", label="\u533a\u57df\u7c7b\u578b"), @Column(name="tree_names", label="\u533a\u57df\u5168\u79f0")})}, extWhereKeys="dsf", orderBy="a.tree_sorts, a.company_code")
public class Company
extends TreeEntity<Company> {
    private static final long serialVersionUID = 1L;
    private String companyCode;
    private String viewCode;
    private String companyName;
    private String fullName;
    private Area area;
    private Extend extend;
    private List<CompanyOffice> companyOfficeList = ListUtils.newArrayList();

    public Company() {
        this(null);
    }

    public Company(String id) {
        super(id);
    }

    public Company getParent() {
        return (Company)this.parent;
    }

    public void setParent(Company parent) {
        this.parent = parent;
    }

    public String getCompanyCode() {
        return this.companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    @NotBlank(message="\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a")
    @Pattern(regexp="[a-zA-Z0-9_]{0,30}", message="\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e 30 \u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf")
    public @NotBlank(message="\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") @Pattern(regexp="[a-zA-Z0-9_]{0,30}", message="\u4ee3\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e 30 \u4e2a\u5b57\u7b26\uff0c\u5e76\u4e14\u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf") String getViewCode() {
        return this.viewCode;
    }

    public void setViewCode(String viewCode) {
        this.viewCode = viewCode;
    }

    @NotBlank(message="\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=200, message="\u516c\u53f8\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public @NotBlank(message="\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=0, max=200, message="\u516c\u53f8\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26") String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @NotBlank(message="\u516c\u53f8\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(min=0, max=200, message="\u516c\u53f8\u5168\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26")
    public @NotBlank(message="\u516c\u53f8\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(min=0, max=200, message="\u516c\u53f8\u5168\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7 200 \u4e2a\u5b57\u7b26") String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public Extend getExtend() {
        return this.extend;
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    public List<CompanyOffice> getCompanyOfficeList() {
        return this.companyOfficeList;
    }

    public void setCompanyOfficeListJson(String jsonString) {
        List list = (List)JsonMapper.fromJson((String)jsonString, List.class);
        if (list != null) {
            for (String val : list) {
                if (!StringUtils.isNotBlank((CharSequence)val)) continue;
                CompanyOffice e = new CompanyOffice();
                e.setCompanyCode(this.companyCode);
                e.setOfficeCode(val);
                e.setIsNewRecord(true);
                this.companyOfficeList.add(e);
            }
        }
    }
}

