/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.interceptor;

import com.jeesite.common.lang.ByteUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.TimeUtils;
import com.jeesite.common.service.BaseService;
import com.jeesite.modules.sys.utils.LogUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
extends BaseService
implements HandlerInterceptor {
    private static final ThreadLocal<Long> startTimeThreadLocal = new NamedThreadLocal("LogInterceptor StartTime");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long beginTime = System.currentTimeMillis();
        startTimeThreadLocal.set(beginTime);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u5f00\u59cb\u8ba1\u65f6: {}  URI: {}", (Object)new SimpleDateFormat("hh:mm:ss.SSS").format(beginTime), (Object)request.getRequestURI());
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView != null) {
            this.logger.info("ViewName: " + modelAndView.getViewName() + " <<<<<<<<< " + request.getRequestURI() + " >>>>>>>>> " + handler);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        long beginTime = startTimeThreadLocal.get();
        long endTime = System.currentTimeMillis();
        long executeTime = endTime - beginTime;
        startTimeThreadLocal.remove();
        LogUtils.saveLog(UserUtils.getUser(), request, handler, ex, null, null, executeTime);
        if (this.logger.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            this.logger.debug("\u8ba1\u65f6\u7ed3\u675f: {}  \u7528\u65f6: {}  URI: {}  \u603b\u5185\u5b58: {}  \u5df2\u7528\u5185\u5b58: {}", new Object[]{DateUtils.formatDate((long)endTime, (String)"hh:mm:ss.SSS"), TimeUtils.formatDateAgo((long)executeTime), request.getRequestURI(), ByteUtils.formatByteSize((long)runtime.totalMemory()), ByteUtils.formatByteSize((long)(runtime.totalMemory() - runtime.freeMemory()))});
        }
    }
}

