/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.service.support;

import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.service.CrudService;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.utils.excel.ExcelImport;
import com.jeesite.common.validator.ValidatorUtils;
import com.jeesite.modules.sys.dao.EmpUserDao;
import com.jeesite.modules.sys.entity.EmpUser;
import com.jeesite.modules.sys.entity.Employee;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.EmpUserService;
import com.jeesite.modules.sys.service.EmployeeService;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.EmpUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.List;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional(readOnly=true)
public class EmpUserServiceSupport
extends CrudService<EmpUserDao, EmpUser>
implements EmpUserService {
    @Autowired
    private UserService userService;
    @Autowired
    private EmployeeService employeeService;

    @Override
    public EmpUser get(EmpUser empUser) {
        return (EmpUser)super.get((DataEntity)empUser);
    }

    @Override
    public void addDataScopeFilter(EmpUser empUser, String ctrlPermi) {
        empUser.getSqlMap().getDataScope().addFilter("dsfOffice", "Office", "e.office_code", "a.create_by", ctrlPermi);
        if (StringUtils.isNotBlank((CharSequence)EmpUtils.getCompany().getCompanyCode())) {
            empUser.getSqlMap().getDataScope().addFilter("dsfCompany", "Company", "e.company_code", "a.create_by", ctrlPermi);
        }
    }

    @Override
    public Page<EmpUser> findPage(EmpUser empUser) {
        return super.findPage((DataEntity)empUser);
    }

    @Override
    @Transactional(readOnly=false)
    public void save(EmpUser user) {
        Employee employee;
        if (user.getIsNewRecord()) {
            this.userService.genId((DataEntity)user, user.getLoginCode());
            user.setUserCode(user.getUserCode() + "_" + IdGen.randomBase62((int)4).toLowerCase());
            user.setUserType("employee");
            user.setMgrType("0");
        }
        if (StringUtils.isBlank((CharSequence)(employee = user.getEmployee()).getEmpCode())) {
            employee.setEmpCode(user.getUserCode());
        }
        if (StringUtils.isBlank((CharSequence)employee.getEmpName())) {
            employee.setEmpName(user.getUserName());
        }
        user.setRefCode(employee.getEmpCode());
        user.setRefName(employee.getEmpName());
        this.userService.save((User)user);
        employee.setIsNewRecord(user.getIsNewRecord());
        this.employeeService.save(employee);
    }

    @Override
    @Transactional(readOnly=false)
    public String importData(MultipartFile file, Boolean isUpdateSupport) {
        if (file == null) {
            throw new ServiceException("\u8bf7\u9009\u62e9\u5bfc\u5165\u7684\u6570\u636e\u6587\u4ef6\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        try (ExcelImport ei = new ExcelImport(file, 2, (Object)0);){
            List list = ei.getDataList(EmpUser.class, new String[0]);
            for (EmpUser user : list) {
                try {
                    ValidatorUtils.validateWithException((Object)((Object)user), (Class[])new Class[0]);
                    User u = UserUtils.getByLoginCode((String)user.getLoginCode());
                    if (u == null) {
                        this.save(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginCode() + " \u5bfc\u5165\u6210\u529f");
                        continue;
                    }
                    if (isUpdateSupport.booleanValue()) {
                        user.setUserCode(u.getUserCode());
                        this.save(user);
                        successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getLoginCode() + " \u66f4\u65b0\u6210\u529f");
                        continue;
                    }
                    failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginCode() + " \u5df2\u5b58\u5728");
                }
                catch (Exception e) {
                    String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getLoginCode() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                    if (e instanceof ConstraintViolationException) {
                        List messageList = ValidatorUtils.extractPropertyAndMessageAsList((ConstraintViolationException)((ConstraintViolationException)e), (String)": ");
                        for (String message : messageList) {
                            msg = msg + message + "; ";
                        }
                    } else {
                        msg = msg + e.getMessage();
                    }
                    failureMsg.append(msg);
                    this.logger.error(msg, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            failureMsg.append(e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new ServiceException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }

    @Override
    @Transactional(readOnly=false)
    public void updateStatus(EmpUser empUser) {
        this.userService.delete((User)empUser);
        this.employeeService.delete(empUser.getEmployee());
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(EmpUser empUser) {
        this.userService.delete((User)empUser);
        this.employeeService.delete(empUser.getEmployee());
    }
}

