/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.idgen.IdGen;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Company;
import com.jeesite.modules.sys.entity.Office;
import com.jeesite.modules.sys.service.CompanyService;
import com.jeesite.modules.sys.service.OfficeService;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/company"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class CompanyController
extends BaseController {
    @Autowired
    private CompanyService companyService;
    @Autowired
    private OfficeService officeService;

    @ModelAttribute
    public Company get(String companyCode, boolean isNewRecord) {
        return (Company)this.companyService.get(companyCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:company:view"})
    @RequestMapping(value={"list"})
    public String list(Company company, HttpServletRequest request, HttpServletResponse response, Model model) {
        return "modules/sys/companyList";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<Company> listData(Company company, String ctrlPermi) {
        if (StringUtils.isBlank((CharSequence)company.getParentCode())) {
            company.setParentCode("0");
        }
        if (StringUtils.isNotBlank((CharSequence)company.getViewCode()) || StringUtils.isNotBlank((CharSequence)company.getCompanyName()) || StringUtils.isNotBlank((CharSequence)company.getFullName())) {
            company.setParentCode(null);
        }
        this.companyService.addDataScopeFilter(company, ctrlPermi);
        List<Company> list = this.companyService.findList(company);
        return list;
    }

    @RequiresPermissions(value={"sys:company:view"})
    @RequestMapping(value={"form"})
    public String form(Company company, Model model, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)(company = this.createNextNode(company)).getCompanyCode())) {
            Office office = new Office();
            office.setCompanyCode(company.getCompanyCode());
            List<Office> officeList = this.officeService.findList(office);
            model.addAttribute("officeList", officeList);
        }
        model.addAttribute("company", (Object)company);
        return "modules/sys/companyForm";
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @RequestMapping(value={"createNextNode"})
    @ResponseBody
    public Company createNextNode(Company company) {
        if (StringUtils.isNotBlank((CharSequence)company.getParentCode())) {
            company.setParent((Company)this.companyService.get(company.getParentCode()));
        }
        if (company.getIsNewRecord()) {
            Company where = new Company();
            where.setParentCode(company.getParentCode());
            Company last = (Company)this.companyService.getLastByParentCode(where);
            if (last != null) {
                company.setTreeSort(last.getTreeSort() + 30);
                company.setViewCode(IdGen.nextCode((String)last.getViewCode()));
            } else if (company.getParent() != null) {
                company.setViewCode(company.getParent().getViewCode() + "001");
            }
        }
        if (company.getTreeSort() == null) {
            company.setTreeSort(30);
        }
        return company;
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Company company) {
        this.companyService.save(company);
        return this.renderResult("true", CompanyController.text((String)"\u4fdd\u5b58\u516c\u53f8''{0}''\u6210\u529f", (String[])new String[]{company.getCompanyName()}));
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Company company) {
        Company where = new Company();
        where.setStatus("0");
        where.setParentCodes("," + company.getId() + ",");
        long count = this.companyService.findCount((DataEntity)where);
        if (count > 0L) {
            return this.renderResult("false", CompanyController.text((String)"\u8be5\u516c\u53f8\u5305\u542b\u672a\u505c\u7528\u7684\u5b50\u516c\u53f8\uff01", (String[])new String[0]));
        }
        company.setStatus("2");
        this.companyService.updateStatus(company);
        return this.renderResult("true", CompanyController.text((String)"\u505c\u7528\u516c\u53f8''{0}''\u6210\u529f", (String[])new String[]{company.getCompanyName()}));
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Company company) {
        company.setStatus("0");
        this.companyService.updateStatus(company);
        return this.renderResult("true", CompanyController.text((String)"\u542f\u7528\u516c\u53f8''{0}''\u6210\u529f", (String[])new String[]{company.getCompanyName()}));
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Company company) {
        this.companyService.delete(company);
        return this.renderResult("true", CompanyController.text((String)"\u5220\u9664\u516c\u53f8''{0}''\u6210\u529f", (String[])new String[]{company.getCompanyName()}));
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String excludeCode, Boolean isAll, String isShowCode, String isShowFullName, String ctrlPermi) {
        ArrayList mapList = ListUtils.newArrayList();
        Company where = new Company();
        where.setStatus("0");
        if (isAll == null || !isAll.booleanValue()) {
            this.companyService.addDataScopeFilter(where, ctrlPermi);
        }
        List<Company> list = this.companyService.findList(where);
        for (int i = 0; i < list.size(); ++i) {
            Company e = list.get(i);
            if (!"0".equals(e.getStatus()) || StringUtils.isNotBlank((CharSequence)excludeCode) && (e.getId().equals(excludeCode) || e.getParentCodes().contains("," + excludeCode + ","))) continue;
            HashMap map = MapUtils.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentCode());
            String name = e.getCompanyName();
            if ("true".equals(isShowFullName) || "1".equals(isShowFullName)) {
                name = e.getFullName();
            }
            map.put("name", StringUtils.getTreeNodeName((String)isShowCode, (String)e.getViewCode(), (String)name));
            map.put("title", e.getFullName());
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"sys:company:edit"})
    @RequestMapping(value={"fixTreeData"})
    @ResponseBody
    public String fixTreeData() {
        if (!UserUtils.getUser().isAdmin()) {
            return this.renderResult("false", "\u64cd\u4f5c\u5931\u8d25\uff0c\u53ea\u6709\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u4fee\u590d\uff01");
        }
        this.companyService.fixTreeData();
        return this.renderResult("true", "\u6570\u636e\u4fee\u590d\u6210\u529f");
    }
}

