/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.shiro.realm.BaseAuthorizingRealm;
import com.jeesite.common.shiro.realm.LoginInfo;
import com.jeesite.common.web.BaseController;
import com.jeesite.common.web.CookieUtils;
import com.jeesite.common.web.http.ServletUtils;
import com.jeesite.modules.sys.entity.Menu;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.utils.PwdUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}"})
public class LoginController
extends BaseController {
    @RequestMapping(value={"login"}, method={RequestMethod.GET})
    public String login(HttpServletRequest request, HttpServletResponse response, Model model) {
        String view;
        if (StringUtils.containsIgnoreCase((CharSequence)request.getRequestURI(), (CharSequence)";JSESSIONID=")) {
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/login" + queryString));
            return null;
        }
        LoginInfo loginInfo = UserUtils.getLoginInfo();
        if (loginInfo != null) {
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/index" + queryString));
            return null;
        }
        if (WebUtils.isTrue((ServletRequest)request, (String)"__login")) {
            return this.loginFailure(request, response, model);
        }
        if (!"true".equals(Global.getConfig((String)"shiro.isAllowRefreshIndex"))) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"false");
        }
        model.addAttribute("isValidCodeLogin", (Object)(Global.getConfigToInteger((String)"sys.login.failedNumAfterValidCode", (String)"200") == 0 ? 1 : 0));
        Session session = UserUtils.getSession();
        model.addAttribute("sessionid", (Object)((String)((Object)session.getId())));
        Map paramMap = ServletUtils.getExtParams((ServletRequest)request);
        if (paramMap.get("lang") != null) {
            Global.setLang((String)((String)paramMap.get("lang")), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            model.addAttribute("result", (Object)"login");
            model.addAttribute("message", (Object)LoginController.text((String)"sys.login.notLongIn", (String[])new String[0]));
            return ServletUtils.renderObject((HttpServletResponse)response, (Object)model);
        }
        String userType = (String)paramMap.get("userType");
        if (StringUtils.isNotBlank((CharSequence)userType) && StringUtils.isNotBlank((CharSequence)(view = UserUtils.getUserTypeValue((String)userType, (String)"loginView")))) {
            return view;
        }
        return "modules/sys/sysLogin";
    }

    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    public String loginFailure(HttpServletRequest request, HttpServletResponse response, Model model) {
        String view;
        LoginInfo loginInfo = UserUtils.getLoginInfo();
        if (loginInfo != null) {
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/index" + queryString));
            return null;
        }
        String username = WebUtils.getCleanParam((ServletRequest)request, (String)"username");
        boolean rememberMe = WebUtils.isTrue((ServletRequest)request, (String)"rememberMe");
        boolean rememberUserCode = WebUtils.isTrue((ServletRequest)request, (String)"rememberUserCode");
        String params = WebUtils.getCleanParam((ServletRequest)request, (String)"params");
        String exception = (String)request.getAttribute("shiroLoginFailure");
        String message = (String)request.getAttribute("message");
        model.addAttribute("username", (Object)username);
        model.addAttribute("rememberMe", (Object)rememberMe);
        model.addAttribute("rememberUserCode", (Object)rememberUserCode);
        model.addAttribute("params", (Object)params);
        Map paramMap = ServletUtils.getExtParams((ServletRequest)request);
        for (Map.Entry entry : paramMap.entrySet()) {
            model.addAttribute("param_" + (String)entry.getKey(), entry.getValue());
        }
        model.addAttribute("shiroLoginFailure", (Object)exception);
        if (paramMap.get("lang") != null) {
            Global.setLang((String)((String)paramMap.get("lang")), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        model.addAttribute("message", (Object)LoginController.text((String)message, (String[])new String[0]));
        if (!UnauthorizedException.class.getName().equals(exception)) {
            model.addAttribute("isValidCodeLogin", (Object)BaseAuthorizingRealm.isValidCodeLogin((String)username, (String)((String)paramMap.get("deviceType")), (String)"failed"));
        }
        Session session = UserUtils.getSession();
        model.addAttribute("sessionid", (Object)((String)((Object)session.getId())));
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            model.addAttribute("result", (Object)"false");
            return ServletUtils.renderObject((HttpServletResponse)response, (Object)model);
        }
        String userType = (String)paramMap.get("userType");
        if (StringUtils.isNotBlank((CharSequence)userType) && StringUtils.isNotBlank((CharSequence)(view = UserUtils.getUserTypeValue((String)userType, (String)"loginView")))) {
            return view;
        }
        return "modules/sys/sysLogin";
    }

    @RequestMapping(value={"index"})
    public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
        String passwordModifyUrl;
        String successUrl;
        if (StringUtils.containsIgnoreCase((CharSequence)request.getRequestURI(), (CharSequence)";JSESSIONID=")) {
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/index" + queryString));
            return null;
        }
        Subject subject = SecurityUtils.getSubject();
        if (subject == null || !subject.isPermitted("user")) {
            String queryString;
            if (subject != null) {
                subject.logout();
            }
            queryString = (queryString = request.getQueryString()) == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/login" + queryString));
            return null;
        }
        LoginInfo loginInfo = UserUtils.getLoginInfo();
        if (loginInfo == null) {
            UserUtils.getSubject().logout();
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/login" + queryString));
            return null;
        }
        User user = UserUtils.get((String)loginInfo.getId());
        if (user == null) {
            UserUtils.getSubject().logout();
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            ServletUtils.redirectUrl((HttpServletRequest)request, (HttpServletResponse)response, (String)(this.adminPath + "/login" + queryString));
            return null;
        }
        model.addAttribute("user", (Object)user);
        Session session = UserUtils.getSession();
        boolean isLogin = "true".equals(session.getAttribute((Object)"__login"));
        if (isLogin) {
            session.removeAttribute((Object)"__login");
            String cookieName = Global.getProperty((String)"session.shareSessionIdCookieName");
            if (StringUtils.isNotBlank((CharSequence)cookieName)) {
                CookieUtils.setCookie((HttpServletResponse)response, (String)cookieName, (String)((String)((Object)session.getId())));
            }
            if (loginInfo.getParam("lang") != null) {
                Global.setLang((String)loginInfo.getParam("lang"), (HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        if (!StringUtils.contains((CharSequence)(successUrl = Global.getProperty((String)"shiro.successUrl")), (CharSequence)"://")) {
            successUrl = request.getContextPath() + successUrl;
        }
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            model.addAttribute("result", (Object)"true");
            if (isLogin) {
                model.addAttribute("message", (Object)LoginController.text((String)"sys.login.success", (String[])new String[0]));
            } else {
                model.addAttribute("message", (Object)LoginController.text((String)"sys.login.getInfo", (String[])new String[0]));
            }
            model.addAttribute("sessionid", (Object)((String)((Object)session.getId())));
            model.addAttribute("__url", (Object)successUrl);
            return ServletUtils.renderObject((HttpServletResponse)response, (Object)model);
        }
        if (isLogin) {
            return "redirect:" + successUrl;
        }
        if (!Global.getConfigToBoolean((String)"shiro.isAllowRefreshIndex", (String)"true").booleanValue()) {
            String logined = CookieUtils.getCookie((HttpServletRequest)request, (String)"LOGINED");
            if (StringUtils.isBlank((CharSequence)logined) || "false".equals(logined)) {
                CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"true");
            } else if (StringUtils.equals((CharSequence)logined, (CharSequence)"true")) {
                UserUtils.getSubject().logout();
                CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"false");
                String queryString = request.getQueryString();
                queryString = queryString == null ? "" : "?" + queryString;
                return "redirect:" + this.adminPath + "/login" + queryString;
            }
        }
        if ((passwordModifyUrl = PwdUtils.passwordModifyValid((User)user, (Model)model)) != null) {
            try {
                request.getRequestDispatcher(passwordModifyUrl).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
        String view = UserUtils.getUserTypeValue((String)user.getUserType(), (String)"indexView");
        if (StringUtils.isNotBlank((CharSequence)view)) {
            return view;
        }
        return "modules/sys/sysIndex";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"authInfo"})
    @ResponseBody
    public AuthorizationInfo authInfo() {
        return UserUtils.getAuthInfo();
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"menuTree"})
    @ResponseBody
    public List<Menu> menuTree(String parentCode) {
        if (StringUtils.isNotBlank((CharSequence)parentCode)) {
            return UserUtils.getMenuListByParentCode((String)parentCode);
        }
        return UserUtils.getMenuTree();
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"switch/{sysCode}"})
    public String switchSys(@PathVariable String sysCode) {
        LoginInfo principal = UserUtils.getLoginInfo();
        User user = UserUtils.get((String)principal.getId());
        if (user.isSuperAdmin() && StringUtils.isNotBlank((CharSequence)sysCode) && !StringUtils.equals((CharSequence)principal.getParam("sysCode"), (CharSequence)sysCode)) {
            principal.setParam("sysCode", sysCode);
            UserUtils.removeCacheByKeyPrefix((String)"menuList");
            UserUtils.removeCache((String)"authInfo");
        }
        return "redirect:" + this.adminPath + "/index";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"switchSkin/{skinName}"})
    public String switchSkin(@PathVariable String skinName, HttpServletRequest request, HttpServletResponse response) {
        LoginInfo loginInfo = UserUtils.getLoginInfo();
        if (StringUtils.isNotBlank((CharSequence)skinName) && !"select".equals(skinName)) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)("skinName_" + loginInfo.getId()), (String)skinName);
            return "redirect:" + this.adminPath + "/index";
        }
        return "modules/sys/sysSwitchSkin";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"desktop"})
    public String desktop(HttpServletRequest request, HttpServletResponse response, Model model) {
        return "modules/sys/sysDesktop";
    }
}

