/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Post;
import com.jeesite.modules.sys.service.PostService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/post"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class PostController
extends BaseController {
    @Autowired
    private PostService postService;

    @ModelAttribute
    public Post get(String postCode, boolean isNewRecord) {
        return (Post)this.postService.get(postCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:post:view"})
    @RequestMapping(value={"list"})
    public String list(Post post, Model model) {
        return "modules/sys/postList";
    }

    @RequiresPermissions(value={"sys:post:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Post> listData(Post post, HttpServletRequest request, HttpServletResponse response) {
        post.setPage(new Page(request, response));
        Page<Post> page = this.postService.findPage(post);
        return page;
    }

    @RequiresPermissions(value={"sys:post:view"})
    @RequestMapping(value={"form"})
    public String form(Post post, Model model) {
        if (post.getIsNewRecord()) {
            post.setPostSort((int)this.postService.findCount(post) * 10);
        }
        model.addAttribute("post", (Object)post);
        return "modules/sys/postForm";
    }

    @RequiresPermissions(value={"sys:post:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Post post, String oldRoleName, Model model) {
        if (!"true".equals(this.checkPostName(oldRoleName, post.getPostName()))) {
            return this.renderResult("false", PostController.text((String)"\u4fdd\u5b58\u5c97\u4f4d\u5931\u8d25\uff0c\u5c97\u4f4d\u540d\u79f0''{0}''\u5df2\u5b58\u5728", (String[])new String[]{post.getPostName()}));
        }
        this.postService.save(post);
        return this.renderResult("true", PostController.text((String)"\u4fdd\u5b58\u5c97\u4f4d''{0}''\u6210\u529f", (String[])new String[]{post.getPostName()}));
    }

    @RequiresPermissions(value={"sys:post:edit"})
    @RequestMapping(value={"disable"})
    @ResponseBody
    public String disable(Post post, HttpServletRequest request, HttpServletResponse response, Model model) {
        post.setStatus("2");
        this.postService.updateStatus(post);
        return this.renderResult("true", PostController.text((String)"\u505c\u7528\u5c97\u4f4d''{0}''\u6210\u529f", (String[])new String[]{post.getPostName()}));
    }

    @RequiresPermissions(value={"sys:post:edit"})
    @RequestMapping(value={"enable"})
    @ResponseBody
    public String enable(Post post, HttpServletRequest request, HttpServletResponse response, Model model) {
        post.setStatus("0");
        this.postService.updateStatus(post);
        return this.renderResult("true", PostController.text((String)"\u542f\u7528\u5c97\u4f4d''{0}''\u6210\u529f", (String[])new String[]{post.getPostName()}));
    }

    @RequiresPermissions(value={"sys:post:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Post post) {
        this.postService.delete(post);
        return this.renderResult("true", PostController.text((String)"\u5220\u9664\u5c97\u4f4d''{0}''\u6210\u529f", (String[])new String[]{post.getPostName()}));
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkPostName"})
    @ResponseBody
    public String checkPostName(String oldPostName, String postName) {
        Post post = new Post();
        post.setPostName(postName);
        if (postName != null && postName.equals(oldPostName)) {
            return "true";
        }
        if (postName != null && this.postService.getByPostName(post) == null) {
            return "true";
        }
        return "false";
    }
}

