/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web.user;

import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.config.Global;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.msg.EmailUtils;
import com.jeesite.common.msg.SmsUtils;
import com.jeesite.common.service.ServiceException;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.PwdUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import com.jeesite.modules.sys.utils.ValidCodeUtils;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/account"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class AccountController
extends BaseController {
    @Autowired
    private UserService userService;

    @RequestMapping(value={"forgetPwd"})
    public String forgetPwd(Model model) {
        model.addAttribute("message", (Object)"\u6b63\u5728\u7814\u53d1\u4e2d\uff0c\u656c\u8bf7\u671f\u5f85\uff01");
        return "modules/sys/account/forgetPwd";
    }

    @PostMapping(value={"getFpValidCode"})
    @ResponseBody
    public String getFpValidCode(User user, String validCode, String validType, HttpServletRequest request) {
        if (!ValidCodeUtils.validate((HttpServletRequest)request, (String)validCode)) {
            return this.renderResult("false", "\u56fe\u7247\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u5237\u65b0\uff01");
        }
        if (!"mobile".equals(validType) && !"email".equals(validType)) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\u3002");
        }
        User u = UserUtils.getByLoginCode((String)user.getLoginCode());
        if (u == null) {
            return this.renderResult("false", "\u767b\u5f55\u8d26\u53f7\u4e0d\u6b63\u786e\uff01");
        }
        if ("mobile".equals(validType) && StringUtils.isBlank((CharSequence)u.getMobile())) {
            return this.renderResult("false", "\u8be5\u8d26\u53f7\u672a\u8bbe\u7f6e\u624b\u673a\u53f7\u7801\uff01");
        }
        if ("email".equals(validType) && StringUtils.isBlank((CharSequence)u.getEmail())) {
            return this.renderResult("false", "\u8be5\u8d26\u53f7\u672a\u8bbe\u7f6e\u90ae\u4ef6\u5730\u5740\uff01");
        }
        Date date = (Date)UserUtils.getCache((String)"fpLastDate");
        if (date != null && (System.currentTimeMillis() - date.getTime()) / 1000L < 20L) {
            return this.renderResult("false", "\u60a8\u5f53\u524d\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u4e00\u4f1a\u518d\u64cd\u4f5c\uff01");
        }
        UserUtils.putCache((String)"fpLastDate", (Object)new Date());
        String fpValidCode = StringUtils.getRandomNum((int)6);
        UserUtils.putCache((String)"fpUserCode", (Object)u.getUserCode());
        UserUtils.putCache((String)"fpLoginCode", (Object)u.getLoginCode());
        UserUtils.putCache((String)"fpValidCode", (Object)fpValidCode);
        if ("mobile".equals(validType)) {
            return this.sendSmsValidCode(u, fpValidCode, "\u627e\u56de\u5bc6\u7801");
        }
        if ("email".equals(validType)) {
            return this.sendEmailValidCode(u, fpValidCode, "\u627e\u56de\u5bc6\u7801");
        }
        return null;
    }

    @PostMapping(value={"savePwdByValidCode"})
    @ResponseBody
    public String savePwdByValidCode(User user, String fpValidCode, HttpServletRequest request) {
        String userCode = (String)UserUtils.getCache((String)"fpUserCode");
        String loginCode = (String)UserUtils.getCache((String)"fpLoginCode");
        String validCode = (String)UserUtils.getCache((String)"fpValidCode");
        Date date = (Date)UserUtils.getCache((String)"fpLastDate");
        if (userCode == null || loginCode == null || !loginCode.equals(user.getLoginCode())) {
            return this.renderResult("false", "\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
        }
        UserUtils.removeCache((String)"fpUserCode");
        UserUtils.removeCache((String)"fpLoginCode");
        UserUtils.removeCache((String)"fpValidCode");
        UserUtils.removeCache((String)"fpLastDate");
        boolean isTimeout = true;
        String validTime = Global.getConfig((String)"sys.account.validCodeTimeout", (String)"10");
        if ("0".equals(validTime) || date != null && (System.currentTimeMillis() - date.getTime()) / 1000L < 60L * Long.parseLong(validTime)) {
            isTimeout = false;
        }
        if (validCode == null || !validCode.equals(fpValidCode) || isTimeout) {
            return this.renderResult("false", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
        }
        try {
            this.userService.updatePassword(userCode, user.getPassword());
        }
        catch (ServiceException se) {
            return this.renderResult("false", se.getMessage());
        }
        return this.renderResult("true", "\u606d\u559c\u4f60\uff0c\u60a8\u7684\u8d26\u53f7 " + loginCode + " \u5bc6\u7801\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"getPwdQuestion"})
    @ResponseBody
    public String getPwdQuestion(User user, String validCode, HttpServletRequest request) {
        if (!ValidCodeUtils.validate((HttpServletRequest)request, (String)validCode)) {
            return this.renderResult("false", "\u56fe\u7247\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u5237\u65b0\uff01");
        }
        User u = UserUtils.getByLoginCode((String)user.getLoginCode());
        if (u == null) {
            return this.renderResult("false", "\u767b\u5f55\u8d26\u53f7\u4e0d\u6b63\u786e\uff01");
        }
        Date date = (Date)UserUtils.getCache((String)"fpLastDate");
        if (date != null && (System.currentTimeMillis() - date.getTime()) / 1000L < 20L) {
            return this.renderResult("false", "\u60a8\u5f53\u524d\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u4e00\u4f1a\u518d\u64cd\u4f5c\uff01");
        }
        UserUtils.putCache((String)"fpLastDate", (Object)new Date());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{u.getPwdQuestion(), u.getPwdQuestion2(), u.getPwdQuestion3()})) {
            return this.renderResult("false", "\u8be5\u8d26\u53f7\u672a\u8bbe\u7f6e\u5bc6\u4fdd\u95ee\u9898\uff01");
        }
        HashMap data = MapUtils.newHashMap();
        data.put("pwdQuestion", u.getPwdQuestion());
        data.put("pwdQuestion2", u.getPwdQuestion2());
        data.put("pwdQuestion3", u.getPwdQuestion3());
        UserUtils.putCache((String)"fpUserCode", (Object)u.getUserCode());
        UserUtils.putCache((String)"fpLoginCode", (Object)u.getLoginCode());
        return this.renderResult("true", "\u83b7\u53d6\u5bc6\u4fdd\u95ee\u9898\u6210\u529f\uff01", data);
    }

    @PostMapping(value={"savePwdByPwdQuestion"})
    @ResponseBody
    public String savePwdByPwdQuestion(User user, HttpServletRequest request) {
        String userCode = (String)UserUtils.getCache((String)"fpUserCode");
        String loginCode = (String)UserUtils.getCache((String)"fpLoginCode");
        if (userCode == null || loginCode == null || !loginCode.equals(user.getLoginCode())) {
            return this.renderResult("false", "\u8bf7\u91cd\u65b0\u83b7\u53d6\u4fdd\u5bc6\u95ee\u9898\uff01");
        }
        UserUtils.removeCache((String)"fpUserCode");
        UserUtils.removeCache((String)"fpLoginCode");
        User u = UserUtils.getByLoginCode((String)user.getLoginCode());
        if (!(u != null && loginCode.equals(user.getLoginCode()) && PwdUtils.validatePassword((String)user.getPwdQuestionAnswer(), (String)u.getPwdQuestionAnswer()) && PwdUtils.validatePassword((String)user.getPwdQuestionAnswer2(), (String)u.getPwdQuestionAnswer2()) && PwdUtils.validatePassword((String)user.getPwdQuestionAnswer3(), (String)u.getPwdQuestionAnswer3()))) {
            return this.renderResult("false", "\u60a8\u586b\u5199\u7684\u5bc6\u4fdd\u95ee\u9898\u7b54\u6848\u4e0d\u6b63\u786e\uff01");
        }
        try {
            this.userService.updatePassword(userCode, user.getPassword());
        }
        catch (ServiceException se) {
            return this.renderResult("false", se.getMessage());
        }
        return this.renderResult("true", "\u9a8c\u8bc1\u901a\u8fc7");
    }

    @RequestMapping(value={"registerUser"})
    public String registerUser(User user, HttpServletRequest request) {
        return "modules/sys/account/registerUser";
    }

    @PostMapping(value={"getRegValidCode"})
    @ResponseBody
    public String getRegValidCode(User user, String validCode, String validType, HttpServletRequest request) {
        if (!ValidCodeUtils.validate((HttpServletRequest)request, (String)validCode)) {
            return this.renderResult("false", "\u56fe\u7247\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u70b9\u51fb\u56fe\u7247\u5237\u65b0\uff01");
        }
        if (!"mobile".equals(validType) && !"email".equals(validType)) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\u3002");
        }
        if (!StringUtils.isNotBlank((CharSequence)user.getLoginCode()) || !StringUtils.isNotBlank((CharSequence)user.getUserName())) {
            return this.renderResult("false", "\u767b\u5f55\u8d26\u53f7\u548c\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("email".equals(validType) && !StringUtils.isNotBlank((CharSequence)user.getEmail())) {
            return this.renderResult("false", "\u7535\u5b50\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if ("mobile".equals(validType) && !StringUtils.isNotBlank((CharSequence)user.getMobile())) {
            return this.renderResult("false", "\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Date date = (Date)UserUtils.getCache((String)"regLastDate");
        if (date != null && (System.currentTimeMillis() - date.getTime()) / 1000L < 20L) {
            return this.renderResult("false", "\u60a8\u5f53\u524d\u64cd\u4f5c\u592a\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u4e00\u4f1a\u518d\u64cd\u4f5c\uff01");
        }
        UserUtils.putCache((String)"regLastDate", (Object)new Date());
        if (UserUtils.getByLoginCode((String)user.getLoginCode()) != null) {
            return this.renderResult("false", "\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728\uff01");
        }
        String code = StringUtils.getRandomNum((int)6);
        UserUtils.putCache((String)"regCorpCode", (Object)user.getCorpCode());
        UserUtils.putCache((String)"regCorpName", (Object)user.getCorpName());
        UserUtils.putCache((String)"regLoginCode", (Object)user.getLoginCode());
        String[] userTypes = StringUtils.split((String)Global.getConfig((String)"sys.account.registerUser.userTypes.userTypes", (String)"-1"), (String)",");
        if (!StringUtils.inString((String)user.getUserType(), (String[])userTypes)) {
            return this.renderResult("false", "\u975e\u6cd5\u7684\u7528\u6237\u7c7b\u578b\uff01");
        }
        UserUtils.putCache((String)"regUserType", (Object)user.getUserType());
        UserUtils.putCache((String)"regEmail", (Object)user.getEmail());
        UserUtils.putCache((String)"regMobile", (Object)user.getMobile());
        UserUtils.putCache((String)"regValidCode", (Object)code);
        if ("send_email".equals(validType)) {
            return this.sendEmailValidCode(user, code, "\u6ce8\u518c\u8d26\u53f7");
        }
        if ("send_mobile".equals(validType)) {
            return this.sendSmsValidCode(user, code, "\u6ce8\u518c\u8d26\u53f7");
        }
        return null;
    }

    @PostMapping(value={"saveRegByValidCode"})
    @ResponseBody
    public String saveRegByValidCode(User user, String regValidCode, HttpServletRequest request) {
        if (!"true".equals(Global.getConfig((String)"sys.account.registerUser"))) {
            return this.renderResult("false", "\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u5f00\u542f\u6ce8\u518c\u529f\u80fd\uff01");
        }
        String corpCode = (String)UserUtils.getCache((String)"regCorpCode");
        String corpName = (String)UserUtils.getCache((String)"regCorpName");
        String userType = (String)UserUtils.getCache((String)"regUserType");
        String loginCode = (String)UserUtils.getCache((String)"regLoginCode");
        String email = (String)UserUtils.getCache((String)"regEmail");
        String mobile = (String)UserUtils.getCache((String)"regMobile");
        String validCode = (String)UserUtils.getCache((String)"regValidCode");
        Date date = (Date)UserUtils.getCache((String)"regLastDate");
        if (loginCode == null || !loginCode.equals(user.getLoginCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\u3002");
        }
        boolean isTimeout = true;
        String validTime = Global.getConfig((String)"sys.account.validCodeTimeout", (String)"10");
        if ("0".equals(validTime) || date != null && (System.currentTimeMillis() - date.getTime()) / 1000L < 60L * Long.parseLong(validTime)) {
            isTimeout = false;
        }
        if (validCode == null || !validCode.equals(regValidCode) || isTimeout) {
            return this.renderResult("false", "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801\uff01");
        }
        if (!StringUtils.isNotBlank((CharSequence)user.getLoginCode()) || !StringUtils.isNotBlank((CharSequence)user.getUserName())) {
            return this.renderResult("false", "\u767b\u5f55\u8d26\u53f7\u548c\u7528\u6237\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        User u = new User();
        u.setIsNewRecord(true);
        if (StringUtils.isNotBlank((CharSequence)corpCode)) {
            u.setCorpCode(corpCode);
            u.setCorpName(corpName);
        }
        u.setLoginCode(loginCode);
        u.setUserName(user.getUserName());
        u.setPassword(user.getPassword());
        u.setEmail(email);
        u.setMobile(mobile);
        u.setUserType(userType);
        u.setMgrType("0");
        this.userService.save(u);
        UserUtils.removeCache((String)"regUserType");
        UserUtils.removeCache((String)"regLoginCode");
        UserUtils.removeCache((String)"regValidCode");
        UserUtils.removeCache((String)"regLastDate");
        return this.renderResult("true", "\u606d\u559c\u4f60\uff0c\u60a8\u7684\u8d26\u53f7 " + u.getLoginCode() + " \u6ce8\u518c\u6210\u529f\uff01");
    }

    private String sendEmailValidCode(User user, String code, String title) {
        String account = user.getEmail();
        try {
            title = user.getUserName() + "\uff08" + user.getLoginCode() + "\uff09" + title + "\u9a8c\u8bc1\u7801";
            String content = "\u5c0a\u656c\u7684\u7528\u6237\uff0c\u60a8\u597d!\n\n\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a" + code + "\uff08\u8bf7\u52ff\u900f\u9732\u7ed9\u5176\u4ed6\u4eba\uff09\n\n\u8bf7\u590d\u5236\u540e\uff0c\u586b\u5199\u5728\u4f60\u7684\u9a8c\u8bc1\u7801\u7a97\u53e3\u5b8c\u6210\u9a8c\u8bc1\u3002\n\n\u672c\u90ae\u4ef6\u7531\u7cfb\u7edf\u81ea\u52a8\u53d1\u51fa\uff0c\u8bf7\u52ff\u56de\u590d\u3002\n\n\u611f\u8c22\u60a8\u7684\u4f7f\u7528\uff01";
            EmailUtils.send((String)account, (String)title, (String)content);
        }
        catch (Exception e) {
            this.logger.error(title + "\u53d1\u9001\u90ae\u4ef6\u9519\u8bef\u3002", (Throwable)e);
            return this.renderResult("false", "\u7cfb\u7edf\u51fa\u73b0\u4e86\u70b9\u95ee\u9898\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        account = account.replaceAll("([\\w\\W]?)([\\w\\W]+)([\\w\\W])(@[\\w\\W]+)", "$1****$3$4");
        return this.renderResult("true", "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u5230\u201c" + account + "\u201d\u90ae\u7bb1\u8d26\u53f7\uff0c\u8bf7\u5c3d\u5feb\u67e5\u6536\uff01");
    }

    private String sendSmsValidCode(User user, String code, String title) {
        String account = user.getMobile();
        try {
            title = user.getUserName() + "\uff08" + user.getLoginCode() + "\uff09" + title + "\u9a8c\u8bc1\u7801";
            String content = "\u60a8\u597d\uff0c\u60a8\u7684\u9a8c\u8bc1\u7801\u662f\uff1a" + code + "\uff08\u8bf7\u52ff\u900f\u9732\u7ed9\u5176\u4ed6\u4eba\uff09\u611f\u8c22\u60a8\u7684\u4f7f\u7528\u3002";
            SmsUtils.send((String)content, (String)account);
        }
        catch (Exception e) {
            this.logger.error(title + "\u53d1\u9001\u77ed\u4fe1\u9519\u8bef\u3002", (Throwable)e);
            return this.renderResult("false", "\u7cfb\u7edf\u51fa\u73b0\u4e86\u70b9\u95ee\u9898\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        account = account.replaceAll("(\\d{3})(\\d+)(\\d{3})", "$1****$3");
        return this.renderResult("true", "\u9a8c\u8bc1\u7801\u5df2\u53d1\u9001\u5230\u201c" + account + "\u201d\u7684\u624b\u673a\u53f7\u7801\uff0c\u8bf7\u5c3d\u5feb\u67e5\u6536\uff01");
    }
}

