/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web.user;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mybatis.mapper.query.QueryType;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/corpAdmin"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class CorpAdminController
extends BaseController {
    @Autowired
    private UserService userService;

    @ModelAttribute
    public User get(String userCode, boolean isNewRecord) {
        return (User)this.userService.get(userCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:corpAdmin:view"})
    @RequestMapping(value={"list"})
    public String list(User user, Model model) {
        user.setCorpCode(null);
        user.setCorpName(null);
        return "modules/sys/user/corpAdminList";
    }

    @RequiresPermissions(value={"sys:corpAdmin:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<User> listData(User user, HttpServletRequest request, HttpServletResponse response) {
        user.setMgrType("1");
        user.getSqlMap().getWhere().disableAutoAddCorpCodeWhere().and("corp_code", QueryType.EQ, (Object)user.getCorpCode_()).and("corp_name", QueryType.LIKE, (Object)user.getCorpName_());
        user.setPage(new Page(request, response));
        Page page = this.userService.findPage(user);
        return page;
    }

    @RequiresPermissions(value={"sys:corpAdmin:view"})
    @RequestMapping(value={"form"})
    public String form(User user, String op, Model model) {
        if (user.getIsNewRecord() && "addCorp".equals(op)) {
            user.setCorpCode_("");
            user.setCorpName_("");
        }
        model.addAttribute("op", (Object)op);
        model.addAttribute("user", (Object)user);
        return "modules/sys/user/corpAdminForm";
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated User user, String oldLoginCode, String op) {
        if (!user.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", "\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u4fee\u6539\u6b64\u6570\u636e\uff01");
        }
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(user.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (StringUtils.isBlank((CharSequence)user.getCorpCode_())) {
            return this.renderResult("false", "\u79df\u6237\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"true".equals(this.userService.checkLoginCode(oldLoginCode, user.getLoginCode()))) {
            return this.renderResult("false", "\u4fdd\u5b58\u7528\u6237'" + user.getLoginCode() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (user.getIsNewRecord()) {
            user.setUserType("none");
        }
        user.setMgrType("1");
        if (user.getIsNewRecord()) {
            User where = new User();
            where.setCorpCode_(user.getCorpCode_());
            List list = this.userService.findCorpList(where);
            if (list.size() > 0) {
                if ("addCorp".equals(op)) {
                    return this.renderResult("false", "\u4fdd\u5b58\u7528\u6237\u5931\u8d25\uff0c\u79df\u6237\u4ee3\u7801\u5df2\u5b58\u5728");
                }
                if ("addAdmin".equals(op)) {
                    user.setCorpCode_(((User)list.get(0)).getCorpCode_());
                    user.setCorpName_(((User)list.get(0)).getCorpName_());
                } else {
                    return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u53c2\u6570\u9519\u8bef\u3002");
                }
            }
        }
        this.userService.save(user);
        if (user.getUserCode().equals(UserUtils.getUser().getUserCode())) {
            UserUtils.clearCache();
        }
        return this.renderResult("true", "\u4fdd\u5b58\u7ba1\u7406\u5458'" + user.getUserCode() + "'\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @ResponseBody
    @RequestMapping(value={"disable"})
    public String disable(User user) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (user.getCurrentUser().getUserCode().equals(user.getUserCode())) {
            return this.renderResult("false", "\u505c\u7528\u7528\u6237\u5931\u8d25, \u4e0d\u5141\u8bb8\u505c\u7528\u5f53\u524d\u7528\u6237");
        }
        user.setStatus("2");
        this.userService.updateStatus(user);
        return this.renderResult("true", "\u505c\u7528\u7528\u6237\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @ResponseBody
    @RequestMapping(value={"enable"})
    public String enable(User user) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        user.setStatus("0");
        this.userService.updateStatus(user);
        return this.renderResult("true", "\u542f\u7528\u7528\u6237\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @RequestMapping(value={"resetpwd"})
    @ResponseBody
    public String resetpwd(User user) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        this.userService.updatePassword(user.getUserCode(), null);
        return this.renderResult("true", "\u91cd\u7f6e\u7528\u6237\u5bc6\u7801\u6210\u529f");
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(User user) {
        if (User.isSuperAdmin((String)user.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (user.getCurrentUser().getUserCode().equals(user.getUserCode())) {
            return this.renderResult("false", "\u5220\u9664\u7528\u6237\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5f53\u524d\u7528\u6237");
        }
        if ("none".equals(user.getUserType())) {
            this.userService.delete(user);
            return this.renderResult("true", "\u5220\u9664\u7528\u6237'" + user.getUserName() + "'\u6210\u529f\uff01");
        }
        user.setMgrType("0");
        this.userService.updateMgrType(user);
        return this.renderResult("true", "\u53d6\u6d88\u7528\u6237'" + user.getUserName() + "'\u7ba1\u7406\u5458\u8eab\u4efd\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String pId, String isShowCode) {
        ArrayList mapList = ListUtils.newArrayList();
        User where = new User();
        List list = this.userService.findCorpList(where);
        for (int i = 0; i < list.size(); ++i) {
            User e = (User)list.get(i);
            HashMap map = MapUtils.newHashMap();
            map.put("id", e.getCorpCode_());
            map.put("pId", StringUtils.defaultIfBlank((CharSequence)pId, (CharSequence)"-1"));
            map.put("name", StringUtils.getTreeNodeName((String)isShowCode, (String)e.getCorpCode_(), (String)e.getCorpName_()));
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"sys:corpAdmin:edit"})
    @RequestMapping(value={"switch/{corpCode}"})
    @ResponseBody
    public String switchCorp(@PathVariable String corpCode) {
        if (UserUtils.getUser().isSuperAdmin()) {
            User where = new User();
            where.setCorpCode_(corpCode);
            List list = this.userService.findCorpList(where);
            if (list.size() > 0) {
                Session session = UserUtils.getSession();
                User user = (User)list.get(0);
                session.setAttribute((Object)"corpCode", (Object)user.getCorpCode_());
                session.setAttribute((Object)"corpName", (Object)user.getCorpName_());
                return this.renderResult("true", "\u79df\u6237\u5207\u6362\u6210\u529f\uff01");
            }
            return this.renderResult("true", "\u79df\u6237\u5207\u6362\u5931\u8d25\uff0c\u6ca1\u6709\u8fd9\u4e2a\u79df\u6237\uff01");
        }
        return this.renderResult("false", "\u79df\u6237\u5207\u6362\u5931\u8d25\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u64cd\u4f5c\uff01");
    }
}

