/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web.user;

import com.jeesite.common.codec.EncodeUtils;
import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.collect.MapUtils;
import com.jeesite.common.entity.DataEntity;
import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.mapper.JsonMapper;
import com.jeesite.common.utils.excel.ExcelExport;
import com.jeesite.common.utils.excel.annotation.ExcelField;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.EmpUser;
import com.jeesite.modules.sys.entity.Employee;
import com.jeesite.modules.sys.entity.Post;
import com.jeesite.modules.sys.entity.Role;
import com.jeesite.modules.sys.entity.User;
import com.jeesite.modules.sys.entity.UserDataScope;
import com.jeesite.modules.sys.service.EmpUserService;
import com.jeesite.modules.sys.service.EmployeeService;
import com.jeesite.modules.sys.service.PostService;
import com.jeesite.modules.sys.service.RoleService;
import com.jeesite.modules.sys.service.UserService;
import com.jeesite.modules.sys.utils.EmpUtils;
import com.jeesite.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"${adminPath}/sys/empUser"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class EmpUserController
extends BaseController {
    @Autowired
    private EmpUserService empUserService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private PostService postService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;

    @ModelAttribute
    public EmpUser get(String userCode, boolean isNewRecord) {
        return (EmpUser)this.empUserService.get(userCode, isNewRecord);
    }

    @RequiresPermissions(value={"sys:empUser:view"})
    @RequestMapping(value={"index"})
    public String index(EmpUser empUser, Model model) {
        return "modules/sys/user/empUserIndex";
    }

    @RequiresPermissions(value={"sys:empUser:view"})
    @RequestMapping(value={"list"})
    public String list(EmpUser empUser, Model model) {
        Post post = new Post();
        model.addAttribute("postList", (Object)this.postService.findList(post));
        return "modules/sys/user/empUserList";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<EmpUser> listData(EmpUser empUser, Boolean isAll, String ctrlPermi, HttpServletRequest request, HttpServletResponse response) {
        empUser.getEmployee().getOffice().setIsQueryChildren(true);
        empUser.getEmployee().getCompany().setIsQueryChildren(true);
        if (isAll == null || !isAll.booleanValue()) {
            this.empUserService.addDataScopeFilter(empUser, ctrlPermi);
        }
        empUser.setPage(new Page(request, response));
        Page<EmpUser> page = this.empUserService.findPage(empUser);
        return page;
    }

    @RequiresPermissions(value={"sys:empUser:view"})
    @RequestMapping(value={"form"})
    public String form(EmpUser empUser, String op, Model model) {
        Employee employee = empUser.getEmployee();
        if (StringUtils.isBlank((CharSequence)employee.getCompany().getCompanyCode())) {
            employee.setCompany(EmpUtils.getCompany());
        }
        if (StringUtils.isBlank((CharSequence)employee.getOffice().getOfficeCode())) {
            employee.setOffice(EmpUtils.getOffice());
        }
        Post post = new Post();
        model.addAttribute("postList", (Object)this.postService.findList(post));
        if (StringUtils.isNotBlank((CharSequence)employee.getEmpCode())) {
            employee.setEmployeePostList(this.employeeService.findEmployeePostList(employee));
        }
        if (StringUtils.inString((String)op, (String[])new String[]{"auth"})) {
            Role role = new Role();
            role.setUserCode(empUser.getUserCode());
            model.addAttribute("roleList", (Object)this.roleService.findListByUserCode(role));
        }
        model.addAttribute("op", (Object)op);
        model.addAttribute("empUser", (Object)empUser);
        return "modules/sys/user/empUserForm";
    }

    @RequiresPermissions(value={"sys:empUser:edit", "sys:empUser:authRole"}, logical=Logical.OR)
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated EmpUser empUser, String oldLoginCode, String op, HttpServletRequest request) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"true".equals(this.userService.checkLoginCode(oldLoginCode, empUser.getLoginCode()))) {
            return this.renderResult("false", EmpUserController.text((String)"\u4fdd\u5b58\u7528\u6237\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7''{0}''\u5df2\u5b58\u5728", (String[])new String[]{empUser.getLoginCode()}));
        }
        if (StringUtils.inString((String)op, (String[])new String[]{"add", "edit"}) && UserUtils.getSubject().isPermitted("sys:empUser:edit")) {
            this.empUserService.save(empUser);
        }
        if (StringUtils.inString((String)op, (String[])new String[]{"add", "auth"}) && UserUtils.getSubject().isPermitted("sys:empUser:authRole")) {
            this.userService.saveAuth((User)empUser);
        }
        return this.renderResult("true", EmpUserController.text((String)"\u4fdd\u5b58\u7528\u6237''{0}''\u6210\u529f", (String[])new String[]{empUser.getUserName()}));
    }

    @RequiresPermissions(value={"sys:empUser:view"})
    @RequestMapping(value={"exportData"})
    public void exportData(EmpUser empUser, Boolean isAll, String ctrlPermi, HttpServletResponse response) {
        empUser.getEmployee().getOffice().setIsQueryChildren(true);
        empUser.getEmployee().getCompany().setIsQueryChildren(true);
        if (isAll == null || !isAll.booleanValue()) {
            this.empUserService.addDataScopeFilter(empUser, ctrlPermi);
        }
        List list = this.empUserService.findList((DataEntity)empUser);
        String fileName = "\u7528\u6237\u6570\u636e" + DateUtils.getDate((String)"yyyyMMddHHmmss") + ".xlsx";
        try (ExcelExport ee = new ExcelExport("\u7528\u6237\u6570\u636e", EmpUser.class);){
            ee.setDataList(list).write(response, fileName);
        }
    }

    @RequiresPermissions(value={"sys:empUser:view"})
    @RequestMapping(value={"importTemplate"})
    public void importTemplate(HttpServletResponse response) {
        EmpUser empUser = new EmpUser();
        User user = UserUtils.getUser();
        if ("employee".equals(user.getUserType())) {
            empUser = (EmpUser)this.empUserService.get(user.getUserCode());
        } else {
            BeanUtils.copyProperties((Object)user, (Object)((Object)empUser));
        }
        ArrayList list = ListUtils.newArrayList((Object[])new EmpUser[]{empUser});
        String fileName = "\u7528\u6237\u6570\u636e\u6a21\u677f.xlsx";
        try (ExcelExport ee = new ExcelExport("\u7528\u6237\u6570\u636e", EmpUser.class, ExcelField.Type.IMPORT, new String[0]);){
            ee.setDataList((List)list).write(response, fileName);
        }
    }

    @ResponseBody
    @RequiresPermissions(value={"sys:empUser:edit"})
    @PostMapping(value={"importData"})
    public String importData(MultipartFile file, String updateSupport) {
        try {
            boolean isUpdateSupport = "1".equals(updateSupport);
            String message = this.empUserService.importData(file, isUpdateSupport);
            return this.renderResult("true", "posfull:" + message);
        }
        catch (Exception ex) {
            return this.renderResult("false", "posfull:" + ex.getMessage());
        }
    }

    @RequiresPermissions(value={"sys:empUser:updateStatus"})
    @ResponseBody
    @RequestMapping(value={"disable"})
    public String disable(EmpUser empUser) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (empUser.getCurrentUser().getUserCode().equals(empUser.getUserCode())) {
            return this.renderResult("false", EmpUserController.text((String)"\u505c\u7528\u7528\u6237\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u505c\u7528\u5f53\u524d\u7528\u6237", (String[])new String[0]));
        }
        empUser.setStatus("2");
        this.userService.updateStatus((User)empUser);
        return this.renderResult("true", EmpUserController.text((String)"\u505c\u7528\u7528\u6237''{0}''\u6210\u529f", (String[])new String[]{empUser.getUserName()}));
    }

    @RequiresPermissions(value={"sys:empUser:updateStatus"})
    @ResponseBody
    @RequestMapping(value={"enable"})
    public String enable(EmpUser empUser) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        empUser.setStatus("0");
        this.userService.updateStatus((User)empUser);
        return this.renderResult("true", EmpUserController.text((String)"\u542f\u7528\u7528\u6237''{0}''\u6210\u529f", (String[])new String[]{empUser.getUserName()}));
    }

    @RequiresPermissions(value={"sys:empUser:resetpwd"})
    @RequestMapping(value={"resetpwd"})
    @ResponseBody
    public String resetpwd(EmpUser empUser) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        this.userService.updatePassword(empUser.getUserCode(), null);
        return this.renderResult("true", EmpUserController.text((String)"\u91cd\u7f6e\u7528\u6237''{0}''\u5bc6\u7801\u6210\u529f", (String[])new String[]{empUser.getUserName()}));
    }

    @RequiresPermissions(value={"sys:empUser:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(EmpUser empUser) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (empUser.getCurrentUser().getUserCode().equals(empUser.getUserCode())) {
            return this.renderResult("false", EmpUserController.text((String)"\u5220\u9664\u7528\u6237\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u5f53\u524d\u7528\u6237", (String[])new String[0]));
        }
        this.empUserService.delete(empUser);
        return this.renderResult("true", EmpUserController.text((String)"\u5220\u9664\u7528\u6237'{0}'\u6210\u529f", (String[])new String[]{empUser.getUserName()}));
    }

    @RequiresPermissions(value={"sys:empUser:authDataScope"})
    @RequestMapping(value={"formAuthDataScope"})
    public String formAuthDataScope(EmpUser empUser, Model model, HttpServletRequest request) {
        UserDataScope userDataScope = new UserDataScope();
        userDataScope.setUserCode(empUser.getUserCode());
        userDataScope.setCtrlPermi("1");
        List userDataScopeList = this.userService.findDataScopeList(userDataScope);
        model.addAttribute("userDataScopeList", (Object)userDataScopeList);
        model.addAttribute("empUser", (Object)empUser);
        return "modules/sys/user/empUserFormAuthDataScope";
    }

    @RequiresPermissions(value={"sys:empUser:authDataScope"})
    @RequestMapping(value={"saveAuthDataScope"})
    @ResponseBody
    public String saveAuthDataScope(EmpUser empUser, HttpServletRequest request) {
        if (User.isSuperAdmin((String)empUser.getUserCode())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        if (!"employee".equals(empUser.getUserType())) {
            return this.renderResult("false", "\u975e\u6cd5\u64cd\u4f5c\uff0c\u4e0d\u80fd\u591f\u64cd\u4f5c\u6b64\u7528\u6237\uff01");
        }
        empUser.setMgrType("0");
        this.userService.saveAuthDataScope((User)empUser);
        return this.renderResult("true", EmpUserController.text((String)"\u7528\u6237\u5206\u914d\u6570\u636e\u6743\u9650\u6210\u529f", (String[])new String[0]));
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeData"})
    @ResponseBody
    public List<Map<String, Object>> treeData(String idPrefix, String pId, String officeCode, String companyCode, String postCode, String roleCode, Boolean isAll, String isShowCode, String ctrlPermi) {
        ArrayList mapList = ListUtils.newArrayList();
        EmpUser empUser = new EmpUser();
        Employee employee = empUser.getEmployee();
        employee.getOffice().setOfficeCode(officeCode);
        employee.getOffice().setIsQueryChildren(false);
        employee.getCompany().setCompanyCode(companyCode);
        employee.getCompany().setIsQueryChildren(false);
        employee.setPostCode(postCode);
        empUser.setRoleCode(roleCode);
        empUser.setStatus("0");
        empUser.setUserType("employee");
        if (isAll == null || !isAll.booleanValue()) {
            this.empUserService.addDataScopeFilter(empUser, ctrlPermi);
        }
        List list = this.empUserService.findList((DataEntity)empUser);
        for (int i = 0; i < list.size(); ++i) {
            EmpUser e = (EmpUser)((Object)list.get(i));
            HashMap map = MapUtils.newHashMap();
            map.put("id", (String)StringUtils.defaultIfBlank((CharSequence)idPrefix, (CharSequence)"u_") + e.getId());
            map.put("pId", StringUtils.defaultIfBlank((CharSequence)pId, (CharSequence)"0"));
            map.put("name", StringUtils.getTreeNodeName((String)isShowCode, (String)e.getLoginCode(), (String)e.getUserName()));
            mapList.add(map);
        }
        return mapList;
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"empUserSelect"})
    public String empUserSelect(EmpUser empUser, String selectData, Model model) {
        String selectDataJson = EncodeUtils.decodeUrl((String)selectData);
        if (JsonMapper.fromJson((String)selectDataJson, Map.class) != null) {
            model.addAttribute("selectData", (Object)selectDataJson);
        }
        model.addAttribute("empUser", (Object)empUser);
        return "modules/sys/user/empUserSelect";
    }
}

