/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mqtt.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.mqtt.config.xml.MqttParserUtils;
import org.springframework.integration.mqtt.outbound.MqttPahoMessageHandler;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class MqttOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MqttPahoMessageHandler.class);
        MqttParserUtils.parseCommon(element, builder, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-topic");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"topic-expression", (String)"topicExpressionString");
        if (StringUtils.hasText((String)element.getAttribute("converter")) && (StringUtils.hasText((String)element.getAttribute("default-qos")) || StringUtils.hasText((String)element.getAttribute("default-retained")))) {
            parserContext.getReaderContext().error("If a 'converter' is provided, you cannot provide 'default-qos' or 'default-retained'", (Object)element);
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-qos");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"qos-expression", (String)"qosExpressionString");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"default-retained");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"retained-expression", (String)"retainedExpressionString");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"async");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"async-events");
        return builder.getBeanDefinition();
    }
}

