/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.job.web;

import com.jeesite.common.collect.ListUtils;
import com.jeesite.common.lang.DateUtils;
import com.jeesite.common.lang.ObjectUtils;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.common.web.u.i;
import com.jeesite.modules.job.entity.JobEntity;
import com.jeesite.modules.job.service.JobService;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.validation.ValidationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.Swap;
import org.hyperic.sigar.pager.PageList;
import org.quartz.CronExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/job"})
@ConditionalOnProperty(name={"job.enabled", "web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class JobController
extends BaseController {
    @Autowired
    private JobService jobService;

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(JobEntity job) {
        if (!ObjectUtils.toBoolean(i.char().get(Swap.char("Y\u0004u\u0005]"))).booleanValue()) {
            return this.renderResult("false", PageList.char("\u5f24\u524e\u723f\u672f\u675d\u5f03\u6549\u6b67\u52e8\u80fe\uff76"));
        }
        this.jobService.delete(job);
        return this.renderResult("true", Swap.char("\u521f\u960e\u622f\u52f5\uff3e"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"list"})
    public String list(JobEntity job, Model model) {
        void a2;
        Boolean bl = this.jobService.isRunning();
        model.addAttribute(PageList.char("\u001ep%v\u0019m\u001em\u0010"), (Object)a2);
        return Swap.char("R\u0005[\u001fS\u000fLEU\u0005]EU\u0005]&V\u0019K");
    }

    @RequiresPermissions(value={"sys:job:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public List<JobEntity> listData(JobEntity job, String orderBy) {
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = PageList.char("\u001dl\u0015M\u0016n\u0012");
        }
        List a2 = this.jobService.findList(job);
        a2 = ListUtils.listOrderBy(a2, (String)orderBy);
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"startAll"})
    @ResponseBody
    public String startAll() {
        if (!ObjectUtils.toBoolean(i.char().get(PageList.char("\u0011m=l\u0015"))).booleanValue()) {
            return this.renderResult("false", Swap.char("\u5f6c\u5227\u7277\u6746\u6715\u5f6a\u6501\u6b0e\u52a0\u8097\uff3e"));
        }
        if (!this.jobService.startAll()) {
            return this.renderResult("false", PageList.char("\u542c\u52df\u5b99\u6581\u566b\u5946\u8d26\uff76"));
        }
        return this.renderResult("true", Swap.char("\u5445\u5297\u5bf0\u65c9\u5602\u622f\u52f5\uff3e"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"runOnce"})
    @ResponseBody
    public String runOnce(JobEntity job) {
        if (!ObjectUtils.toBoolean(i.char().get(PageList.char("\u0011m=l\u0015"))).booleanValue()) {
            return this.renderResult("false", Swap.char("\u5f6c\u5227\u7277\u6746\u6715\u5f6a\u6501\u6b0e\u52a0\u8097\uff3e"));
        }
        this.jobService.runOnce(job);
        return this.renderResult("true", PageList.char("\u8fa7\u884f\u4e77\u6b22\u6267\u529c\uff76"));
    }

    @ModelAttribute(value="job")
    public JobEntity get(String jobName, String jobGroup, boolean isNewRecord) {
        JobEntity a2 = null;
        CharSequence[] charSequenceArray = new CharSequence[2];
        charSequenceArray[0] = jobName;
        charSequenceArray[1] = jobGroup;
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            a2 = this.jobService.get(new JobEntity(jobName, jobGroup));
            if (isNewRecord && a2 != null) {
                throw new ValidationException(Swap.char("\u5432\u799a\u53f5\u7eae\u5432\u5d98\u7ef0\u5b32\u5717"));
            }
        }
        if (a2 == null) {
            a2 = new JobEntity();
        }
        return a2;
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"pause"})
    @ResponseBody
    public String pause(JobEntity job) {
        if (!ObjectUtils.toBoolean(i.char().get(PageList.char("\u0011m=l\u0015"))).booleanValue()) {
            return this.renderResult("false", Swap.char("\u5f6c\u5227\u7277\u6746\u6715\u5f6a\u6501\u6b0e\u52a0\u8097\uff3e"));
        }
        this.jobService.pause(job);
        return this.renderResult("true", PageList.char("\u66f5\u505f\u8fa7\u884f\u6267\u529c\uff76"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"stopAll"})
    @ResponseBody
    public String stopAll() {
        if (!ObjectUtils.toBoolean(i.char().get(PageList.char("\u0011m=l\u0015"))).booleanValue()) {
            return this.renderResult("false", Swap.char("\u5f6c\u5227\u7277\u6746\u6715\u5f6a\u6501\u6b0e\u52a0\u8097\uff3e"));
        }
        if (!this.jobService.stopAll()) {
            return this.renderResult("false", PageList.char("\u505f\u6b15\u5b99\u6581\u566b\u5946\u8d26\uff76"));
        }
        return this.renderResult("true", Swap.char("\u5036\u6b5d\u5bf0\u65c9\u5602\u622f\u52f5\uff3e"));
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"form"})
    public String form(@ModelAttribute(value="job") JobEntity job, Model model) {
        if (job.getMisfireInstruction() == null) {
            job.setMisfireInstruction(2);
        }
        if (StringUtils.isBlank((CharSequence)job.getConcurrent())) {
            job.setConcurrent("0");
        }
        model.addAttribute("job", (Object)job);
        return Swap.char("R\u0005[\u001fS\u000fLEU\u0005]EU\u0005],P\u0018R");
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated JobEntity job) {
        if (!ObjectUtils.toBoolean(i.char().get(PageList.char("\u0011m=l\u0015"))).booleanValue()) {
            return this.renderResult("false", Swap.char("\u5f6c\u5227\u7277\u6746\u6715\u5f6a\u6501\u6b0e\u52a0\u8097\uff3e"));
        }
        this.jobService.save(job);
        return this.renderResult("true", PageList.char("\u4faa\u5b5b\u6267\u529c\uff76"));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"checkCron"})
    @ResponseBody
    public String checkCron(String cron, @RequestParam(defaultValue="10") Integer num) {
        StringBuilder a2 = new StringBuilder();
        try {
            void a3;
            CronExpression a4 = new CronExpression(cron);
            if (num <= 0) {
                a2.append(PageList.char("@\u0005l\u0019\u886b\u8fc9\u5f0c\u6b14\u786d\u3075"));
                return this.renderResult("true", a2.toString());
            }
            a2.append(Swap.char("\u0003\u001a\u0001\u676a\u8fee") + num + PageList.char("\u6b22\u8fa7\u884f\u6581\u95f7\uff6d?XsI"));
            Date a5 = new Date();
            boolean bl = false;
            void v0 = a3;
            while (v0 <= num) {
                if ((a5 = a4.getTimeAfter(a5)) == null) {
                    return this.renderResult("true", a2.toString());
                }
                a2.append(new StringBuilder().insert(0, DateUtils.formatDateTime((Date)a5)).append(Swap.char("\u0003E]\u0018\u0001")).toString());
                v0 = ++a3;
            }
            return this.renderResult("true", a2.toString());
        }
        catch (ParseException a6) {
            return this.renderResult("false", new StringBuilder().insert(0, Swap.char(")M\u0005Q\u8802\u8f81\u5f65\u9526\u8b85\uff25")).append(a6.getMessage()).toString());
        }
    }

    @RequiresPermissions(value={"sys:job:edit"})
    @RequestMapping(value={"resume"})
    @ResponseBody
    public String resume(JobEntity job) {
        if (!ObjectUtils.toBoolean(i.char().get(Swap.char("Y\u0004u\u0005]"))).booleanValue()) {
            return this.renderResult("false", PageList.char("\u5f24\u524e\u723f\u672f\u675d\u5f03\u6549\u6b67\u52e8\u80fe\uff76"));
        }
        this.jobService.resume(job);
        return this.renderResult("true", Swap.char("\u605d\u5967\u8fef\u8826\u622f\u52f5\uff3e"));
    }
}

