/*
 * Decompiled with CFR 0.152.
 */
package com.jeesite.modules.sys.web;

import com.jeesite.common.entity.Page;
import com.jeesite.common.lang.StringUtils;
import com.jeesite.common.web.BaseController;
import com.jeesite.modules.sys.entity.Config;
import com.jeesite.modules.sys.service.ConfigService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.hyperic.sigar.DirUsage;
import org.hyperic.sigar.win32.EventLogRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${adminPath}/sys/config"})
@ConditionalOnProperty(name={"web.core.enabled"}, havingValue="true", matchIfMissing=true)
public class ConfigController
extends BaseController {
    @Autowired
    private ConfigService configService;

    @ModelAttribute
    public Config get(String id, boolean isNewRecord) {
        return (Config)this.configService.get(id, isNewRecord);
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @PostMapping(value={"save"})
    @ResponseBody
    public String save(@Validated Config config, HttpServletRequest request) {
        Config a2 = (Config)super.getWebDataBinderSource(request);
        if (a2 != null && "1".equals(a2.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", DirUsage.char("\u8da4\u6731\u64e3\u4f2e\uff22\u5398\u6727\u8df7\u7e89\u7bd3\u7428\u542a\u6263\u808f\u4fc0\u654b\u7cd5\u7ead\u655e\u631c\uff2f"));
        }
        if (!config.getCurrentUser().isSuperAdmin()) {
            Config config2 = config;
            config2.setConfigName(a2.getConfigName());
            config2.setConfigKey(a2.getConfigKey());
        }
        this.configService.save(config);
        return this.renderResult("true", EventLogRecord.char("\u4fef\u5b12\u53f0\u653a\u6222\u52d5\uff33"));
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"delete"})
    @ResponseBody
    public String delete(Config config, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(DirUsage.char("G\u0001}\u000b]")))) {
            return this.renderResult("false", EventLogRecord.char("\u8db8\u6709\u64ff\u4f16\uff3e#A\u0019K9\u976c\u6c9f\u53f0\u653a\uff33"));
        }
        Config a2 = (Config)super.getWebDataBinderSource(request);
        if (a2 != null && "1".equals(a2.getIsSys()) && !config.getCurrentUser().isSuperAdmin()) {
            return this.renderResult("false", DirUsage.char("\u8da4\u6731\u64e3\u4f2e\uff22\u5398\u6727\u8df7\u7e89\u7bd3\u7428\u542a\u6263\u808f\u4fc0\u654b\u7cd5\u7ead\u655e\u631c\uff2f"));
        }
        this.configService.delete(config);
        return this.renderResult("true", EventLogRecord.char("\u5212\u962e\u53f0\u653a\u6222\u52d5\uff33"));
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"listData"})
    @ResponseBody
    public Page<Config> listData(Config config, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        void response;
        void request;
        void config2;
        config2.setPage(new Page((HttpServletRequest)request, (HttpServletResponse)response));
        return this.configService.findPage((Config)config2);
    }

    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"list"})
    public String list(Config config, Model model) {
        return EventLogRecord.char("'].G&W9\u001d9K9\u001d)]$T#U\u0006[9F");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresPermissions(value={"sys:config:view"})
    @RequestMapping(value={"form"})
    public String form(Config config, Model model) {
        void config2;
        void model2;
        model2.addAttribute(DirUsage.char("\u0011A\u001cH\u001bI"), (Object)config2);
        return EventLogRecord.char("'].G&W9\u001d9K9\u001d)]$T#U\f]8_");
    }

    @RequiresPermissions(value={"sys:config:edit"})
    @RequestMapping(value={"checkConfigKey"})
    @ResponseBody
    public String checkConfigKey(String oldConfigKey, String configKey) {
        Config a2 = new Config();
        String string = configKey;
        a2.setConfigKey(string);
        if (string != null && configKey.equals(oldConfigKey)) {
            return "true";
        }
        if (configKey != null && this.configService.findCount(a2) == 0L) {
            return "true";
        }
        return "false";
    }
}

