/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.hyperic.sigar.DirStat;
import org.hyperic.sigar.FileAttrs;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;
import org.hyperic.sigar.i;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileInfo
extends FileAttrs
implements Serializable {
    public static final int MODE_WWRITE = 2;
    public static final int MODE_GREAD = 64;
    private FileInfo oldInfo;
    public static final int TYPE_SOCK = 7;
    private DirStat stat;
    public static final int TYPE_PIPE = 5;
    public static final int MODE_WEXECUTE = 1;
    public static final int TYPE_LNK = 6;
    public static final int TYPE_DIR = 2;
    String name;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(ProcExe.char("O\u0001Olf(\"\u0004Jvo!"));
    private transient Sigar sigar;
    private boolean lstat;
    public static final int MODE_UWRITE = 512;
    public static final int TYPE_UNKFILE = 8;
    public static final int MODE_GWRITE = 32;
    private boolean dirStatEnabled;
    private static final long serialVersionUID = 607239L;
    public static final int TYPE_CHR = 3;
    public static final int TYPE_BLK = 4;
    public static final int MODE_GEXECUTE = 16;
    public static final int TYPE_REG = 1;
    public static final int MODE_WREAD = 4;
    public static final int TYPE_NOFILE = 0;
    public static final int MODE_UREAD = 1024;
    public static final int MODE_UEXECUTE = 256;

    private /* synthetic */ StringBuffer char(ArrayList a2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (a2.size() == 0) {
            return stringBuffer;
        }
        int n2 = a2.size();
        int n3 = n = 0;
        while (n3 < n2) {
            Object e2 = a2.get(n);
            stringBuffer.append('{').append(e2).append('}');
            n3 = ++n;
        }
        return stringBuffer;
    }

    private static native /* synthetic */ String getPermissionsString(long var0);

    private static native /* synthetic */ String getTypeString(int var0);

    /*
     * Enabled aggressive block sorting
     */
    public char getTypeChar() {
        switch (this.type) {
            case 2: {
                return 'd';
            }
            case 3: {
                return 'c';
            }
            case 4: {
                return 'b';
            }
            case 5: {
                return 'p';
            }
            case 6: {
                return 'l';
            }
            case 7: {
                return 's';
            }
        }
        return '-';
    }

    public String diff(FileInfo info) {
        FileInfo fileInfo;
        ArrayList<i> a2 = new ArrayList<i>();
        if (this.getMtime() != info.getMtime()) {
            fileInfo = this;
            FileInfo fileInfo2 = this;
            a2.add(new i(fileInfo2, ProcExe.char("\u0001v%o)"), FileInfo.DATE_FORMAT.format(new Date(info.getMtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo2.getMtime()))));
        } else if (this.getCtime() != info.getCtime()) {
            fileInfo = this;
            FileInfo fileInfo3 = this;
            a2.add(new i(fileInfo3, ProcFd.char("P?z&v"), FileInfo.DATE_FORMAT.format(new Date(info.getCtime())), FileInfo.DATE_FORMAT.format(new Date(fileInfo3.getCtime()))));
        } else {
            return "";
        }
        if (fileInfo.getPermissions() != info.getPermissions()) {
            FileInfo fileInfo4 = this;
            a2.add(new i(fileInfo4, ProcExe.char("\u001cg>o?"), info.getPermissionsString(), fileInfo4.getPermissionsString()));
        }
        if (this.getType() != info.getType()) {
            FileInfo fileInfo5 = this;
            a2.add(new i(fileInfo5, "Type", info.getTypeString(), fileInfo5.getTypeString()));
        }
        if (this.getUid() != info.getUid()) {
            a2.add(new i(this, ProcFd.char("F\"w"), info.getUid(), this.getUid()));
        }
        if (this.getGid() != info.getGid()) {
            a2.add(new i(this, ProcExe.char("\u000bk("), info.getGid(), this.getGid()));
        }
        if (this.getSize() != info.getSize()) {
            a2.add(new i(this, ProcFd.char("\u0018z1v"), info.getSize(), this.getSize()));
        }
        if (!OperatingSystem.IS_WIN32) {
            if (this.getInode() != info.getInode()) {
                a2.add(new i(this, ProcExe.char("\u0005l#f)"), info.getInode(), this.getInode()));
            }
            if (this.getDevice() != info.getDevice()) {
                a2.add(new i(this, ProcFd.char("\u000fv=z(v"), info.getDevice(), this.getDevice()));
            }
            if (this.getNlink() != info.getNlink()) {
                a2.add(new i(this, ProcExe.char("\u0002n%l'"), info.getNlink(), this.getNlink()));
            }
        }
        FileInfo fileInfo6 = this;
        StringBuffer a3 = fileInfo6.char(a2);
        if (fileInfo6.dirStatEnabled) {
            a3.append(this.diff(info.stat));
        }
        return a3.toString();
    }

    public boolean changed() throws SigarException, SigarFileNotFoundException {
        return this.modified() || this.ctime != this.oldInfo.ctime;
    }

    static FileInfo char(Sigar a2, String a3) throws SigarException {
        return FileInfo.char(a2, a3, false);
    }

    public String diff(DirStat stat) {
        DirStat a2 = this.stat;
        ArrayList<i> a3 = new ArrayList<i>();
        if (a2.files != stat.files) {
            a3.add(new i(this, ProcFd.char("U\"\u007f.`"), stat.getFiles(), a2.getFiles()));
        }
        if (a2.subdirs != stat.subdirs) {
            a3.add(new i(this, ProcExe.char("\u001fw.f%p?"), stat.getSubdirs(), a2.getSubdirs()));
        }
        if (a2.symlinks != stat.symlinks) {
            a3.add(new i(this, ProcFd.char("\u0018j&\u007f\"} `"), stat.getSymlinks(), a2.getSymlinks()));
        }
        if (a2.chrdevs != stat.chrdevs) {
            a3.add(new i(this, ProcExe.char("\u000fj>f)t?"), stat.getChrdevs(), a2.getChrdevs()));
        }
        if (a2.blkdevs != stat.blkdevs) {
            a3.add(new i(this, ProcFd.char("Q'x/v=`"), stat.getBlkdevs(), a2.getBlkdevs()));
        }
        if (a2.sockets != stat.sockets) {
            a3.add(new i(this, ProcExe.char("\u001fm/i)v?"), stat.getSockets(), a2.getSockets()));
        }
        if (a2.total != stat.total) {
            a3.add(new i(this, ProcFd.char("G$g*\u007f"), stat.getTotal(), a2.getTotal()));
        }
        return this.char(a3).toString();
    }

    public FileInfo() {
        FileInfo fileInfo = this;
        this.dirStatEnabled = false;
        fileInfo.stat = null;
        fileInfo.oldInfo = null;
    }

    public FileInfo getPreviousInfo() {
        return this.oldInfo;
    }

    public int getMode() {
        return FileInfo.getMode(this.permissions);
    }

    native void gatherLink(Sigar var1, String var2) throws SigarException;

    static FileInfo const(Sigar a2, String a3) throws SigarException {
        return FileInfo.char(a2, a3, true);
    }

    public boolean equals(Object o) {
        return o.equals(this.name);
    }

    public void stat() throws SigarException, SigarFileNotFoundException {
        FileInfo fileInfo;
        FileInfo fileInfo2 = this;
        long a2 = fileInfo2.mtime;
        if (fileInfo2.lstat) {
            FileInfo fileInfo3 = this;
            FileInfo fileInfo4 = this;
            fileInfo = fileInfo4;
            fileInfo3.gatherLink(fileInfo3.sigar, fileInfo4.name);
        } else {
            FileInfo fileInfo5 = this;
            fileInfo = fileInfo5;
            FileInfo fileInfo6 = this;
            fileInfo6.gather(fileInfo5.sigar, fileInfo6.name);
        }
        if (fileInfo.dirStatEnabled && a2 != this.mtime) {
            FileInfo fileInfo7 = this;
            fileInfo7.stat.gather(fileInfo7.sigar, this.name);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getTypeString() {
        return FileInfo.getTypeString(this.type);
    }

    private static /* synthetic */ FileInfo char(Sigar a2, String a3, boolean a42) throws SigarException {
        FileInfo fileInfo;
        block3: {
            fileInfo = new FileInfo();
            try {
                if (!a42) break block3;
                fileInfo.gather(a2, a3);
                fileInfo.lstat = false;
            }
            catch (SigarException a42) {
                SigarException sigarException = a42;
                sigarException.char(a3 + ProcFd.char("q3") + a42.getMessage());
                throw sigarException;
            }
        }
        fileInfo.gatherLink(a2, a3);
        fileInfo.lstat = true;
        FileInfo fileInfo2 = fileInfo;
        fileInfo2.sigar = a2;
        fileInfo2.name = a3;
        return fileInfo;
    }

    private static native /* synthetic */ int getMode(long var0);

    public void enableDirStat(boolean value) {
        this.dirStatEnabled = value;
        if (this.dirStatEnabled) {
            block5: {
                if (this.type != 2) {
                    throw new IllegalArgumentException(new StringBuilder().insert(0, this.name).append(ProcExe.char("lk?\"\"m8\"-\"(k>g/v#p5")).toString());
                }
                if (this.stat != null) break block5;
                this.stat = this.sigar.getDirStat(this.name);
                return;
            }
            try {
                FileInfo fileInfo = this;
                fileInfo.stat.gather(fileInfo.sigar, this.name);
                return;
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean modified() throws SigarException, SigarFileNotFoundException {
        if (this.oldInfo == null) {
            this.oldInfo = new FileInfo();
            if (this.dirStatEnabled) {
                this.oldInfo.stat = new DirStat();
            }
        }
        FileInfo fileInfo = this;
        fileInfo.char(fileInfo.oldInfo);
        if (fileInfo.dirStatEnabled) {
            FileInfo fileInfo2 = this;
            fileInfo2.stat.char(fileInfo2.oldInfo.stat);
        }
        FileInfo fileInfo3 = this;
        fileInfo3.stat();
        return fileInfo3.mtime != this.oldInfo.mtime;
    }

    public String getPermissionsString() {
        return FileInfo.getPermissionsString(this.permissions);
    }

    public String diff() {
        if (this.oldInfo == null) {
            return "";
        }
        FileInfo fileInfo = this;
        return fileInfo.diff(fileInfo.oldInfo);
    }
}

