/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileInfo;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarFileNotFoundException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FileWatcher {
    private Sigar sigar;
    private long interval;
    private long lastTime;
    private Set files;

    public void remove(String file) {
        FileInfo a2 = new FileInfo();
        a2.name = file;
        this.files.remove(a2);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() {
        if (this.interval != 0L) {
            long a2 = System.currentTimeMillis();
            long a3 = a2 - this.lastTime;
            if (a3 < this.interval) {
                return;
            }
            this.lastTime = a2;
        }
        Set set = this.files;
        synchronized (set) {
            Iterator a4 = this.files.iterator();
            while (a4.hasNext()) {
                FileInfo a5 = (FileInfo)a4.next();
                try {
                    if (!this.changed(a5)) continue;
                    this.onChange(a5);
                }
                catch (SigarFileNotFoundException a6) {
                    this.onNotFound(a5);
                }
                catch (SigarException a7) {
                    this.onException(a5, a7);
                    continue;
                }
                break;
            }
            return;
        }
    }

    public void onNotFound(FileInfo info) {
    }

    public void add(String[] files) throws SigarException {
        int a2;
        int n = a2 = 0;
        while (n < files.length) {
            this.add(files[a2++]);
            n = a2;
        }
    }

    public Set getFiles() {
        return this.files;
    }

    public long getInterval() {
        return this.interval;
    }

    protected boolean changed(FileInfo info) throws SigarException, SigarFileNotFoundException {
        return info.changed();
    }

    public void onException(FileInfo info, SigarException e2) {
    }

    public void remove(File file) {
        this.remove(file.getAbsolutePath());
    }

    public static String char(Object s) {
        s = (String)s;
        int n = ((String)s).length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 1 << 3;
        int n4 = n2;
        int n5 = (3 ^ 5) << 3 ^ 2;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(((String)s).charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(((String)s).charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    public FileWatcher(Sigar sigar) {
        FileWatcher fileWatcher = this;
        this.interval = 0L;
        fileWatcher.lastTime = 0L;
        FileWatcher fileWatcher2 = this;
        fileWatcher.files = Collections.synchronizedSet(new HashSet());
        fileWatcher.sigar = sigar;
    }

    public void clear() {
        this.files.clear();
    }

    public abstract void onChange(FileInfo var1);

    public FileInfo add(String file) throws SigarException {
        FileWatcher fileWatcher = this;
        FileInfo a2 = fileWatcher.sigar.getFileInfo(file);
        fileWatcher.files.add(a2);
        return a2;
    }

    public void add(File[] files) throws SigarException {
        int a2;
        int n = a2 = 0;
        while (n < files.length) {
            this.add(files[a2++]);
            n = a2;
        }
    }

    public FileInfo add(File file) throws SigarException {
        return this.add(file.getAbsolutePath());
    }
}

