/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;
import org.hyperic.sigar.cmd.Tail;
import org.hyperic.sigar.pager.PageList;

public class FileWatcherThread
implements Runnable {
    private boolean shouldDie;
    private Thread thread;
    private static FileWatcherThread instance = null;
    private Set watchers;
    public static final int DEFAULT_INTERVAL = 300000;
    private long interval;

    @Override
    public void run() {
        FileWatcherThread fileWatcherThread = this;
        while (!fileWatcherThread.shouldDie) {
            this.check();
            try {
                Thread.sleep(this.interval);
                fileWatcherThread = this;
            }
            catch (InterruptedException interruptedException) {
                fileWatcherThread = this;
            }
        }
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.die();
        fileWatcherThread.thread.interrupt();
        this.thread = null;
    }

    public FileWatcherThread() {
        FileWatcherThread fileWatcherThread = this;
        fileWatcherThread.thread = null;
        fileWatcherThread.shouldDie = false;
        this.interval = 300000L;
        FileWatcherThread fileWatcherThread2 = this;
        fileWatcherThread2.watchers = Collections.synchronizedSet(new HashSet());
    }

    public long getInterval() {
        return this.interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void check() {
        Set set = this.watchers;
        synchronized (set) {
            Iterator a2 = this.watchers.iterator();
            while (a2.hasNext()) {
                FileWatcher a3 = (FileWatcher)a2.next();
                try {
                    a3.check();
                }
                catch (Exception a4) {
                    FileTail.char(new StringBuilder().insert(0, PageList.char("V\u0019f\u000fs\u0012`\u0003f\u0013#\u0012{\u0014f\u0007w\u001el\u00199W")).append(a4.getMessage()).toString(), a4);
                    continue;
                }
                break;
            }
            return;
        }
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        FileWatcherThread fileWatcherThread = this;
        this.thread = new Thread((Runnable)this, Tail.char("pWZ[a_B]^[Dj^LS_R"));
        fileWatcherThread.thread.setDaemon(true);
        fileWatcherThread.thread.start();
    }

    public void add(FileWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void remove(FileWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public static synchronized FileWatcherThread getInstance() {
        if (instance == null) {
            instance = new FileWatcherThread();
        }
        return instance;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void die() {
        this.shouldDie = true;
    }
}

