/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import com.jeesite.common.cache.JedisUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SysInfo;
import org.hyperic.sigar.cmd.Watch;

public class OperatingSystem
extends SysInfo {
    public static final String NAME_NETBSD = "NetBSD";
    public static final String NAME_OPENBSD = "OpenBSD";
    public static final String NAME_AIX = "AIX";
    public static final String NAME_NETWARE = "NetWare";
    public static final String NAME_WIN32 = "Win32";
    private static final Map supportedPlatforms;
    public static final String NAME_FREEBSD = "FreeBSD";
    private String cpuEndian;
    private String dataModel;
    public static final String NAME_LINUX = "Linux";
    public static final String NAME_HPUX = "HPUX";
    public static final boolean IS_WIN32;
    public static final String[] UNIX_NAMES;
    public static final String NAME_MACOSX = "MacOSX";
    public static final String NAME_SOLARIS = "Solaris";
    public static final String[] NAMES;
    public static final String[] WIN32_NAMES;
    private static OperatingSystem instance;

    public static synchronized OperatingSystem getInstance() {
        if (instance == null) {
            OperatingSystem a2 = new OperatingSystem();
            try (Sigar a3 = new Sigar();){
                a2.gather(a3);
            }
            Properties a4 = System.getProperties();
            a2.dataModel = a4.getProperty(Watch.char("\u001aV\u0007\r\bQ\nKGG\bW\b\r\u0004L\rF\u0005"));
            a2.cpuEndian = a4.getProperty(JedisUtils.char(" y=\"0|&\"6b7e2b"));
            instance = a2;
        }
        return instance;
    }

    public static boolean isWin32(String name) {
        return NAME_WIN32.equals(name);
    }

    public static boolean isSupported(String name) {
        return supportedPlatforms.get(name) == Boolean.TRUE;
    }

    public static void main(String[] args) {
        System.out.println(new StringBuilder().insert(0, Watch.char("\bO\u0005\rG\rG\rG\rG\rG\rG\rG")).append(Arrays.asList(NAMES)).toString());
        OperatingSystem a2 = OperatingSystem.getInstance();
        System.out.println(new StringBuilder().insert(0, JedisUtils.char("h6\u007f0~:|'e<b}\"}\"}\"")).append(a2.getDescription()).toString());
        System.out.println(new StringBuilder().insert(0, Watch.char("\u0007B\u0004FG\rG\rG\rG\rG\rG\rG")).append(a2.name).toString());
        System.out.println(new StringBuilder().insert(0, JedisUtils.char("z6~ e<b}\"}\"}\"}\"}\"")).append(a2.version).toString());
        System.out.println(new StringBuilder().insert(0, Watch.char("\bQ\nKG\rG\rG\rG\rG\rG\rG")).append(a2.arch).toString());
        System.out.println(new StringBuilder().insert(0, JedisUtils.char("|2x0ds`6z6`}\"}\"}\"")).append(a2.patchLevel).toString());
        System.out.println(new StringBuilder().insert(0, Watch.char("\u001fF\u0007G\u0006QG\rG\rG\rG\rG\rG")).append(a2.vendor).toString());
        System.out.println(new StringBuilder().insert(0, JedisUtils.char("z6b7c!,=m>i}\"}\"}\"")).append(a2.vendorName).toString());
        System.out.println(new StringBuilder().insert(0, Watch.char("\u001fF\u0007G\u0006QIU\fQ\u001aJ\u0006MG\rG")).append(a2.vendorVersion).toString());
    }

    static {
        int n;
        String[] stringArray = new String[8];
        stringArray[0] = NAME_LINUX;
        stringArray[1] = NAME_SOLARIS;
        stringArray[2] = NAME_HPUX;
        stringArray[3] = NAME_AIX;
        stringArray[4] = NAME_MACOSX;
        stringArray[5] = NAME_FREEBSD;
        stringArray[6] = NAME_OPENBSD;
        stringArray[7] = NAME_NETBSD;
        UNIX_NAMES = stringArray;
        String[] stringArray2 = new String[1];
        stringArray2[0] = NAME_WIN32;
        WIN32_NAMES = stringArray2;
        IS_WIN32 = System.getProperty(JedisUtils.char("c \"=m>i")).indexOf(Watch.char(">J\u0007G\u0006T\u001a")) != -1;
        supportedPlatforms = new HashMap();
        int n2 = UNIX_NAMES.length + WIN32_NAMES.length;
        String[] stringArray3 = new String[n2];
        System.arraycopy(UNIX_NAMES, 0, stringArray3, 0, UNIX_NAMES.length);
        stringArray3[n2 - 1] = NAME_WIN32;
        NAMES = stringArray3;
        int n3 = n = 0;
        while (n3 < NAMES.length) {
            supportedPlatforms.put(NAMES[n++], Boolean.TRUE);
            n3 = n;
        }
        instance = null;
    }

    private /* synthetic */ OperatingSystem() {
        OperatingSystem a2;
    }

    public String getCpuEndian() {
        return this.cpuEndian;
    }

    public String getDataModel() {
        return this.dataModel;
    }
}

