/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import com.jeesite.modules.sys.utils.ModuleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import junit.framework.TestCase;
import org.hyperic.sigar.Humidor;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.ptql.ProcessQueryFactory;

public abstract class SigarTestCase
extends TestCase {
    private static boolean verbose;
    private static PrintStream out;
    private Properties props;
    private static Sigar sigar;
    protected static final boolean JDK_14_COMPAT;

    public void assertEqualsTrace(String msg, long expected, long actual) {
        SigarTestCase sigarTestCase = this;
        String string = msg;
        long l2 = expected;
        this.traceln(string + SigarException.char("`") + actual + ModuleUtils.char("m") + l2);
        SigarTestCase.assertEquals((String)string, (long)l2, (long)actual);
    }

    public static void setWriter(PrintStream value) {
        out = value;
    }

    public void assertTrueTrace(String msg, String value) {
        SigarTestCase sigarTestCase = this;
        String string = msg;
        String string2 = value;
        this.traceln(string + ModuleUtils.char("\u007f") + string2);
        SigarTestCase.assertTrue((String)string, (string2 != null ? 1 : 0) != 0);
    }

    public void assertValidFieldTrace(String msg, long value) {
        if (value != -1L) {
            this.assertGtEqZeroTrace(msg, value);
        }
    }

    public void assertGtZeroTrace(String msg, long value) {
        SigarTestCase sigarTestCase = this;
        String string = msg;
        long l2 = value;
        this.traceln(string + SigarException.char("`") + l2);
        SigarTestCase.assertTrue((String)string, (l2 > 0L ? 1 : 0) != 0);
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SigarTestCase(String string) {
        super(string);
        SigarTestCase sigarTestCase = this;
        sigarTestCase.props = new Properties();
        File a2 = new File(System.getProperty(ModuleUtils.char("7>'?l%- '")), SigarException.char("s~4j<\u007fs}/b-h/y4h."));
        if (!a2.exists()) return;
        FileInputStream a3 = null;
        a3 = new FileInputStream(a2);
        this.props.load(a3);
        if (a3 == null) return;
        try {
            a3.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (IOException a4) {
            try {
                a4.printStackTrace();
                if (a3 == null) return;
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (a3 != null) {
                    try {
                        a3.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
            try {
                a3.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public static void setVerbose(boolean value) {
        verbose = value;
    }

    /*
     * WARNING - void declaration
     */
    public void assertIndexOfTrace(String string, String string2, String string3) {
        void substr;
        void value;
        void msg;
        void v0 = msg;
        this.assertTrueTrace((String)v0, (String)value);
        SigarTestCase.assertTrue((String)v0, (string2.indexOf((String)substr) != -1 ? 1 : 0) != 0);
    }

    public static PrintStream getWriter() {
        return out;
    }

    public String getProperty(String key, String val) {
        return this.getProperties().getProperty(key, val);
    }

    static {
        sigar = null;
        verbose = "true".equals(System.getProperty(ModuleUtils.char("1$%,0c6(19\u0014(0/->'")));
        JDK_14_COMPAT = System.getProperty(SigarException.char("g<{<#.}8n4k4n<y4b3#+h/~4b3")).compareTo(ModuleUtils.char("scv")) >= 0;
        out = System.out;
    }

    public long getInvalidPid() {
        return 666666L;
    }

    public static void closeSigar() {
        if (sigar != null) {
            sigar.close();
            sigar = null;
        }
        ProcessQueryFactory.getInstance().clear();
        Humidor.getInstance().close();
    }

    public void traceln(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().println(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void assertLengthTrace(String string, String string2) {
        void value;
        void msg;
        void v0 = msg;
        this.assertTrueTrace((String)v0, (String)value);
        SigarTestCase.assertTrue((String)v0, (string2.length() > 0 ? 1 : 0) != 0);
    }

    public Sigar getSigar() {
        if (sigar == null) {
            sigar = new Sigar();
            if (SigarTestCase.getVerbose()) {
                sigar.enableLogging(true);
            }
        }
        return sigar;
    }

    public void trace(String msg) {
        if (SigarTestCase.getVerbose()) {
            SigarTestCase.getWriter().print(msg);
        }
    }

    public void traceMethods(Object obj) throws Exception {
        int a2;
        Method[] a3 = obj.getClass().getDeclaredMethods();
        this.traceln("");
        int n = a2 = 0;
        while (n < a3.length) {
            String a4 = a3[a2].getName();
            if (a4.startsWith(SigarException.char(":h)"))) {
                Object a5 = a3[a2].invoke(obj, new Object[0]);
                if (a5 instanceof Long && (Long)a5 == -1L) {
                    a5 = ModuleUtils.char("\f\u0002\u0016\u0004\u000f\u001d\u000e");
                }
                this.traceln(new StringBuilder().insert(0, a4).append(SigarException.char("`")).append(a5).toString());
            }
            n = ++a2;
        }
    }

    public void assertGtEqZeroTrace(String msg, long value) {
        SigarTestCase sigarTestCase = this;
        String string = msg;
        long l2 = value;
        this.traceln(string + ModuleUtils.char("\u007f") + l2);
        SigarTestCase.assertTrue((String)string, (l2 >= 0L ? 1 : 0) != 0);
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }
}

