/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.win32;

import com.jeesite.common.j2cache.autoconfigure.J2CacheAutoConfiguration;
import com.jeesite.common.validator.ValidatorUtils;
import java.util.List;
import java.util.Vector;
import org.hyperic.sigar.win32.Win32;
import org.hyperic.sigar.win32.Win32Exception;

public class RegistryKey
extends Win32 {
    private static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final RegistryKey ClassesRoot = new RegistryKey(Integer.MIN_VALUE);
    private static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    private static final int HKEY_USERS = -2147483645;
    public static final RegistryKey CurrentUser = new RegistryKey(-2147483647L);
    private static final int HKEY_CURRENT_CONFIG = -2147483643;
    private String subkey;
    private static final int HKEY_CURRENT_USER = -2147483647;
    private long m_hkey;
    public static final RegistryKey LocalMachine = new RegistryKey(-2147483646L);
    private static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int HKEY_DYN_DATA = -2147483642;

    public RegistryKey createSubKey(String subkey, String value) throws Win32Exception {
        RegistryKey a2 = null;
        long a3 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a3 != 0L) {
            a2 = new RegistryKey(a3);
            if (a2 != null) {
                RegistryKey registryKey = a2;
                registryKey.setStringValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(ValidatorUtils.char("{fL{L4]f[uJ}Ps\u001egKvUqG"));
        }
        return a2;
    }

    public int getIntValue(String name, int defaultValue) {
        try {
            int a2 = this.getIntValue(name);
            return a2;
        }
        catch (Win32Exception a3) {
            int a4 = defaultValue;
            return a4;
        }
    }

    private static native /* synthetic */ String RegQueryStringValue(long var0, String var2);

    private static native /* synthetic */ void RegQueryMultiStringValue(long var0, String var2, List var3);

    private static native /* synthetic */ long RegOpenKey(long var0, String var2);

    public int getIntValue(String name) throws Win32Exception {
        int a2 = 0;
        try {
            a2 = RegistryKey.RegQueryIntValue(this.m_hkey, name);
            return a2;
        }
        catch (Throwable a3) {
            throw new Win32Exception(ValidatorUtils.char("{fL{L4YqJ`WzY4WzJ4HuRa["));
        }
    }

    public void flush() {
        RegistryKey.RegFlushKey(this.m_hkey);
    }

    private static native /* synthetic */ byte[] RegQueryBufferValue(long var0, String var2);

    private static native /* synthetic */ String RegEnumValueName(long var0, int var2);

    public synchronized void close() {
        if (this.m_hkey != 0L) {
            RegistryKey.RegCloseKey(this.m_hkey);
            this.m_hkey = 0L;
        }
    }

    private static native /* synthetic */ int RegQueryIntValue(long var0, String var2);

    public String getSubKeyName() {
        return this.subkey;
    }

    protected void finalize() {
        this.close();
    }

    public String getStringValue(String name) throws Win32Exception {
        String a2 = RegistryKey.RegQueryStringValue(this.m_hkey, name);
        if (a2 == null) {
            throw new Win32Exception(J2CacheAutoConfiguration.char("cXTET\nAOR^ODA\nU^TCHM\u0006\\GFSO"));
        }
        return a2;
    }

    public RegistryKey createSubKey(String subkey) {
        return new RegistryKey(RegistryKey.RegCreateKey(this.m_hkey, subkey));
    }

    private static native /* synthetic */ String RegEnumKey(long var0, int var2);

    private static native /* synthetic */ int RegLoadKey(long var0, String var2, String var3);

    public String getStringValue(String name, String defaultValue) {
        try {
            String a2 = this.getStringValue(name);
            return a2;
        }
        catch (Win32Exception a3) {
            String a4 = defaultValue;
            return a4;
        }
    }

    public void deleteSubKeyTree(String subkey) {
    }

    public void getMultiStringValue(String name, List values) throws Win32Exception {
        RegistryKey.RegQueryMultiStringValue(this.m_hkey, name, values);
    }

    public String[] getValueNames() {
        String a2;
        Vector<String> a3 = new Vector<String>();
        int a4 = 0;
        RegistryKey registryKey = this;
        while ((a2 = RegistryKey.RegEnumValueName(registryKey.m_hkey, a4)) != null) {
            registryKey = this;
            ++a4;
            a3.add(a2);
        }
        Vector<String> vector = a3;
        return vector.toArray(new String[vector.size()]);
    }

    public void setStringValue(String name, String value) throws Win32Exception {
        if (RegistryKey.RegSetStringValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(ValidatorUtils.char("QLfQf\u001eg[`J}Ps\u001egJfWzY4HuRa["));
        }
    }

    private static native /* synthetic */ int RegSetStringValue(long var0, String var2, String var3);

    public RegistryKey createSubKey(String subkey, int value) throws Win32Exception {
        RegistryKey a2 = null;
        long a3 = RegistryKey.RegCreateKey(this.m_hkey, subkey);
        if (a3 != 0L) {
            a2 = new RegistryKey(a3);
            if (a2 != null) {
                RegistryKey registryKey = a2;
                registryKey.setIntValue(null, value);
                return registryKey;
            }
        } else {
            throw new Win32Exception(J2CacheAutoConfiguration.char("oTXIX\u0006ITOG^ODA\nU_DACS"));
        }
        return a2;
    }

    private /* synthetic */ RegistryKey() {
        RegistryKey a2;
    }

    private static native /* synthetic */ int RegCloseKey(long var0);

    private static native /* synthetic */ int RegSetIntValue(long var0, String var2, int var3);

    private static native /* synthetic */ int RegFlushKey(long var0);

    public String[] getSubKeyNames() {
        String a2;
        Vector<String> a3 = new Vector<String>();
        int a4 = 0;
        RegistryKey registryKey = this;
        while ((a2 = RegistryKey.RegEnumKey(registryKey.m_hkey, a4)) != null) {
            registryKey = this;
            ++a4;
            a3.add(a2);
        }
        Vector<String> vector = a3;
        return vector.toArray(new String[vector.size()]);
    }

    public void deleteValue(String name) {
        RegistryKey.RegDeleteValue(this.m_hkey, name);
    }

    private /* synthetic */ RegistryKey(long a2) {
        RegistryKey a3;
        a3.m_hkey = a2;
    }

    private static native /* synthetic */ long RegCreateKey(long var0, String var2);

    private static native /* synthetic */ int RegDeleteKey(long var0, String var2);

    public void deleteSubKey(String subkey) {
        RegistryKey.RegDeleteKey(this.m_hkey, subkey);
    }

    public RegistryKey openSubKey(String subkey) throws Win32Exception {
        long a2 = RegistryKey.RegOpenKey(this.m_hkey, subkey);
        if (a2 == 0L) {
            throw new Win32Exception(ValidatorUtils.char("QLfQf\u001e{NqP}Ps\u001egKvUqG"));
        }
        new RegistryKey(a2).subkey = subkey;
        return new RegistryKey(a2);
    }

    public void setIntValue(String name, int value) throws Win32Exception {
        if (RegistryKey.RegSetIntValue(this.m_hkey, name, value) != 0) {
            throw new Win32Exception(J2CacheAutoConfiguration.char("oTXIX\u0006YC^RCHM\u0006CH^\u0006\\GFSO"));
        }
    }

    private static native /* synthetic */ int RegDeleteValue(long var0, String var2);
}

